/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.system.ThreadAction;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestThreadAction {
    private static String level;

    @BeforeClass
    public static void beforeClass() {
        level = LogCtl.getLevel(ThreadAction.class);
        LogCtl.setLevel(ThreadAction.class, (String)"ERROR");
    }

    @AfterClass
    public static void afterClass() {
        LogCtl.setLevel(ThreadAction.class, (String)level);
    }

    @Test
    public void action_01() {
        AtomicInteger x = new AtomicInteger(0);
        ThreadAction action = ThreadAction.create(() -> x.incrementAndGet());
        Assert.assertEquals((long)0L, (long)x.get());
        action.run();
        Assert.assertEquals((long)1L, (long)x.get());
    }

    @Test
    public void action_02() {
        AtomicInteger x = new AtomicInteger(0);
        ThreadAction action = ThreadAction.create(null, () -> x.incrementAndGet(), null);
        Assert.assertEquals((long)0L, (long)x.get());
        action.run();
        Assert.assertEquals((long)1L, (long)x.get());
    }

    @Test
    public void action_03() {
        AtomicInteger before = new AtomicInteger(0);
        AtomicInteger runnable = new AtomicInteger(0);
        AtomicInteger after = new AtomicInteger(0);
        ThreadAction action = ThreadAction.create(() -> before.incrementAndGet(), () -> runnable.incrementAndGet(), () -> after.incrementAndGet());
        action.run();
        Assert.assertEquals((long)1L, (long)before.get());
        Assert.assertEquals((long)1L, (long)runnable.get());
        Assert.assertEquals((long)1L, (long)after.get());
    }

    @Test
    public void action_04() {
        AtomicInteger before = new AtomicInteger(0);
        AtomicInteger runnable = new AtomicInteger(0);
        AtomicInteger after = new AtomicInteger(0);
        ThreadAction action = ThreadAction.create(() -> {
            before.incrementAndGet();
            TestThreadAction.bang();
        }, () -> runnable.incrementAndGet(), () -> after.incrementAndGet());
        action.run();
        Assert.assertEquals((long)1L, (long)before.get());
        Assert.assertEquals((long)0L, (long)runnable.get());
        Assert.assertEquals((long)0L, (long)after.get());
    }

    @Test(expected=TestThreadActionException.class)
    public void action_05() {
        AtomicInteger before = new AtomicInteger(0);
        AtomicInteger runnable = new AtomicInteger(0);
        AtomicInteger after = new AtomicInteger(0);
        ThreadAction action = ThreadAction.create(() -> before.incrementAndGet(), () -> {
            runnable.incrementAndGet();
            TestThreadAction.bang();
        }, () -> after.incrementAndGet());
        action.run();
        Assert.assertEquals((long)1L, (long)before.get());
        Assert.assertEquals((long)1L, (long)runnable.get());
        Assert.assertEquals((long)0L, (long)after.get());
    }

    @Test
    public void action_06() {
        AtomicInteger before = new AtomicInteger(0);
        AtomicInteger runnable = new AtomicInteger(0);
        AtomicInteger after = new AtomicInteger(0);
        ThreadAction action = ThreadAction.create(() -> before.incrementAndGet(), () -> {
            runnable.incrementAndGet();
            TestThreadAction.bang();
        }, () -> after.incrementAndGet());
        try {
            action.run();
        }
        catch (TestThreadActionException testThreadActionException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)before.get());
        Assert.assertEquals((long)1L, (long)runnable.get());
        Assert.assertEquals((long)1L, (long)after.get());
    }

    @Test
    public void action_07() {
        AtomicInteger before = new AtomicInteger(0);
        AtomicInteger runnable = new AtomicInteger(0);
        AtomicInteger after = new AtomicInteger(0);
        ThreadAction action = ThreadAction.create(() -> before.incrementAndGet(), () -> runnable.incrementAndGet(), () -> {
            after.incrementAndGet();
            TestThreadAction.bang();
        });
        action.run();
        Assert.assertEquals((long)1L, (long)before.get());
        Assert.assertEquals((long)1L, (long)runnable.get());
        Assert.assertEquals((long)1L, (long)after.get());
    }

    private static void bang() {
        throw new TestThreadActionException();
    }

    static class TestThreadActionException
    extends RuntimeException {
        TestThreadActionException() {
        }
    }
}

