/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerException;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDataset;
    }

    public Object open(Assembler a, Resource root2, Mode mode) {
        Dataset ds = this.createDataset(a, root2, mode);
        return ds;
    }

    public Dataset createDataset(Assembler a, Resource root2, Mode mode) {
        Resource dftGraph = GraphUtils.getResourceValue(root2, DatasetAssemblerVocab.pDefaultGraph);
        if (dftGraph == null) {
            dftGraph = GraphUtils.getResourceValue(root2, DatasetAssemblerVocab.pGraph);
        }
        Model dftModel = null;
        dftModel = dftGraph != null ? a.openModel(dftGraph) : GraphFactory.makeDefaultModel();
        Dataset ds = DatasetFactory.create(dftModel);
        List<RDFNode> nodes = GraphUtils.multiValue(root2, DatasetAssemblerVocab.pNamedGraph);
        for (RDFNode n : nodes) {
            if (!(n instanceof Resource)) {
                throw new DatasetAssemblerException(root2, "Not a resource: " + FmtUtils.stringForRDFNode(n));
            }
            Resource r = (Resource)n;
            String gName = GraphUtils.getAsStringValue(r, DatasetAssemblerVocab.pGraphName);
            Resource g = GraphUtils.getResourceValue(r, DatasetAssemblerVocab.pGraph);
            if (g == null) {
                g = GraphUtils.getResourceValue(r, DatasetAssemblerVocab.pGraphAlt);
                if (g != null) {
                    Log.warn((Object)((Object)this), (String)"Use of old vocabulary: use :graph not :graphData");
                } else {
                    throw new DatasetAssemblerException(root2, "no graph for: " + gName);
                }
            }
            Model m = a.openModel(g);
            ds.addNamedModel(gName, m);
        }
        AssemblerUtils.mergeContext(root2, ds.getContext());
        return ds;
    }
}

