/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.ResultSetAdapter;
import org.apache.jena.sparql.exec.RowSetAdapter;
import org.apache.jena.sparql.exec.RowSetMem;
import org.apache.jena.sparql.exec.RowSetRewindable;
import org.apache.jena.sparql.exec.RowSetStream;

public interface RowSet
extends IteratorCloseable<Binding> {
    public static RowSet adapt(ResultSet resultSet) {
        if (resultSet instanceof ResultSetAdapter) {
            return ((ResultSetAdapter)resultSet).get();
        }
        return new RowSetAdapter(resultSet);
    }

    public boolean hasNext();

    public Binding next();

    public List<Var> getResultVars();

    default public RowSetRewindable rewindable() {
        return RowSetMem.create(this);
    }

    default public RowSet materialize() {
        return this.rewindable();
    }

    public long getRowNumber();

    default public Stream<Binding> stream() {
        return Iter.asStream((Iterator)((Object)this));
    }

    public void close();

    public static RowSet create(QueryIterator qIter, List<Var> vars) {
        return new RowSetStream(vars, qIter);
    }

    public static class Exception
    extends QueryException {
        public Exception(String msg) {
            super(msg);
        }

        public Exception(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

