/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.RegistryHttpClient;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.QueryExecHTTP;
import org.apache.jena.sparql.exec.http.QueryExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(Service.class);
    public static final String base = "http://jena.apache.org/ARQ#";
    public static final Symbol serviceParams = ARQ.serviceParams;
    public static final Symbol httpServiceAllowed = ARQ.httpServiceAllowed;
    public static final Symbol httpQueryClient = ARQ.httpQueryClient;
    public static final Symbol httpServiceSendMode = ARQ.httpServiceSendMode;
    public static final Symbol httpQueryTimeout = ARQ.httpQueryTimeout;
    private static Context emptyContext = Context.emptyContext();
    public static final String baseOld = "http://jena.hpl.hp.com/Service#";
    public static final Symbol oldQueryClient = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryClient");
    public static final Symbol oldServiceContext = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceContext");
    public static final Symbol oldServiceAllowed = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceAllowed");
    public static final Symbol oldQueryTimeout = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryTimeout");
    public static final Symbol oldQueryCompression = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryCompression");
    public static final Symbol serviceAllowed = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceAllowed");

    private Service() {
    }

    private void oldCheckForOldParameters(Context context2) {
        if (context2 == null) {
            return;
        }
        this.checkForOldParameters(context2, oldQueryClient);
        this.checkForOldParameters(context2, oldServiceContext);
        this.checkForOldParameters(context2, oldServiceAllowed);
        this.checkForOldParameters(context2, oldQueryTimeout);
        this.checkForOldParameters(context2, oldQueryCompression);
    }

    private void checkForOldParameters(Context context2, Symbol oldSymbol) {
        if (context2.isDefined(oldSymbol)) {
            Log.warnOnce((Logger)LOGGER, (String)("Service context parameter '" + oldSymbol.getSymbol() + "' no longer used - see ARQ constants for replacements."), (Object)oldSymbol);
        }
    }

    public static QueryIterator exec(OpService op, Context context2) {
        if (context2 == null) {
            context2 = emptyContext;
        }
        if (context2 != null && context2.isFalse(httpServiceAllowed)) {
            throw new QueryExecException("SERVICE execution disabled");
        }
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        boolean silent = op.getSilent();
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        String serviceURL = op.getService().getURI();
        Op opRemote = op.getSubOp();
        Query query = OpAsQuery.asQuery(opRemote);
        long timeoutMillis = Service.timeoutFromContext(context2);
        Params serviceParams = Service.getServiceParamsFromContext(serviceURL, context2);
        java.net.http.HttpClient httpClient = Service.chooseHttpClient(serviceURL, context2);
        QuerySendMode querySendMode = Service.chooseQuerySendMode(serviceURL, context2, QuerySendMode.asGetWithLimitBody);
        QueryExecHTTP qExec = (QueryExecHTTP)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)((QueryExecHTTPBuilder)QueryExecHTTP.newBuilder().endpoint(serviceURL)).timeout(timeoutMillis, TimeUnit.MILLISECONDS)).query(query)).params(serviceParams)).context(context2)).httpClient(httpClient)).sendMode(querySendMode)).build();
        try {
            RowSet rowSet = qExec.select().materialize();
            QueryIterator qIter = QueryIterPlainWrapper.create((Iterator<Binding>)((Object)rowSet));
            return qIter;
        }
        catch (HttpException ex) {
            throw QueryExceptionHTTP.rewrap(ex);
        }
    }

    private static java.net.http.HttpClient chooseHttpClient(String serviceURL, Context context2) {
        java.net.http.HttpClient httpClient = (java.net.http.HttpClient)RegistryHttpClient.get().find(serviceURL);
        if (httpClient == null && context2 != null) {
            Object client;
            if (context2.isDefined(oldQueryClient)) {
                LOGGER.warn("Deprecated context symbol " + oldQueryClient + ". See " + httpQueryClient + ".");
            }
            if ((client = context2.get(httpQueryClient)) != null) {
                if (client instanceof HttpClient) {
                    LOGGER.warn("Found Apache HttpClient for content symbol " + httpQueryClient + ". Jena now uses java.net.http.HttpClient");
                    client = null;
                } else if (client instanceof java.net.http.HttpClient) {
                    httpClient = (java.net.http.HttpClient)client;
                } else {
                    LOGGER.warn("Not recognized " + httpQueryClient + " -> " + client);
                }
            }
        }
        if (httpClient == null) {
            httpClient = HttpEnv.getDftHttpClient();
        }
        return httpClient;
    }

    private static QuerySendMode chooseQuerySendMode(String serviceURL, Context context2, QuerySendMode dftValue) {
        if (context2 == null) {
            return dftValue;
        }
        return context2.get(httpServiceSendMode, dftValue);
    }

    static long timeoutFromContext(Context context2) {
        return Service.parseTimeout(context2.get(httpQueryTimeout));
    }

    static long parseTimeout(Object obj) {
        if (obj == null) {
            return -1L;
        }
        try {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            LOGGER.warn("Can't interpret timeout: " + obj);
            return -1L;
        }
        catch (Exception ex) {
            LOGGER.warn("Exception setting timeout (context) from: " + obj);
            return -1L;
        }
    }

    static Params getServiceParamsFromContext(String serviceURI, Context context2) throws QueryExecException {
        Params params = Params.create();
        Object obj = context2.get(serviceParams);
        if (obj == null) {
            return params;
        }
        try {
            Map paramsMap;
            Map serviceParams = (Map)obj;
            if (serviceParams != null && (paramsMap = (Map)serviceParams.get(serviceURI)) != null) {
                for (String param : paramsMap.keySet()) {
                    if ("query".equals(param)) {
                        throw new QueryExecException("ARQ serviceParams overrides the 'query' SPARQL protocol parameter");
                    }
                    List values = (List)paramsMap.get(param);
                    for (String value : values) {
                        params.add(param, value);
                    }
                }
            }
            return params;
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to process " + obj + " : context value of ARQ.serviceParams");
            return null;
        }
    }
}

