/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReader;
import org.apache.jena.riot.resultset.ResultSetReaderFactory;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.riot.rowset.RowSetReaderRegistry;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.Context;

public class ResultSetReaderRegistry {
    private static Map<Lang, ResultSetReaderFactory> registry = new HashMap<Lang, ResultSetReaderFactory>();
    private static boolean initialized = false;

    public static ResultSetReaderFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static void register(Lang lang, ResultSetReaderFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RowSetReaderRegistry.init();
        ResultSetReaderFactory factory = lang -> new ResultSetReaderAdapter(lang);
        ResultSetReaderRegistry.register(ResultSetLang.RS_XML, factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_JSON, factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_CSV, factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_TSV, factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_None, factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_Thrift, factory);
        ResultSetReaderRegistry.register(ResultSetLang.RS_Protobuf, factory);
    }

    private static class ResultSetReaderAdapter
    implements ResultSetReader {
        private final Lang lang;
        private final RowSetReaderFactory rowSetFactory;

        ResultSetReaderAdapter(Lang lang) {
            this.lang = lang;
            this.rowSetFactory = RowSetReaderRegistry.getFactory(lang);
        }

        private RowSetReader reader() {
            return this.rowSetFactory.create(this.lang);
        }

        @Override
        public ResultSet read(InputStream in, Context context2) {
            RowSet rowSet = this.reader().read(in, context2);
            if (rowSet == null) {
                return null;
            }
            return ResultSet.adapt(rowSet);
        }

        @Override
        public ResultSet read(Reader in, Context context2) {
            RowSet rowSet = this.reader().read(in, context2);
            if (rowSet == null) {
                return null;
            }
            return ResultSet.adapt(rowSet);
        }

        @Override
        public SPARQLResult readAny(InputStream in, Context context2) {
            QueryExecResult result = this.reader().readAny(in, context2);
            return SPARQLResult.adapt(result);
        }
    }
}

