/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNotSupported;

public class TransactionalNull
implements Transactional {
    private ThreadLocal<Boolean> inTransaction = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private ThreadLocal<TxnType> txnType = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<ReadWrite> txnMode = ThreadLocal.withInitial(() -> null);

    public static Transactional create() {
        return new TransactionalNull();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txnMode.get();
    }

    @Override
    public TxnType transactionType() {
        return this.txnType.get();
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert(readWrite));
    }

    @Override
    public void begin(TxnType type) {
        if (this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Already in transaction");
        }
        this.inTransaction.set(true);
        this.txnType.set(type);
        this.txnMode.set(TxnType.initial(type));
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        if (!this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Not in transaction");
        }
        this.txnMode.set(ReadWrite.WRITE);
        return true;
    }

    @Override
    public void commit() {
        if (!this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Not in transaction");
        }
        this.inTransaction.set(false);
    }

    @Override
    public void abort() {
        if (!this.inTransaction.get().booleanValue()) {
            throw new JenaTransactionException("Not in transaction");
        }
        this.inTransaction.set(false);
    }

    @Override
    public boolean isInTransaction() {
        return this.inTransaction.get();
    }

    @Override
    public void end() {
        this.clearup();
    }

    private void clearup() {
        this.inTransaction.set(false);
        this.inTransaction.remove();
        this.txnType.set(null);
        this.txnType.remove();
    }

    public void remove() {
        this.inTransaction.remove();
    }

    private static class Example
    implements Transactional {
        private final Transactional txn = new TransactionalNotSupported();

        private Example() {
        }

        @Override
        public void begin() {
            this.txn.begin();
        }

        @Override
        public void begin(TxnType txnType) {
            this.txn.begin(txnType);
        }

        @Override
        public void commit() {
            this.txn.commit();
        }

        @Override
        public void abort() {
            this.txn.abort();
        }

        @Override
        public boolean promote(Transactional.Promote mode) {
            return this.txn.promote(mode);
        }

        @Override
        public boolean isInTransaction() {
            return this.txn.isInTransaction();
        }

        @Override
        public void end() {
            this.txn.end();
        }

        @Override
        public ReadWrite transactionMode() {
            return this.txn.transactionMode();
        }

        @Override
        public TxnType transactionType() {
            return this.txn.transactionType();
        }
    }
}

