/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.impl.GraphPlain;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.graph.GraphSink;
import org.apache.jena.sparql.graph.GraphTxn;
import org.apache.jena.sys.JenaSystem;

public class GraphFactory {
    public static Graph createGraphMem() {
        return Factory.createGraphMem();
    }

    public static GraphTxn createTxnGraph() {
        return new GraphTxn();
    }

    public static Graph createDefaultGraph() {
        return SystemARQ.UsePlainGraph ? GraphFactory.createPlainGraph() : GraphFactory.createJenaDefaultGraph();
    }

    public static Graph createJenaDefaultGraph() {
        return Factory.createDefaultGraph();
    }

    public static Graph createPlainGraph() {
        return GraphPlain.plain();
    }

    public static Graph sinkGraph() {
        return new GraphSink();
    }

    public static Model makeJenaDefaultModel() {
        return ModelFactory.createDefaultModel();
    }

    public static Model makeDefaultModel() {
        return ModelFactory.createModelForGraph((Graph)GraphFactory.createDefaultGraph());
    }

    public static Model makePlainModel() {
        return ModelFactory.createModelForGraph((Graph)GraphFactory.createPlainGraph());
    }

    static {
        JenaSystem.init();
    }
}

