/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io.parser;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.json.io.JSONHandler;
import org.apache.jena.atlas.json.io.parser.JSONP;
import org.apache.jena.atlas.json.io.parser.TokenizerJSON;
import org.apache.jena.atlas.json.io.parserjavacc.JSONPrinter;

public class JSONParser {
    public static void parse(InputStream input) {
        JSONParser.parse(input, (JSONHandler)new JSONPrinter());
    }

    public static void parse(InputStream input, JSONHandler handler) {
        PeekReader r = PeekReader.makeUTF8((InputStream)input);
        TokenizerJSON t = new TokenizerJSON(r);
        JSONParser.parse(t, handler);
    }

    public static void parse(Reader reader) {
        JSONParser.parse(reader, (JSONHandler)new JSONPrinter());
    }

    public static void parse(Reader reader, JSONHandler handler) {
        PeekReader r = PeekReader.make((Reader)reader);
        TokenizerJSON t = new TokenizerJSON(r);
        JSONParser.parse(t, handler);
    }

    private static void parse(TokenizerJSON t, JSONHandler handler) {
        JSONP p = new JSONP(t, handler);
        p.parse();
    }

    public static void parseAny(Reader reader) {
        JSONParser.parseAny(reader, (JSONHandler)new JSONPrinter());
    }

    public static void parseAny(Reader reader, JSONHandler handler) {
        PeekReader r = PeekReader.make((Reader)reader);
        TokenizerJSON t = new TokenizerJSON(r);
        JSONParser.parseAny(t, handler);
    }

    public static void parseAny(InputStream input) {
        JSONParser.parseAny(input, (JSONHandler)new JSONPrinter());
    }

    public static void parseAny(InputStream input, JSONHandler handler) {
        PeekReader r = PeekReader.makeUTF8((InputStream)input);
        TokenizerJSON t = new TokenizerJSON(r);
        JSONParser.parseAny(t, handler);
    }

    private static void parseAny(TokenizerJSON t, JSONHandler handler) {
        JSONP p = new JSONP(t, handler);
        p.parseAny();
    }
}

