/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.sparql.mgt.ARQMgt;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.util.Symbol;

public class SystemARQ {
    public static boolean ValueExtensions = true;
    public static boolean StrictDateTimeFO = false;
    public static boolean EnableRomanNumerals = true;
    public static boolean UsePlainGraph = false;
    private static List<SystemInfo> versions = new ArrayList<SystemInfo>();

    public static void sync(Model model) {
        SystemARQ.sync(model.getGraph());
    }

    public static void sync(Graph graph) {
        SystemARQ.syncGraph(graph);
    }

    private static void syncGraph(Graph graph) {
        if (graph instanceof InfGraph) {
            SystemARQ.syncGraph(((InfGraph)graph).getRawGraph());
        } else if (graph instanceof Polyadic) {
            SystemARQ.syncGraph(((Polyadic)graph).getBaseGraph());
        } else if (graph instanceof GraphWrapper) {
            SystemARQ.syncGraph(((GraphWrapper)graph).get());
        } else if (graph instanceof WrappedGraph) {
            SystemARQ.syncGraph(((WrappedGraph)graph).getWrapped());
        } else {
            SystemARQ.syncObject(graph);
        }
    }

    public static void sync(Dataset dataset) {
        SystemARQ.sync(dataset.asDatasetGraph());
    }

    public static void sync(DatasetGraph dataset) {
        if (dataset instanceof Sync) {
            ((Sync)dataset).sync();
            return;
        }
        Graph gDft = dataset.getDefaultGraph();
        SystemARQ.syncIfNotView(gDft);
        dataset.listGraphNodes().forEachRemaining(gn -> SystemARQ.syncIfNotView(dataset.getGraph((Node)gn)));
    }

    private static void syncIfNotView(Graph g) {
        if (!(g instanceof GraphView)) {
            SystemARQ.sync(g);
        }
    }

    public static void syncObject(Object object) {
        if (object instanceof Sync) {
            ((Sync)object).sync();
        }
    }

    public static void registerSubSystem(SystemInfo systemInfo) {
        ARQMgt.register(systemInfo.getJmxPath() + ".system:type=SystemInfo", systemInfo);
        versions.add(systemInfo);
    }

    public static Iterator<SystemInfo> registeredSubsystems() {
        return versions.iterator();
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith("arq")) {
            throw new ARQInternalErrorException("Symbol short name begins with the ARQ namespace prefix: " + shortName);
        }
        if (shortName.startsWith("http:")) {
            throw new ARQInternalErrorException("Symbol short name begins with http: " + shortName);
        }
        return SystemARQ.allocSymbol("http://jena.apache.org/ARQ#", shortName);
    }

    public static Symbol allocSymbol(String base, String shortName) {
        return Symbol.create(base + shortName);
    }
}

