/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http;

import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.Push;
import org.apache.jena.sparql.exec.http.Params;

public class HttpOp {
    private HttpOp() {
    }

    public static String httpGetString(String url) {
        return HttpOp.httpGetString(HttpEnv.getDftHttpClient(), url, null);
    }

    public static String httpGetString(String url, String acceptHeader) {
        return HttpOp.httpGetString(HttpEnv.getDftHttpClient(), url, acceptHeader);
    }

    public static String httpGetString(HttpClient httpClient, String url) {
        return HttpOp.httpGetString(httpClient, url, null);
    }

    public static String httpGetString(HttpClient httpClient, String url, String acceptHeader) {
        HttpRequest request = HttpLib.newGetRequest(url, HttpLib.setAcceptHeader(acceptHeader));
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, request);
        try {
            return HttpLib.handleResponseRtnString(response);
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public static String httpPostRtnString(String url) {
        return HttpOp.httpPostRtnString(HttpEnv.getDftHttpClient(), url);
    }

    public static String httpPostRtnString(HttpClient httpClient, String url) {
        HttpRequest requestData = HttpLib.requestBuilderFor(url).POST(HttpRequest.BodyPublishers.noBody()).uri(HttpLib.toRequestURI(url)).build();
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, requestData);
        try {
            return HttpLib.handleResponseRtnString(response);
        }
        catch (HttpException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public static void httpPostForm(String url, Params params) {
        TypedInputStream in = HttpOp.execPostForm(HttpEnv.getDftHttpClient(), url, params, null);
        if (in != null) {
            in.close();
        }
    }

    public static TypedInputStream httpPostForm(String url, Params params, String acceptString) {
        return HttpOp.execPostForm(HttpEnv.getDftHttpClient(), url, params, acceptString);
    }

    private static TypedInputStream execPostForm(HttpClient httpClient, String url, Params params, String acceptString) {
        Objects.requireNonNull(url);
        acceptString = HttpLib.dft(acceptString, "*/*");
        URI uri = HttpLib.toRequestURI(url);
        String formData = params.httpString();
        HttpRequest request = HttpLib.requestBuilderFor(url).uri(uri).POST(HttpRequest.BodyPublishers.ofString(formData)).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", acceptString).build();
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, request);
        return HttpLib.handleResponseTypedInputStream(response);
    }

    public static JsonValue httpPostRtnJSON(String url) {
        try (TypedInputStream in = HttpOp.httpPostStream(url, "application/json");){
            JsonValue jsonValue = JSON.parseAny(in.getInputStream());
            return jsonValue;
        }
    }

    public static JsonValue httpGetJson(String url) {
        try (TypedInputStream in = HttpOp.httpGet(url, "application/json");){
            JsonValue jsonValue = JSON.parseAny(in.getInputStream());
            return jsonValue;
        }
    }

    public static TypedInputStream httpGet(String url) {
        return HttpOp.httpGet(HttpEnv.getDftHttpClient(), url);
    }

    public static TypedInputStream httpGet(String url, String acceptHeader) {
        return HttpOp.httpGet(HttpEnv.getDftHttpClient(), url, acceptHeader);
    }

    public static TypedInputStream httpGet(HttpClient httpClient, String url) {
        return HttpOp.httpGet(httpClient, url, null);
    }

    public static TypedInputStream httpGet(HttpClient httpClient, String url, String acceptHeader) {
        return HttpOp.execGet(httpClient, url, acceptHeader);
    }

    private static TypedInputStream execGet(HttpClient httpClient, String url, String acceptHeader) {
        if (acceptHeader == null) {
            acceptHeader = "*/*";
        }
        HttpRequest request = HttpLib.newGetRequest(url, HttpLib.setAcceptHeader(acceptHeader));
        return HttpOp.execGet(httpClient, request);
    }

    private static TypedInputStream execGet(HttpClient httpClient, HttpRequest request) {
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, request);
        return HttpLib.handleResponseTypedInputStream(response);
    }

    public static void httpPost(String url) {
        HttpOp.httpPost(HttpEnv.getDftHttpClient(), url, null, HttpRequest.BodyPublishers.noBody());
    }

    public static void httpPost(String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpOp.httpPost(HttpEnv.getDftHttpClient(), url, contentType, body);
    }

    public static void httpPost(String url, String contentType, String body) {
        HttpOp.httpPost(HttpEnv.getDftHttpClient(), url, contentType, HttpRequest.BodyPublishers.ofString(body));
    }

    public static void httpPost(HttpClient httpClient, String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpOp.execHttpPost(httpClient, url, contentType, body);
    }

    private static void execHttpPost(HttpClient httpClient, String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpOp.execPushData(httpClient, Push.POST, url, contentType, body);
    }

    public static TypedInputStream httpPostStream(String url) {
        return HttpOp.httpPostStream(HttpEnv.getDftHttpClient(), url);
    }

    public static TypedInputStream httpPostStream(String url, String acceptHeader) {
        return HttpOp.execPostStream(HttpEnv.getDftHttpClient(), url, acceptHeader);
    }

    public static TypedInputStream httpPostStream(HttpClient httpClient, String url) {
        return HttpOp.httpPostStream(httpClient, url, null);
    }

    public static TypedInputStream httpPostStream(HttpClient httpClient, String url, String acceptHeader) {
        return HttpOp.execPostStream(httpClient, url, acceptHeader);
    }

    private static TypedInputStream execPostStream(HttpClient httpClient, String url, String acceptHeader) {
        return HttpOp.execPostStream(httpClient, url, null, null, acceptHeader);
    }

    public static TypedInputStream httpPostStream(String url, String contentType, HttpRequest.BodyPublisher bodyContent) {
        return HttpOp.httpPostStream(HttpEnv.getDftHttpClient(), url, contentType, bodyContent);
    }

    public static TypedInputStream httpPostStream(String url, String contentType, String bodyContent) {
        return HttpOp.httpPostStream(HttpEnv.getDftHttpClient(), url, contentType, HttpRequest.BodyPublishers.ofString(bodyContent));
    }

    public static TypedInputStream httpPostStream(String url, String contentType, HttpRequest.BodyPublisher bodyContent, String acceptHeader) {
        return HttpOp.httpPostStream(HttpEnv.getDftHttpClient(), url, contentType, bodyContent, acceptHeader);
    }

    public static TypedInputStream httpPostStream(HttpClient httpClient, String url, String contentType, HttpRequest.BodyPublisher bodyContent) {
        return HttpOp.httpPostStream(httpClient, url, contentType, bodyContent, null);
    }

    public static TypedInputStream httpPostStream(HttpClient httpClient, String url, String contentType, HttpRequest.BodyPublisher bodyContent, String acceptHeader) {
        return HttpOp.execPostStream(httpClient, url, contentType, bodyContent, acceptHeader);
    }

    private static TypedInputStream execPostStream(HttpClient httpClient, String url, String contentType, HttpRequest.BodyPublisher bodyPublisher, String acceptHeader) {
        acceptHeader = HttpLib.dft(acceptHeader, "*/");
        if (bodyPublisher == null) {
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        }
        HttpRequest.Builder builder = HttpLib.requestBuilderFor(url).uri(HttpLib.toRequestURI(url));
        HttpLib.contentTypeHeader(builder, contentType);
        HttpLib.acceptHeader(builder, acceptHeader);
        HttpRequest request = builder.POST(bodyPublisher).build();
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, request);
        return HttpLib.handleResponseTypedInputStream(response);
    }

    public static void httpPut(String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpOp.httpPut(HttpEnv.getDftHttpClient(), url, contentType, body);
    }

    public static void httpPut(HttpClient httpClient, String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpOp.execPushData(httpClient, Push.PUT, url, contentType, body);
    }

    public static void httpPatch(String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpOp.httpPatch(HttpEnv.getDftHttpClient(), url, contentType, body);
    }

    public static void httpPatch(HttpClient httpClient, String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpOp.execPushData(httpClient, Push.PATCH, url, contentType, body);
    }

    private static void execPushData(HttpClient httpClient, Push style, String url, String contentType, HttpRequest.BodyPublisher body) {
        HttpLib.httpPushData(httpClient, style, url, HttpLib.setContentTypeHeader(contentType), body);
    }

    public static void httpDelete(String url) {
        HttpOp.httpDelete(HttpEnv.getDftHttpClient(), url);
    }

    public static void httpDelete(HttpClient httpClient, String url) {
        URI uri = HttpLib.toRequestURI(url);
        HttpRequest requestData = HttpLib.requestBuilderFor(url).DELETE().uri(uri).build();
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, requestData);
        HttpLib.handleResponseNoBody(response);
    }

    public static String httpOptions(String url) {
        return HttpOp.httpOptions(HttpEnv.getDftHttpClient(), url);
    }

    public static String httpOptions(HttpClient httpClient, String url) {
        HttpRequest.Builder builder = HttpLib.requestBuilderFor(url).uri(HttpLib.toRequestURI(url)).method("OPTIONS", HttpRequest.BodyPublishers.noBody());
        HttpRequest request = builder.build();
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, request);
        String allowValue = HttpLib.responseHeader(response, "Allow");
        HttpLib.handleResponseNoBody(response);
        return allowValue;
    }

    public static String httpHead(String url) {
        return HttpOp.httpHead(HttpEnv.getDftHttpClient(), url);
    }

    public static String httpHead(HttpClient httpClient, String url) {
        return HttpOp.httpHead(httpClient, url, null);
    }

    public static String httpHead(String url, String acceptHeader) {
        return HttpOp.httpHead(HttpEnv.getDftHttpClient(), url, acceptHeader);
    }

    public static String httpHead(HttpClient httpClient, String url, String acceptHeader) {
        HttpRequest.Builder builder = HttpLib.requestBuilderFor(url).uri(HttpLib.toRequestURI(url)).method("HEAD", HttpRequest.BodyPublishers.noBody());
        HttpLib.acceptHeader(builder, acceptHeader);
        HttpRequest request = builder.build();
        HttpResponse<InputStream> response = HttpLib.execute(httpClient, request);
        HttpLib.handleResponseNoBody(response);
        return response.headers().firstValue("Content-Type").orElse(null);
    }
}

