/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import org.apache.jena.atlas.lib.Version;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.function.scripting.ScriptLangSymbols;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARQ {
    private static volatile boolean initialized = false;
    private static final Object initLock = new Object();
    public static final String logExecName = "org.apache.jena.arq.exec";
    public static final String logInfoName = "org.apache.jena.arq.info";
    private static final Logger logInfo = LoggerFactory.getLogger((String)"org.apache.jena.arq.info");
    public static final String logHttpRequestName = "org.apache.jena.arq.service";
    private static final Logger logExec = LoggerFactory.getLogger((String)"org.apache.jena.arq.exec");
    private static final Logger logHttpRequest = LoggerFactory.getLogger((String)"org.apache.jena.arq.service");
    public static final Symbol symLogExec = SystemARQ.allocSymbol("logExec");
    public static final String arqIRI = "http://jena.hpl.hp.com/#arq";
    public static final String arqParamNS = "http://jena.apache.org/ARQ#";
    public static final String arqSymbolPrefix = "arq";
    public static final Symbol strictSPARQL = SystemARQ.allocSymbol("strictSPARQL");
    public static final Symbol constantBNodeLabels = SystemARQ.allocSymbol("constantBNodeLabels");
    public static final Symbol enablePropertyFunctions = SystemARQ.allocSymbol("enablePropertyFunctions");
    public static final Symbol enableExecutionTimeLogging = SystemARQ.allocSymbol("enableExecutionTimeLogging");
    public static final Symbol outputGraphBNodeLabels = SystemARQ.allocSymbol("outputGraphBNodeLabels");
    public static final Symbol inputGraphBNodeLabels = SystemARQ.allocSymbol("inputGraphBNodeLabels");
    public static final Symbol queryTimeout = SystemARQ.allocSymbol("queryTimeout");
    public static final Symbol stageGenerator = SystemARQ.allocSymbol("stageGenerator");
    public static final Symbol hideNonDistiguishedVariables = SystemARQ.allocSymbol("hideNonDistiguishedVariables");
    public static final Symbol useSAX = SystemARQ.allocSymbol("useSAX");
    public static final boolean allowDuplicateSelectColumns = false;
    public static final Symbol regexImpl = SystemARQ.allocSymbol("regexImpl");
    public static final Symbol javaRegex = SystemARQ.allocSymbol("javaRegex");
    public static final Symbol xercesRegex = SystemARQ.allocSymbol("xercesRegex");
    public static final Symbol serviceParams = SystemARQ.allocSymbol("serviceParams");
    public static final Symbol httpServiceSendMode = SystemARQ.allocSymbol("httpServiceSendMode");
    public static final Symbol httpRegistryRequestModifer = SystemARQ.allocSymbol("httpRegistryRequestModifer");
    public static final Symbol httpRequestModifer = SystemARQ.allocSymbol("httpRequestModifer");
    public static boolean globalServiceAllowed = true;
    public static boolean allowServiceDefault = true;
    public static final Symbol httpServiceAllowed = SystemARQ.allocSymbol("httpServiceAllowed");
    public static final Symbol httpQueryClient = SystemARQ.allocSymbol("httpQueryClient");
    @Deprecated(since="4.9.0")
    public static final Symbol httpServiceContext = SystemARQ.allocSymbol("httpServiceContext");
    public static final Symbol httpQueryTimeout = SystemARQ.allocSymbol("httpQueryTimeout");
    public static final Symbol fixupUndefinedPrefixes = SystemARQ.allocSymbol("fixupPrefixes");
    public static final Symbol spillToDiskThreshold = SystemARQ.allocSymbol("spillToDiskThreshold");
    public static final Symbol optimization = SystemARQ.allocSymbol("optimization");
    public static final Symbol optPathFlatten = SystemARQ.allocSymbol("optPathFlatten");
    public static final Symbol optPathFlattenAlgebra = SystemARQ.allocSymbol("optPathFlattenAlgebra");
    public static final Symbol optFilterPlacement = SystemARQ.allocSymbol("optFilterPlacement");
    public static final Symbol optFilterPlacementBGP = SystemARQ.allocSymbol("optFilterPlacementBGP");
    public static final Symbol optFilterPlacementConservative = SystemARQ.allocSymbol("optFilterPlacementConservative");
    public static final Symbol optTopNSorting = SystemARQ.allocSymbol("optTopNSorting");
    public static final Symbol topNSortingThreshold = SystemARQ.allocSymbol("topNSortingThreshold");
    public static final Symbol optDistinctToReduced = SystemARQ.allocSymbol("optDistinctToReduced");
    public static final Symbol optOrderByDistinctApplication = SystemARQ.allocSymbol("optOrderByDistinctApplication");
    public static final Symbol optFilterEquality = SystemARQ.allocSymbol("optFilterEquality");
    public static final Symbol optFilterInequality = SystemARQ.allocSymbol("optFilterInequality");
    public static final Symbol optFilterImplicitJoin = SystemARQ.allocSymbol("optFilterImplicitJoin");
    public static final Symbol optImplicitLeftJoin = SystemARQ.allocSymbol("optImplicitLeftJoin");
    public static final Symbol optExprConstantFolding = SystemARQ.allocSymbol("optExprConstantFolding");
    public static final Symbol optFilterConjunction = SystemARQ.allocSymbol("optFilterConjunction");
    public static final Symbol optFilterExpandOneOf = SystemARQ.allocSymbol("optFilterExpandOneOf");
    public static final Symbol optFilterDisjunction = SystemARQ.allocSymbol("optFilterDisjunction");
    public static final Symbol optPromoteTableEmpty = SystemARQ.allocSymbol("optPromoteTableEmpty");
    public static final Symbol optIndexJoinStrategy = SystemARQ.allocSymbol("optIndexJoinStrategy");
    public static final Symbol optInlineAssignments = SystemARQ.allocSymbol("optInlineAssignments");
    public static final Symbol optInlineAssignmentsAggressive = SystemARQ.allocSymbol("optInlineAssignmentsAggressive");
    public static final Symbol optMergeBGPs = SystemARQ.allocSymbol("optMergeBGPs");
    public static final Symbol optMergeExtends = SystemARQ.allocSymbol("optMergeExtends");
    public static final Symbol optReorderBGP = SystemARQ.allocSymbol("optReorderBGP");
    public static final Symbol propertyFunctions = SystemARQ.allocSymbol("propertyFunctions");
    public static final Symbol extensionValueTypes = SystemARQ.allocSymbol("extensionValueTypesExpr");
    public static final String systemPropertyScripting = "jena:scripting";
    public static final Symbol symCustomFunctionScriptAllowList = ScriptLangSymbols.scriptAllowList;
    public static Symbol symJavaScriptFunctions = ScriptLangSymbols.scriptFunctions("js");
    public static Symbol symJavaScriptLibFile = ScriptLangSymbols.scriptLibrary("js");
    public static final Symbol generateToList = SystemARQ.allocSymbol("generateToList");
    public static final String NAME = "Apache Jena ARQ";
    public static final String VERSION = Version.versionForClass(ARQ.class).orElse("<development>");

    public static Logger getExecLogger() {
        return logExec;
    }

    public static Logger getInfoLogger() {
        return logInfo;
    }

    public static Logger getHttpRequestLogger() {
        return logHttpRequest;
    }

    public static Explain.InfoLevel getExecutionLogging() {
        return (Explain.InfoLevel)((Object)ARQ.getContext().get(symLogExec));
    }

    public static void setExecutionLogging(Explain.InfoLevel infoLevel) {
        if (Explain.InfoLevel.NONE.equals((Object)infoLevel)) {
            ARQ.getContext().unset(symLogExec);
            return;
        }
        ARQ.getContext().set(symLogExec, (Object)infoLevel);
    }

    public static void enableBlankNodeResultLabels() {
        ARQ.enableBlankNodeResultLabels(true);
    }

    public static void enableBlankNodeResultLabels(boolean val) {
        Boolean b = val;
        ARQ.getContext().set(inputGraphBNodeLabels, b);
        ARQ.getContext().set(outputGraphBNodeLabels, b);
    }

    public static void enableOptimizer(boolean state) {
        ARQ.enableOptimizer(ARQ.getContext(), state);
    }

    public static void enableOptimizer(Context context2, boolean state) {
        context2.set(optimization, state);
    }

    public static void setStrictMode() {
        ARQ.setStrictMode(ARQ.getContext());
    }

    public static void setStrictMode(Context context2) {
        SystemARQ.StrictDateTimeFO = true;
        SystemARQ.ValueExtensions = false;
        SystemARQ.EnableRomanNumerals = false;
        context2.set(optimization, false);
        context2.set(hideNonDistiguishedVariables, true);
        context2.set(strictSPARQL, true);
        context2.set(enablePropertyFunctions, false);
        context2.set(extensionValueTypes, false);
        context2.set(constantBNodeLabels, false);
        context2.set(generateToList, true);
        context2.set(regexImpl, xercesRegex);
    }

    public static boolean isStrictMode() {
        return ARQ.getContext().isTrue(strictSPARQL);
    }

    public static void setNormalMode() {
        SystemARQ.StrictDateTimeFO = false;
        SystemARQ.ValueExtensions = true;
        SystemARQ.EnableRomanNumerals = false;
        ARQ.setNormalMode(ARQ.getContext());
    }

    public static void setNormalMode(Context context2) {
        context2.set(optimization, true);
        context2.set(hideNonDistiguishedVariables, false);
        context2.set(strictSPARQL, false);
        context2.set(enablePropertyFunctions, true);
        context2.set(extensionValueTypes, true);
        context2.set(constantBNodeLabels, true);
        context2.set(generateToList, false);
        context2.set(regexImpl, javaRegex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle((String)"ARQ.init - start", (Object[])new Object[0]);
            RIOT.init();
            ARQConstants.init();
            ARQ.setARQSettings();
            ARQConstants.getGlobalPrefixMap();
            ResultSetLang.init();
            MappingRegistry.addPrefixMapping(arqSymbolPrefix, arqParamNS);
            AssemblerUtils.init();
            RIOT.register();
            FunctionRegistry.init();
            ServiceExecutorRegistry.init();
            AggregateRegistry.init();
            PropertyFunctionRegistry.init();
            JenaSystem.logLifecycle((String)"ARQ.init - finish", (Object[])new Object[0]);
        }
    }

    private static void setARQSettings() {
        SystemARQ.StrictDateTimeFO = false;
        SystemARQ.ValueExtensions = true;
        SystemARQ.EnableRomanNumerals = false;
        Context context2 = RIOT.getContext();
        context2.unset(optimization);
        context2.set(strictSPARQL, false);
        context2.set(constantBNodeLabels, true);
        context2.set(enablePropertyFunctions, true);
        context2.set(regexImpl, javaRegex);
    }

    public static Context getContext() {
        return RIOT.getContext();
    }

    public static void set(Symbol symbol, boolean value) {
        ARQ.getContext().set(symbol, value);
    }

    public static void setTrue(Symbol symbol) {
        ARQ.getContext().setTrue(symbol);
    }

    public static void setFalse(Symbol symbol) {
        ARQ.getContext().setFalse(symbol);
    }

    public static void unset(Symbol symbol) {
        ARQ.getContext().unset(symbol);
    }

    public static boolean isTrue(Symbol symbol) {
        return ARQ.getContext().isTrue(symbol);
    }

    public static boolean isFalse(Symbol symbol) {
        return ARQ.getContext().isFalse(symbol);
    }

    public static boolean isTrueOrUndef(Symbol symbol) {
        return ARQ.getContext().isTrueOrUndef(symbol);
    }

    public static boolean isFalseOrUndef(Symbol symbol) {
        return ARQ.getContext().isFalseOrUndef(symbol);
    }
}

