/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.IntPredicate;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.riot.system.RiotChars;

public class AuthHeader {
    private final String original;
    private final String authSchemeName;
    private final String authSchemeArgs;
    private final AuthScheme authScheme;
    private final Map<String, String> authParams;
    private final String basicUserPassword;
    private final String bearerToken;
    private final String unknown;

    public static AuthHeader parseAuth(String string) {
        return AuthHeader.parse(string, false);
    }

    public static AuthHeader parseChallenge(String string) {
        return AuthHeader.parse(string, true);
    }

    private static AuthHeader parse(String string, boolean isChallenge) {
        string = string.strip();
        Builder builder = new Builder(string, isChallenge);
        try {
            builder.parse$();
            return builder.build();
        }
        catch (AuthParseException ex) {
            return null;
        }
    }

    public static AuthHeader bearerToken(String tokenString) {
        Builder builder = new Builder();
        return builder.setAuthScheme(AuthScheme.BEARER).setBearerToken(tokenString).build();
    }

    private AuthHeader(String original, AuthScheme authScheme, String authSchemeName, String authSchemeArgs, Map<String, String> authParams, String basicUserPassword, String bearerToken, String unknown) {
        this.original = original;
        this.authScheme = authScheme;
        this.authSchemeName = authSchemeName;
        this.authSchemeArgs = authSchemeArgs;
        this.authParams = authParams;
        this.basicUserPassword = basicUserPassword;
        this.bearerToken = bearerToken;
        this.unknown = unknown;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public String getAuthSchemeName() {
        return this.authSchemeName;
    }

    public String getAuthArgs() {
        return this.authSchemeArgs;
    }

    public Map<String, String> getAuthParams() {
        return this.authParams;
    }

    public boolean isBasicAuth() {
        return AuthScheme.BASIC == this.authScheme;
    }

    public String getBasicUserPassword() {
        return this.basicUserPassword;
    }

    public boolean isDigestAuth() {
        return AuthScheme.DIGEST == this.authScheme;
    }

    public boolean isBearerAuth() {
        return AuthScheme.BEARER == this.authScheme;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public boolean isUnknownAuth() {
        return AuthScheme.UNKNOWN == this.authScheme;
    }

    public String getUnknown() {
        return this.unknown;
    }

    private static class Builder {
        private final String string;
        private final int N;
        private final boolean isChallenge;
        private int idx;
        private static char EndOfStr = (char)65535;
        private String authSchemeName = null;
        private String authSchemeArgs = null;
        private AuthScheme authScheme = null;
        private Map<String, String> authParams = null;
        private String basicUserPassword = null;
        private String bearerToken = null;
        private String unknown = null;
        private static IntPredicate test_base64 = Builder::is_base64;
        private static IntPredicate test_tok68 = Builder::is_tok68;
        private static IntPredicate test_base64_pad = ch -> ch == 61;
        private static IntPredicate test_http_tokenchar = Builder::is_tchar;
        private static IntPredicate test_auth_tokenchar = Builder::is_authTokenChar;
        private static IntPredicate testNWS = ch -> ch != 32 && ch != 9;
        private static IntPredicate testWS = ch -> ch == 32 || ch == 9;
        private static IntPredicate testWSC = ch -> ch == 32 || ch == 9 || ch == 44;

        private char nextChar() {
            if (this.idx < 0 || this.idx >= this.N) {
                return EndOfStr;
            }
            char ch = this.string.charAt(this.idx);
            ++this.idx;
            return ch;
        }

        private char peekChar() {
            if (this.idx < 0 || this.idx >= this.N) {
                return EndOfStr;
            }
            char ch = this.string.charAt(this.idx);
            return ch;
        }

        Builder(String string, boolean isChallenge) {
            this.isChallenge = isChallenge;
            this.string = string;
            this.N = string.length();
        }

        Builder() {
            this.isChallenge = false;
            this.string = null;
            this.N = 0;
        }

        public Builder setAuthSchemeName(String authSchemeName) {
            this.authSchemeName = authSchemeName;
            return this;
        }

        public Builder setAuthSchemeArgs(String authSchemeArgs) {
            this.authSchemeArgs = authSchemeArgs;
            return this;
        }

        public Builder setAuthScheme(AuthScheme authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        public Builder setAuthParams(Map<String, String> authParams) {
            this.authParams = authParams;
            return this;
        }

        public Builder setBasicUserPassword(String basicUserPassword) {
            this.basicUserPassword = basicUserPassword;
            return this;
        }

        public Builder setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public Builder setUnknownToken(String unknownToken) {
            this.unknown = unknownToken;
            return this;
        }

        private void parse$() {
            this.skipWhitespace();
            String token = this.httpToken();
            if (token == null) {
                return;
            }
            this.setAuthSchemeName(token);
            AuthScheme authScheme = AuthScheme.scheme(token);
            if (authScheme == null) {
                return;
            }
            this.setAuthScheme(authScheme);
            this.skipWhitespace();
            if (this.idx >= this.N) {
                return;
            }
            this.setAuthSchemeArgs(this.string.substring(this.idx));
            switch (authScheme) {
                case BASIC: {
                    this.parseBasic();
                    break;
                }
                case DIGEST: {
                    this.parseDigest();
                    break;
                }
                case BEARER: {
                    this.parseBearer();
                    break;
                }
                case UNKNOWN: {
                    this.parseUnknown();
                    break;
                }
            }
        }

        private AuthHeader build() {
            return new AuthHeader(this.string, this.authScheme, this.authSchemeName, this.authSchemeArgs, this.authParams, this.basicUserPassword, this.bearerToken, this.unknown);
        }

        private void parseBasic() {
            if (this.isChallenge()) {
                this.setAuthParams(this.mapAuthParams());
            } else {
                this.setBasicUserPassword(this.basicBase64());
            }
        }

        private void parseDigest() {
            this.setAuthParams(this.mapAuthParams());
        }

        private void parseBearer() {
            int startIdx = this.idx;
            if (this.isChallenge()) {
                this.setAuthParams(this.mapAuthParams());
            } else {
                String token = this.bearerToken();
                if (token == null) {
                    this.setUnknownToken(this.string.substring(startIdx).trim());
                } else {
                    this.setBearerToken(token);
                }
            }
        }

        private String stripPadding(String token) {
            int idx;
            for (idx = token.length(); idx > 0 && token.charAt(idx - 1) == '='; --idx) {
            }
            if (idx == token.length()) {
                return token;
            }
            return token.substring(0, idx);
        }

        private void parseUnknown() {
            this.setUnknownToken(this.string.substring(this.idx).trim());
        }

        private Map<String, String> mapAuthParams() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            this.skipWhitespaceComma();
            while (this.idx < this.N) {
                String key = this.httpToken();
                this.skipWhitespace();
                char ch = this.nextChar();
                if (this.idx == this.N || ch != '=') {
                    return null;
                }
                this.skipWhitespace();
                String value = this.tokenOrQuotedString();
                if (value == null) {
                    return null;
                }
                String lcKey = Lib.lowercase((String)key);
                map.put(lcKey, value);
                this.skipWhitespaceComma();
            }
            return map;
        }

        private boolean isChallenge() {
            return this.isChallenge;
        }

        private String tokenOrQuotedString() {
            char ch = this.peekChar();
            if (ch == '\"') {
                return this.quotedString();
            }
            return this.httpToken();
        }

        private String httpToken() {
            int i = this.idx;
            int j = Builder.whileTrue(this.string, this.idx, this.N, test_http_tokenchar);
            if (i == j) {
                return null;
            }
            this.idx = j;
            if (j > 0) {
                return this.string.substring(i, j);
            }
            return null;
        }

        private String quotedString() {
            if (this.string == null) {
                return null;
            }
            if (this.idx < 0) {
                return null;
            }
            if (this.idx >= this.N) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            char ch0 = this.nextChar();
            if (ch0 != '\"') {
                return null;
            }
            char ch;
            while ((ch = this.nextChar()) != EndOfStr) {
                if (ch == '\"') {
                    return stringBuilder.toString();
                }
                if (ch == '\\' && (ch = this.nextChar()) == EndOfStr) {
                    return null;
                }
                stringBuilder.append(ch);
            }
            return null;
        }

        private String basicBase64() {
            int j1 = Builder.whileTrue(this.string, this.idx, this.N, test_base64);
            int j2 = Builder.whileTrue(this.string, j1, this.N, test_base64_pad);
            if (j2 != this.N) {
                return null;
            }
            return this.string.substring(this.idx, j2);
        }

        private String token68() {
            int j1 = Builder.whileTrue(this.string, this.idx, this.N, test_tok68);
            int j2 = Builder.whileTrue(this.string, j1, this.N, test_base64_pad);
            if (j2 != this.N) {
                return null;
            }
            String s = this.string.substring(this.idx, j2);
            this.idx = j2;
            return s;
        }

        private String b64token() {
            return this.token68();
        }

        private String bearerToken() {
            int j = Builder.whileTrue(this.string, this.idx, this.N, test_auth_tokenchar);
            if (j != this.N) {
                return null;
            }
            String s = this.string.substring(this.idx, j);
            this.idx = j;
            return s;
        }

        private static boolean is_tchar(int ch) {
            if (RiotChars.isA2ZN(ch)) {
                return true;
            }
            switch (ch) {
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 94: 
                case 95: 
                case 96: 
                case 124: 
                case 126: {
                    return true;
                }
            }
            return false;
        }

        private static boolean is_tok68(int ch) {
            if (RiotChars.isA2ZN(ch)) {
                return true;
            }
            switch (ch) {
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 95: 
                case 126: {
                    return true;
                }
            }
            return false;
        }

        private static boolean is_authTokenChar(int ch) {
            if (RiotChars.isA2ZN(ch)) {
                return true;
            }
            switch (ch) {
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 61: 
                case 95: 
                case 126: {
                    return true;
                }
            }
            return false;
        }

        private static boolean is_base64(int ch) {
            if (RiotChars.isA2ZN(ch)) {
                return true;
            }
            return ch == 43 || ch == 47;
        }

        private void skipWhitespace() {
            int j;
            this.idx = j = Builder.whileTrue(this.string, this.idx, this.N, testWS);
        }

        private void skipWhitespaceComma() {
            int j;
            this.idx = j = Builder.whileTrue(this.string, this.idx, this.N, testWSC);
        }

        private static int whileTrue(String string, int i, int N, IntPredicate test) {
            while (i < N) {
                char ch = string.charAt(i);
                if (!test.test(ch)) {
                    return i;
                }
                ++i;
            }
            return N;
        }
    }

    private static class AuthParseException
    extends RuntimeException {
        private AuthParseException() {
        }
    }
}

