/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdfs.DatasetGraphRDFS;
import org.apache.jena.rdfs.GraphRDFS;
import org.apache.jena.rdfs.InfStreamRDFS;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;

public class RDFSFactory {
    public static Graph graphRDFS(Graph data, Graph vocab) {
        return RDFSFactory.graphRDFS(data, new SetupRDFS(vocab));
    }

    public static Graph graphRDFS(Graph data) {
        return RDFSFactory.graphRDFS(data, new SetupRDFS(data));
    }

    public static Graph graphRDFS(Graph data, SetupRDFS setup) {
        return new GraphRDFS(data, setup);
    }

    public static DatasetGraph datasetRDFS(DatasetGraph data, SetupRDFS setup) {
        return new DatasetGraphRDFS(data, setup);
    }

    public static DatasetGraph datasetRDFS(DatasetGraph data, Graph vocab) {
        SetupRDFS setup = RDFSFactory.setupRDFS(vocab);
        return new DatasetGraphRDFS(data, setup);
    }

    public static Dataset datasetRDFS(Dataset data, Graph vocab) {
        SetupRDFS setup = RDFSFactory.setupRDFS(vocab);
        return DatasetFactory.wrap(new DatasetGraphRDFS(data.asDatasetGraph(), setup));
    }

    public static SetupRDFS setupRDFS(Graph vocab) {
        return new SetupRDFS(vocab);
    }

    public static StreamRDF streamRDFS(StreamRDF data, Graph vocab) {
        SetupRDFS setup = new SetupRDFS(vocab);
        return RDFSFactory.streamRDFS(data, setup);
    }

    public static StreamRDF streamRDFS(StreamRDF data, SetupRDFS setup) {
        return new InfStreamRDFS(data, setup);
    }
}

