/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.sys;

import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.jena.graph.Node;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ContextAccumulator;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;

public abstract class ExecHTTPBuilder<X, Y> {
    protected String serviceURL = null;
    private Query query = null;
    protected String queryString = null;
    protected boolean parseCheck = true;
    private HttpClient httpClient = null;
    protected Map<String, String> httpHeaders = new HashMap<String, String>();
    protected Params params = Params.create();
    private ContextAccumulator contextAcc = ContextAccumulator.newBuilder(() -> ARQ.getContext());
    protected String appAcceptHeader = null;
    protected long timeout = -1L;
    protected TimeUnit timeoutUnit = null;
    protected int urlLimit = HttpEnv.urlLimit;
    protected QuerySendMode sendMode = QuerySendMode.systemDefault;
    protected List<String> defaultGraphURIs = new ArrayList<String>();
    protected List<String> namedGraphURIs = new ArrayList<String>();
    protected Map<Var, Node> substitutionMap = new HashMap<Var, Node>();

    protected abstract Y thisBuilder();

    public Y endpoint(String serviceURL) {
        this.serviceURL = Objects.requireNonNull(serviceURL);
        return this.thisBuilder();
    }

    public Y parseCheck(boolean parseCheck) {
        this.parseCheck = parseCheck;
        return this.thisBuilder();
    }

    public Y query(Query query) {
        Objects.requireNonNull(query);
        String queryStr = query.toString();
        this.setQuery(query, queryStr);
        return this.thisBuilder();
    }

    public Y query(String queryStr) {
        Objects.requireNonNull(queryStr);
        Query query = this.parseCheck ? QueryFactory.create(queryStr) : null;
        this.setQuery(query, queryStr);
        return this.thisBuilder();
    }

    public Y query(String queryStr, Syntax syntax) {
        Objects.requireNonNull(queryStr);
        Query query = QueryFactory.create(queryStr, syntax);
        this.setQuery(query, queryStr);
        return this.thisBuilder();
    }

    public Y queryString(String queryString) {
        Objects.requireNonNull(queryString);
        this.setQuery(null, queryString);
        return this.thisBuilder();
    }

    protected void setQuery(Query query, String queryStr) {
        this.query = query;
        this.queryString = queryStr;
    }

    public Y addDefaultGraphURI(String uri) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(uri);
        return this.thisBuilder();
    }

    public Y addNamedGraphURI(String uri) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(uri);
        return this.thisBuilder();
    }

    public Y httpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
        return this.thisBuilder();
    }

    public Y sendMode(QuerySendMode mode) {
        this.sendMode = mode;
        return this.thisBuilder();
    }

    public Y useGetWithLimit() {
        this.sendMode = QuerySendMode.asGetWithLimitBody;
        return this.thisBuilder();
    }

    public Y useGet() {
        this.sendMode = QuerySendMode.asGetAlways;
        return this.thisBuilder();
    }

    public Y postQuery() {
        this.sendMode = QuerySendMode.asPost;
        return this.thisBuilder();
    }

    public Y urlGetLimit(int urlLimit) {
        this.urlLimit = urlLimit;
        return this.thisBuilder();
    }

    public Y params(Params other) {
        if (other != null) {
            this.params.merge(other);
        }
        return this.thisBuilder();
    }

    public Y param(String name) {
        Objects.requireNonNull(name);
        this.params.add(name);
        return this.thisBuilder();
    }

    public Y param(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.params.add(name, value);
        return this.thisBuilder();
    }

    public Y substitution(Binding binding) {
        binding.forEach(this.substitutionMap::put);
        return this.thisBuilder();
    }

    public Y substitution(String var, Node value) {
        return this.substitution(Var.alloc(var), value);
    }

    public Y substitution(Var var, Node value) {
        this.substitutionMap.put(var, value);
        return this.thisBuilder();
    }

    public Y acceptHeader(String acceptHeader) {
        Objects.requireNonNull(acceptHeader);
        this.appAcceptHeader = acceptHeader;
        return this.thisBuilder();
    }

    public Y httpHeader(String headerName, String headerValue) {
        Objects.requireNonNull(headerName);
        Objects.requireNonNull(headerValue);
        this.httpHeaders.put(headerName, headerValue);
        return this.thisBuilder();
    }

    public Y httpHeaders(Map<String, String> headers) {
        Objects.requireNonNull(headers);
        this.httpHeaders.putAll(headers);
        return this.thisBuilder();
    }

    public Y context(Context context2) {
        if (context2 == null) {
            return this.thisBuilder();
        }
        this.ensureContext();
        this.contextAcc.context(context2);
        return this.thisBuilder();
    }

    public Y set(Symbol symbol, Object value) {
        this.ensureContext();
        this.contextAcc.set(symbol, value);
        return this.thisBuilder();
    }

    public Y set(Symbol symbol, boolean value) {
        this.ensureContext();
        this.contextAcc.set(symbol, value);
        return this.thisBuilder();
    }

    private void ensureContext() {
    }

    public Y timeout(long timeout, TimeUnit timeoutUnit) {
        if (timeout < 0L) {
            this.timeout = -1L;
            this.timeoutUnit = null;
        } else {
            this.timeout = timeout;
            this.timeoutUnit = Objects.requireNonNull(timeoutUnit);
        }
        return this.thisBuilder();
    }

    public final X build() {
        Objects.requireNonNull(this.serviceURL, "No service URL");
        if (this.queryString == null && this.query == null) {
            throw new QueryException("No query for QueryExecHTTP");
        }
        HttpClient hClient = HttpEnv.getHttpClient(this.serviceURL, this.httpClient);
        Query queryActual = this.query;
        String queryStringActual = this.queryString;
        if (this.substitutionMap != null && !this.substitutionMap.isEmpty()) {
            if (queryActual == null) {
                try {
                    queryActual = QueryFactory.create(this.queryString);
                }
                catch (Exception e2) {
                    throw new QueryException("Substitution only supported for Query objects. Failed to parse the given string as a Query object.", e2);
                }
            }
            queryActual = QueryTransformOps.transform(queryActual, this.substitutionMap);
            queryStringActual = queryActual.toString();
        }
        Context cxt = this.contextAcc.context();
        return this.buildX(hClient, queryActual, queryStringActual, cxt);
    }

    protected abstract X buildX(HttpClient var1, Query var2, String var3, Context var4);

    static {
        JenaSystem.init();
    }
}

