/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.InputStream;
import java.io.Reader;
import java.util.Deque;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_Marker;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.JenaXMLInput;
import org.apache.jena.vocabulary.RDF;

public class ReaderTriX
implements ReaderRIOT {
    public static ReaderRIOTFactory factory = (language, profile) -> new ReaderTriX(profile, profile.getErrorHandler());
    private final ErrorHandler errorHandler;
    private final ParserProfile profile;
    private static String nsRDF = RDF.getURI();
    private static String nsXSD = "http://www.w3.org/2001/XMLSchema";
    private static String nsXML0 = "http://www.w3.org/XML/1998/namespace";
    private static String rdfXMLLiteral = RDF.xmlLiteral.getURI();
    private static Node nAssertedTriple = new NodeMarker("asserted triple");
    private static Node nEmbeddedTriple = new NodeMarker("embedded triple");

    public ReaderTriX(ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        XMLStreamReader xReader;
        try {
            xReader = JenaXMLInput.newXMLStreamReader((InputStream)in);
        }
        catch (XMLStreamException e2) {
            throw new RiotException("Can't initialize StAX parsing engine", e2);
        }
        this.read(xReader, baseURI, output);
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        XMLStreamReader xReader;
        try {
            xReader = JenaXMLInput.newXMLStreamReader((Reader)reader);
        }
        catch (XMLStreamException e2) {
            throw new RiotException("Can't initialize StAX parsing engine", e2);
        }
        this.read(xReader, baseURI, output);
    }

    /*
     * Exception decompiling
     */
    private void read(XMLStreamReader parser, String baseURI, StreamRDF output) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [49[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void push(Deque<Node> acc, Node term) {
        acc.push(term);
    }

    private Node pop(Deque<Node> acc) {
        return acc.pop();
    }

    private void staxErrorOutOfPlaceElement(XMLStreamReader parser) {
        this.staxError(parser.getLocation(), "Out of place XML element: " + this.tagName(parser));
    }

    private Node term(XMLStreamReader parser, ParserProfile profile) throws XMLStreamException {
        String tag = parser.getLocalName();
        int line = parser.getLocation().getLineNumber();
        int col = parser.getLocation().getColumnNumber();
        switch (tag) {
            case "uri": {
                String x = parser.getElementText();
                Node n = profile.createURI(x, (long)line, (long)col);
                return n;
            }
            case "qname": {
                String x = parser.getElementText();
                int idx = x.indexOf(58);
                if (idx == -1) {
                    this.staxError(parser.getLocation(), "Expected ':' in prefixed name.  Found " + x);
                }
                String[] y = x.split(":", 2);
                String prefUri = parser.getNamespaceURI(y[0]);
                String local = y[1];
                return profile.createURI(prefUri + local, (long)line, (long)col);
            }
            case "id": {
                String x = parser.getElementText();
                return profile.createBlankNode(null, x, line, col);
            }
            case "plainLiteral": {
                int x = parser.getAttributeCount();
                if (x > 1) {
                    this.staxError(parser.getLocation(), "Multiple attributes : only one allowed");
                }
                String lang = null;
                if (x == 1) {
                    lang = this.attribute(parser, nsXML0, "lang");
                }
                String lex = parser.getElementText();
                if (lang == null) {
                    return profile.createStringLiteral(lex, line, col);
                }
                return profile.createLangLiteral(lex, lang, line, col);
            }
            case "typedLiteral": {
                String dt;
                int nAttr = parser.getAttributeCount();
                if (nAttr != 1) {
                    this.staxError(parser.getLocation(), "Multiple attributes : only one allowed");
                }
                if ((dt = this.attribute(parser, "http://www.w3.org/2004/03/trix/trix-1/", "datatype")) == null) {
                    this.staxError(parser.getLocation(), "No datatype attribute");
                }
                RDFDatatype rdt = NodeFactory.getType((String)dt);
                String lex = rdfXMLLiteral.equals(dt) ? this.slurpRDFXMLLiteral(parser) : parser.getElementText();
                return profile.createTypedLiteral(lex, rdt, line, col);
            }
            case "triple": {
                Node s = this.term(parser, profile);
                Node p = this.term(parser, profile);
                Node o = this.term(parser, profile);
                Node n = profile.createTripleNode(s, p, o, line, col);
                return n;
            }
        }
        QName qname = parser.getName();
        this.staxError(parser.getLocation(), "Unrecognized tag -- " + this.qnameAsString(qname));
        return null;
    }

    private String slurpRDFXMLLiteral(XMLStreamReader parser) throws XMLStreamException {
        StringBuffer content = new StringBuffer();
        int depth = 0;
        while (parser.hasNext()) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    int i;
                    QName qname = parser.getName();
                    content.append("<");
                    content.append(this.qnameAsString(qname));
                    int N = parser.getNamespaceCount();
                    for (i = 0; i < N; ++i) {
                        Object p = parser.getNamespacePrefix(i);
                        p = p == null ? "xmlns" : "xmlns:" + (String)p;
                        String v = parser.getNamespaceURI(i);
                        content.append(" ").append((String)p).append("=\"").append(v).append("\"");
                    }
                    N = parser.getAttributeCount();
                    for (i = 0; i < N; ++i) {
                        QName name = parser.getAttributeName(i);
                        String a = this.qnameAsString(name);
                        String v = parser.getAttributeValue(i);
                        content.append(" ").append(a).append("=\"").append(v).append("\"");
                    }
                    content.append(">");
                    ++depth;
                    break;
                }
                case 2: {
                    if (--depth == -1) {
                        return content.toString();
                    }
                    QName qname = parser.getName();
                    String x = this.qnameAsString(qname);
                    content.append("</" + x + ">");
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 12: {
                    content.append(parser.getText());
                    break;
                }
                case 8: {
                    this.staxError(parser.getLocation(), "End of file");
                }
            }
        }
        this.staxError(parser.getLocation(), "End of file");
        return null;
    }

    private String tagName(XMLStreamReader parser) {
        return this.qnameAsString(parser.getName());
    }

    private String qnameAsString(QName qname) {
        String x = qname.getPrefix();
        if (x == null || x.isEmpty()) {
            return qname.getLocalPart();
        }
        return x + ":" + qname.getLocalPart();
    }

    private String attribute(XMLStreamReader parser, String nsURI, String localname2) {
        int x = parser.getAttributeCount();
        if (x > 1) {
            this.staxError(parser.getLocation(), "Multiple attributes : only one allowed : " + this.tagName(parser));
        }
        if (x == 0) {
            return null;
        }
        String attrPX = parser.getAttributePrefix(0);
        String attrNS = parser.getAttributeNamespace(0);
        if (attrNS == null) {
            attrNS = parser.getName().getNamespaceURI();
        }
        String attrLN = parser.getAttributeLocalName(0);
        if (!Objects.equals(nsURI, attrNS) || !Objects.equals(attrLN, localname2)) {
            this.staxError(parser.getLocation(), "Unexpected attribute : " + attrPX + ":" + attrLN + " at " + this.tagName(parser));
        }
        String attrVal = parser.getAttributeValue(0);
        return attrVal;
    }

    private void staxError(String msg) {
        this.staxError(-1, -1, msg);
    }

    private void staxError(Location loc, String msg) {
        this.staxError(loc.getLineNumber(), loc.getColumnNumber(), msg);
    }

    private void staxError(int line, int col, String msg) {
        this.errorHandler.error(msg, line, col);
    }

    static enum State {
        OUTER,
        TRIX,
        GRAPH,
        TRIPLE,
        E_TRIPLE;

    }

    private static class NodeMarker
    extends Node_Marker {
        protected NodeMarker(String label) {
            super(label);
        }
    }
}

