/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;

public class ExecutionContext
implements FunctionEnv {
    private static final boolean TrackAllIterators = false;
    private Context context = null;
    private DatasetGraph dataset = null;
    private final Collection<QueryIterator> openIterators;
    private Collection<QueryIterator> allIterators = null;
    private Graph activeGraph = null;
    private OpExecutorFactory executor = null;
    private final AtomicBoolean cancelSignal;

    public static ExecutionContext copy(ExecutionContext other) {
        return new ExecutionContext(other);
    }

    @Deprecated
    public ExecutionContext(ExecutionContext other) {
        this.context = other.context;
        this.dataset = other.dataset;
        this.openIterators = other.openIterators;
        this.allIterators = other.allIterators;
        this.activeGraph = other.activeGraph;
        this.executor = other.executor;
        this.cancelSignal = other.cancelSignal;
    }

    public static ExecutionContext fromFunctionEnv(FunctionEnv functionEnv) {
        return new ExecutionContext(functionEnv);
    }

    private ExecutionContext(FunctionEnv other) {
        this.context = other.getContext();
        this.dataset = other.getDataset();
        this.openIterators = new ArrayList<QueryIterator>();
        this.allIterators = null;
        this.activeGraph = other.getActiveGraph();
        this.executor = QC.getFactory(this.context);
        this.cancelSignal = Context.getCancelSignal(this.context);
    }

    public static ExecutionContext copyChangeActiveGraph(ExecutionContext other, Graph activeGraph) {
        return new ExecutionContext(other, activeGraph);
    }

    @Deprecated
    public ExecutionContext(ExecutionContext other, Graph activeGraph) {
        this(other);
        this.activeGraph = activeGraph;
    }

    public static ExecutionContext create(DatasetGraph dataset) {
        Context cxt = ARQ.getContext().copy();
        return ExecutionContext.create(dataset, cxt);
    }

    public static ExecutionContext create(DatasetGraph dataset, Context context2) {
        Graph dftGraph = dataset == null ? null : dataset.getDefaultGraph();
        return new ExecutionContext(context2, dftGraph, dataset, QC.getFactory(context2), Context.getCancelSignal(context2));
    }

    public static ExecutionContext createForGraph(Graph graph) {
        Context cxt = ARQ.getContext().copy();
        return ExecutionContext.createForGraph(graph, cxt);
    }

    public static ExecutionContext createForGraph(Graph graph, Context cxt) {
        DatasetGraph dsg = graph == null ? null : DatasetGraphFactory.wrap(graph);
        return ExecutionContext.create(dsg, cxt);
    }

    @Deprecated(forRemoval=true)
    public ExecutionContext(DatasetGraph dataset) {
        this(dataset, QC.getFactory(ARQ.getContext()));
    }

    @Deprecated(forRemoval=true)
    public ExecutionContext(DatasetGraph dataset, OpExecutorFactory factory) {
        this(ARQ.getContext().copy(), dataset.getDefaultGraph(), dataset, factory);
    }

    @Deprecated
    public ExecutionContext(Context params, Graph activeGraph, DatasetGraph dataset, OpExecutorFactory factory) {
        this(params, activeGraph, dataset, factory, Context.getCancelSignal(params));
    }

    @Deprecated
    public ExecutionContext(Context params, Graph activeGraph, DatasetGraph dataset, OpExecutorFactory factory, AtomicBoolean cancelSignal) {
        this.context = params;
        this.dataset = dataset;
        this.openIterators = new ArrayList<QueryIterator>();
        this.activeGraph = activeGraph;
        this.executor = factory;
        this.cancelSignal = cancelSignal;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public AtomicBoolean getCancelSignal() {
        return this.cancelSignal;
    }

    public void openIterator(QueryIterator qIter) {
        this.openIterators.add(qIter);
        if (this.allIterators != null) {
            this.allIterators.add(qIter);
        }
    }

    public void closedIterator(QueryIterator qIter) {
        this.openIterators.remove(qIter);
    }

    public Iterator<QueryIterator> listOpenIterators() {
        return this.openIterators.iterator();
    }

    public Iterator<QueryIterator> listAllIterators() {
        if (this.allIterators == null) {
            return Iter.nullIterator();
        }
        return this.allIterators.iterator();
    }

    public OpExecutorFactory getExecutor() {
        return this.executor;
    }

    public void setExecutor(OpExecutorFactory executor) {
        this.executor = executor;
    }

    @Override
    public DatasetGraph getDataset() {
        return this.dataset;
    }

    @Override
    public Graph getActiveGraph() {
        return this.activeGraph;
    }
}

