/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;

public class ExprTransformNodeElement
extends ExprTransformCopy {
    private final NodeTransform nodeTransform;
    private final ElementTransform elementTransform;
    private final ElementVisitor beforeVisitor;
    private final ElementVisitor afterVisitor;

    public ExprTransformNodeElement(NodeTransform nodeTransform, ElementTransform eltrans) {
        this(nodeTransform, eltrans, null, null);
    }

    public ExprTransformNodeElement(NodeTransform nodeTransform, ElementTransform eltrans, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
        this.nodeTransform = nodeTransform;
        this.elementTransform = eltrans;
        this.beforeVisitor = beforeVisitor;
        this.afterVisitor = afterVisitor;
    }

    @Override
    public Expr transform(ExprVar nv) {
        Node n = (Node)this.nodeTransform.apply(nv.getAsNode());
        if (n == nv.getAsNode()) {
            return nv;
        }
        if (n instanceof Var) {
            Var v = Var.alloc(n);
            return new ExprVar(v);
        }
        return NodeValue.makeNode(n);
    }

    @Override
    public Expr transform(NodeValue nv) {
        Node n = (Node)this.nodeTransform.apply(nv.asNode());
        if (n == nv.asNode()) {
            return nv;
        }
        return NodeValue.makeNode(n);
    }

    @Override
    public Expr transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
        Element elt1;
        Element elt = funcOp.getElement();
        if (elt == (elt1 = ElementTransformer.transform(elt, this.elementTransform, this, this.beforeVisitor, this.afterVisitor))) {
            return funcOp;
        }
        if (funcOp instanceof E_Exists) {
            return new E_Exists(elt1);
        }
        if (funcOp instanceof E_NotExists) {
            return new E_NotExists(elt1);
        }
        throw new InternalErrorException("Unknown ExprFunctionOp: " + funcOp.getFunctionSymbol());
    }

    @Override
    public Expr transform(ExprAggregator eAgg) {
        return eAgg.applyNodeTransform(this.nodeTransform);
    }
}

