/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.SPARQLResult;

public class QueryExecResult {
    private boolean hasBeenSet = false;
    private RowSet resultSet = null;
    private Boolean booleanResult = null;
    private Graph graph = null;
    private DatasetGraph dataset = null;
    private Iterator<JsonObject> jsonItems = null;

    public static QueryExecResult adapt(SPARQLResult result) {
        Objects.requireNonNull(result);
        if (result.isResultSet()) {
            return new QueryExecResult(RowSet.adapt(result.getResultSet()));
        }
        if (result.isBoolean()) {
            return new QueryExecResult(result.getBooleanResult());
        }
        if (result.isGraph()) {
            return new QueryExecResult(result.getModel().getGraph());
        }
        if (result.isDataset()) {
            return new QueryExecResult(result.getDataset().asDatasetGraph());
        }
        if (result.isJson()) {
            return new QueryExecResult(result.getJsonItems());
        }
        throw new IllegalArgumentException("Can not convert to a QueryExecResult object");
    }

    protected QueryExecResult() {
    }

    public QueryExecResult(Graph graph) {
        this.set(graph);
    }

    public QueryExecResult(RowSet rowSet) {
        this.set(rowSet);
    }

    public QueryExecResult(boolean booleanResult) {
        this.set(booleanResult);
    }

    public QueryExecResult(DatasetGraph dataset) {
        this.set(dataset);
    }

    public QueryExecResult(Iterator<JsonObject> jsonItems) {
        this.set(jsonItems);
    }

    public boolean isSet() {
        return this.hasBeenSet;
    }

    public boolean isRowSet() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        return this.resultSet != null;
    }

    public boolean isGraph() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        return this.graph != null;
    }

    public boolean isDataset() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        return this.dataset != null;
    }

    public boolean isBoolean() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        return this.booleanResult != null;
    }

    public boolean isJson() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        return this.jsonItems != null;
    }

    public RowSet rowSet() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        if (!this.isRowSet()) {
            throw new RowSet.Exception("Not a RowSet result");
        }
        return this.resultSet;
    }

    public Boolean booleanResult() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        if (!this.isBoolean()) {
            throw new RowSet.Exception("Not a boolean result");
        }
        return this.booleanResult;
    }

    public Graph graph() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        if (!this.isGraph()) {
            throw new RowSet.Exception("Not a graph result");
        }
        return this.graph;
    }

    public DatasetGraph dataset() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        if (!this.isDataset()) {
            throw new RowSet.Exception("Not a dataset result");
        }
        return this.dataset;
    }

    public Iterator<JsonObject> jsonItems() {
        if (!this.hasBeenSet) {
            throw new RowSet.Exception("Not set");
        }
        if (!this.isJson()) {
            throw new RowSet.Exception("Not a JSON result");
        }
        return this.jsonItems;
    }

    protected void clear() {
        this.hasBeenSet = false;
        this.resultSet = null;
        this.booleanResult = null;
        this.graph = null;
        this.dataset = null;
        this.jsonItems = null;
    }

    protected void set(RowSet rs) {
        this.resultSet = rs;
        this.hasBeenSet = true;
    }

    protected void set(Graph g) {
        this.graph = g;
        this.hasBeenSet = true;
    }

    protected void set(DatasetGraph dsg) {
        this.dataset = dsg;
        this.hasBeenSet = true;
    }

    protected void set(Boolean r) {
        this.booleanResult = r;
        this.hasBeenSet = true;
    }

    protected void set(Iterator<JsonObject> jsonItems) {
        this.jsonItems = jsonItems;
        this.hasBeenSet = true;
    }
}

