/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system.buffering;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.jena.riot.system.PrefixEntry;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;

public class BufferingPrefixMap
extends PrefixMapBase {
    private Map<String, String> addedMappings = new HashMap<String, String>();
    private Set<String> deletedMappings = new HashSet<String>();
    private final PrefixMap base;

    public BufferingPrefixMap(PrefixMap prefixes) {
        this.base = prefixes;
    }

    @Override
    public Map<String, String> getMapping() {
        return this.getMappingCopy();
    }

    @Override
    public Map<String, String> getMappingCopy() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.base.getMapping());
        map.putAll(this.addedMappings);
        this.deletedMappings.forEach(map::remove);
        return map;
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        this.base.stream().filter(entry -> !this.deletedMappings.contains(entry.getPrefix())).forEach((? super T e2) -> action.accept(e2.getPrefix(), e2.getUri()));
        this.addedMappings.forEach((? super K p, ? super V u) -> action.accept((String)p, (String)u));
    }

    @Override
    public Stream<PrefixEntry> stream() {
        Stream<PrefixEntry> stream1 = this.base.stream().filter(entry -> !this.deletedMappings.contains(entry.getPrefix()));
        Stream<PrefixEntry> stream2 = this.addedMappings.entrySet().stream().map(e2 -> PrefixEntry.create((String)e2.getKey(), (String)e2.getValue()));
        return Stream.concat(stream1, stream2);
    }

    @Override
    public String get(String prefix) {
        if (this.addedMappings.containsKey(prefix = PrefixLib.canonicalPrefix(prefix))) {
            return this.addedMappings.get(prefix);
        }
        if (this.deletedMappings.contains(prefix)) {
            return null;
        }
        return this.base.get(prefix);
    }

    @Override
    public void add(String prefix, String iriString) {
        String x;
        if (this.base.containsPrefix(prefix = PrefixLib.canonicalPrefix(prefix)) && Objects.equals(x = this.get(prefix), iriString)) {
            return;
        }
        this.addedMappings.put(prefix, iriString);
        this.deletedMappings.remove(prefix);
    }

    @Override
    public void delete(String prefix) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.addedMappings.remove(prefix);
        if (this.base.containsPrefix(prefix)) {
            this.deletedMappings.add(prefix);
        } else {
            this.deletedMappings.remove(prefix);
        }
    }

    @Override
    public void clear() {
        this.addedMappings.clear();
        this.deletedMappings = new HashSet<String>(this.base.getMapping().keySet());
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.stream().anyMatch(e2 -> Objects.equals(e2.getPrefix(), prefix));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return (int)this.stream().count();
    }

    public PrefixMap base() {
        return this.base;
    }

    public void flush() {
        this.addedMappings.forEach(this.base::add);
        this.deletedMappings.forEach(this.base::delete);
        this.addedMappings.clear();
        this.deletedMappings.clear();
    }

    public String state() {
        StringBuilder sb = new StringBuilder();
        sb.append("Prefixes").append("\n");
        sb.append("  Added:   " + String.valueOf(this.addedMappings)).append("\n");
        sb.append("  Deleted: " + String.valueOf(this.deletedMappings)).append("\n");
        return sb.toString();
    }
}

