/*
 * Decompiled with CFR 0.152.
 */
package jena;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.BuiltinException;
import org.apache.jena.reasoner.rulesys.BuiltinRegistry;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.FileUtils;

public class RuleMap {
    public static List<Rule> loadRules(String filename, Map<String, String> prefixes) {
        String fname = filename;
        if (fname.startsWith("file:///")) {
            fname = File.separator + fname.substring(8);
        } else if (fname.startsWith("file:/")) {
            fname = File.separator + fname.substring(6);
        } else if (fname.startsWith("file:")) {
            fname = fname.substring(5);
        }
        BufferedReader src = FileUtils.openResourceFile((String)fname);
        return RuleMap.loadRules(src, prefixes);
    }

    public static List<Rule> loadRules(BufferedReader src, Map<String, String> prefixes) {
        Rule.Parser parser = Rule.rulesParserFromReader((BufferedReader)src);
        List rules = Rule.parseRules((Rule.Parser)parser);
        prefixes.putAll(parser.getPrefixMap());
        return rules;
    }

    public static void main(String[] args) {
        try {
            String usage = "Usage:  RuleMap [-il inlang] [-ol outlang] [-d] rulefile infile (- for stdin)";
            DefaultParser parser = new DefaultParser();
            Options options = new Options().addOption("il", "inputLang", true, "input language").addOption("ol", "outputLang", true, "output language").addOption("d", "Deductions only?");
            CommandLine cl = parser.parse(options, args);
            List filenameArgs = cl.getArgList();
            if (filenameArgs.size() != 2) {
                System.err.println(usage);
                System.exit(1);
            }
            String inLang = cl.getOptionValue("inputLang");
            String fname = (String)filenameArgs.get(1);
            Model inModel = ModelFactory.createDefaultModel();
            if (fname.equals("-")) {
                inModel.read(System.in, null, inLang);
            } else {
                inModel.read(fname, inLang);
            }
            String outLang = cl.hasOption("outputLang") ? cl.getOptionValue("outputLang") : "N3";
            boolean deductionsOnly = cl.hasOption('d');
            BuiltinRegistry.theRegistry.register((Builtin)new Deduce());
            HashMap<String, String> prefixes = new HashMap<String, String>();
            List<Rule> rules = RuleMap.loadRules((String)filenameArgs.get(0), prefixes);
            GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
            InfModel infModel = ModelFactory.createInfModel((Reasoner)reasoner, (Model)inModel);
            infModel.prepare();
            infModel.setNsPrefixes(prefixes);
            try (PrintWriter writer = new PrintWriter(System.out);){
                if (deductionsOnly) {
                    Model deductions = infModel.getDeductionsModel();
                    deductions.setNsPrefixes(prefixes);
                    deductions.setNsPrefixes((PrefixMapping)inModel);
                    deductions.write((Writer)writer, outLang);
                } else {
                    infModel.write((Writer)writer, outLang);
                }
            }
        }
        catch (Throwable t) {
            System.err.println("An error occured: \n" + t);
            t.printStackTrace();
        }
    }

    static {
        LogCtl.setLogging();
    }

    static class Deduce
    extends BaseBuiltin {
        Deduce() {
        }

        public String getName() {
            return "deduce";
        }

        public int getArgLength() {
            return 3;
        }

        public void headAction(Node[] args, int length, RuleContext context) {
            if (!(context.getGraph() instanceof FBRuleInfGraph)) {
                throw new BuiltinException((Builtin)this, context, "Only usable in FBrule graphs");
            }
            Triple t = new Triple(args[0], args[1], args[2]);
            ((FBRuleInfGraph)context.getGraph()).addDeduction(t);
        }
    }
}

