/*
 * Decompiled with CFR 0.152.
 */
package jena;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.ext.xerces.util.XMLChar;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class schemagen {
    public static final String NS = "http://jena.hpl.hp.com/2003/04/schemagen#";
    public static final String DEFAULT_CONFIG_URI = "file:schemagen.rdf";
    public static final String DEFAULT_MARKER = "%";
    public static final String DEFAULT_TEMPLATE = "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
    public static final String DEFAULT_INDIVIDUAL_TEMPLATE = "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\", %valtype% );";
    public static final String DEFAULT_RDFS_INDIVIDUAL_TEMPLATE = "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
    public static final String DEFAULT_HEADER_TEMPLATE = "/* CVS $Id: $ */%nl%%package% %nl%%imports% %nl%/**%nl% * Vocabulary definitions from %sourceURI% %nl% * @author Auto-generated by schemagen on %date% %nl% */";
    public static final int COMMENT_LENGTH_LIMIT = 80;
    public static final String[] JAVA_KEYWORDS;
    private static List<String> KEYWORD_LIST;
    protected SchemagenOptions m_options;
    protected OntModel m_source;
    protected PrintStream m_output;
    protected String m_lang;
    protected List<Replacement> m_replacements = new ArrayList<Replacement>();
    protected String m_nl = "\n";
    protected int m_indentStep = 4;
    protected Set<String> m_usedNames = new HashSet<String>();
    protected Map<Resource, String> m_resourcesToNames = new HashMap<Resource, String>();
    protected List<String> m_includeURI = new ArrayList<String>();

    public static void main(String ... args) {
        try {
            new schemagen().go(args);
        }
        catch (SchemagenException e) {
            System.err.println("Schemagen failed to run:");
            System.err.println(e.getMessage());
            if (e.getCause() != null) {
                System.err.println("Caused by: " + e.getCause().getMessage());
            }
            System.exit(1);
        }
    }

    protected void go(String[] args) {
        this.go(new SchemagenOptionsImpl(args));
    }

    protected void go(SchemagenOptions options) {
        this.m_options = options;
        if (this.m_options.hasHelpOption()) {
            this.usage();
        }
        this.processInput();
    }

    protected void processInput() {
        this.addIncludes();
        this.determineLanguage();
        this.selectInput();
        this.selectLang();
        this.selectOutput();
        this.setGlobalReplacements();
        this.processHeader();
        this.writeClassDeclaration();
        this.writeInitialDeclarations();
        this.writeProperties();
        this.writeClasses();
        this.writeIndividuals();
        this.writeDatatypes();
        this.writeClassClose();
        this.processFooter();
        this.closeOutput();
    }

    protected void addIncludes() {
        this.m_includeURI.addAll(this.m_options.getIncludeOption());
    }

    protected void determineLanguage() {
        OntModelSpec s = null;
        s = this.m_options.hasLangRdfsOption() ? (this.m_options.hasUseInfOption() ? OntModelSpec.RDFS_MEM_RDFS_INF : OntModelSpec.RDFS_MEM) : (this.m_options.hasUseInfOption() ? OntModelSpec.OWL_MEM_RULE_INF : OntModelSpec.OWL_MEM);
        this.m_source = ModelFactory.createOntologyModel((OntModelSpec)s, null);
        this.m_source.getDocumentManager().setProcessImports(false);
        if (this.m_options.hasNoStrictOption()) {
            this.m_source.setStrictMode(false);
        }
    }

    protected void selectInput() {
        if (!this.m_options.hasInputOption()) {
            this.usage();
        }
        String input = SchemagenUtils.urlCheck(this.m_options.getInputOption().getURI());
        String syntax = this.m_options.getEncodingOption();
        try {
            this.m_source.read(input, syntax);
        }
        catch (JenaException e) {
            this.abort("Failed to read input source " + input, (Exception)((Object)e));
        }
    }

    protected void selectLang() {
        this.m_lang = this.m_options.hasLangOption() ? this.m_options.getLangOption() : null;
    }

    protected void selectOutput() {
        String outFile = this.m_options.getOutputOption();
        if (outFile == null) {
            this.m_output = System.out;
        } else {
            try {
                File out;
                String packageName = this.m_options.getPackagenameOption();
                if (packageName != null) {
                    String packagePath = "";
                    for (String p : packageName.split("\\.")) {
                        packagePath = packagePath + File.separator + p;
                    }
                    if (!outFile.endsWith(packagePath)) {
                        outFile = outFile + packagePath;
                    }
                }
                if (!(out = new File(outFile)).exists() && !outFile.endsWith(".java")) {
                    out.mkdirs();
                }
                if (out.isDirectory()) {
                    String fileName = outFile + File.separator + this.getClassName() + ".java";
                    out = new File(fileName);
                }
                this.m_output = new PrintStream(new FileOutputStream(out));
            }
            catch (Exception e) {
                this.abort("I/O error while trying to open file for writing: " + outFile, e);
            }
        }
        if (this.m_options.hasDosOption()) {
            this.m_nl = "\r\n";
        }
    }

    protected void processHeader() {
        String header;
        String string = header = this.m_options.hasHeaderOption() ? this.m_options.getHeaderOption() : DEFAULT_HEADER_TEMPLATE;
        if (!this.m_options.hasNoheaderOption()) {
            this.writeln(0, this.substitute(header));
        } else {
            this.writeln(0, "import org.apache.jena.rdf.model.*;");
            if (this.m_options.hasOntologyOption()) {
                this.writeln(0, "import org.apache.jena.ontology.*;");
            }
            if (this.m_options.hasIncludeSourceOption()) {
                this.writeln(0, "import java.io.ByteArrayInputStream;");
            }
        }
    }

    protected void processFooter() {
        String footer = this.m_options.getFooterOption();
        if (footer != null) {
            this.writeln(0, this.substitute(footer));
        }
    }

    protected void setGlobalReplacements() {
        this.addReplacementPattern("date", new SimpleDateFormat("dd MMM yyyy HH:mm").format(new Date()));
        this.addReplacementPattern("package", this.m_options.hasPackagenameOption() ? "package " + this.m_options.getPackagenameOption() + ";" : "");
        this.addReplacementPattern("imports", this.getImports());
        this.addReplacementPattern("classname", this.getClassName());
        this.addReplacementPattern("nl", this.m_nl);
        String source = this.m_options.getInputOption().getURI();
        if (source.matches("(file:|[A-Za-z]:).*$")) {
            source = source.replace("\\", "\\\\");
        }
        this.addReplacementPattern("sourceURI", source);
    }

    protected void addReplacementPattern(String key, String replacement) {
        if (replacement != null && key != null) {
            String marker = this.m_options.getMarkerOption();
            marker = marker == null ? DEFAULT_MARKER : marker;
            try {
                this.m_replacements.add(new Replacement(Pattern.compile(marker + key + marker), replacement));
            }
            catch (PatternSyntaxException e) {
                this.abort("Malformed regexp pattern " + marker + key + marker, e);
            }
        }
    }

    protected void pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.m_replacements.remove(this.m_replacements.size() - 1);
        }
    }

    protected void closeOutput() {
        this.m_output.flush();
        this.m_output.close();
    }

    protected void abort(String msg, Exception cause) {
        throw new SchemagenException(msg, cause);
    }

    protected void usage() {
        System.err.println("Usage:");
        System.err.println("  java jena.schemagen [options ...]");
        System.err.println();
        System.err.println("Commonly used options include:");
        System.err.println("   -i <input> the source document as a file or URL.");
        System.err.println("   -l <lang> the desired language to use to retrieve comments.");
        System.err.println("   -n <name> the name of the created Java class.");
        System.err.println("   -a <uri> the namespace URI of the source document.");
        System.err.println("   -o <file> the file to write the generated class into.");
        System.err.println("   -o <dir> the directory in which the generated Java class is created.");
        System.err.println("            By default, output goes to stdout.");
        System.err.println("   -e <encoding> the encoding of the input document (N3, RDF/XML, etc).");
        System.err.println("   -c <config> a filename or URL for an RDF document containing ");
        System.err.println("               configuration parameters.");
        System.err.println();
        System.err.println("Many other options are available. See the schemagen HOWTO in the ");
        System.err.println("Jena documentation for full details.");
        System.exit(1);
    }

    protected String substitute(String sIn) {
        String s = sIn;
        for (Replacement r : this.m_replacements) {
            s = r.pattern.matcher(s).replaceAll(r.sub);
        }
        return s;
    }

    protected int indentTo(int i, StringBuilder buf) {
        int indent = i * this.m_indentStep;
        for (int j = 0; j < indent; ++j) {
            buf.append(' ');
        }
        return indent;
    }

    protected void writeln(int indent) {
        this.writeln(indent, "");
    }

    protected void writeln(int indent, String s) {
        this.write(indent, s);
        this.m_output.print(this.m_nl);
    }

    protected void write(int indentLevel, String s) {
        for (int i = 0; i < this.m_indentStep * indentLevel; ++i) {
            this.m_output.print(" ");
        }
        this.m_output.print(s);
    }

    protected String getImports() {
        StringBuilder buf = new StringBuilder();
        buf.append("import org.apache.jena.rdf.model.*;");
        buf.append(this.m_nl);
        if (this.useOntology()) {
            buf.append("import org.apache.jena.ontology.*;");
            buf.append(this.m_nl);
        }
        if (this.includeSource()) {
            buf.append("import java.io.ByteArrayInputStream;");
            buf.append(this.m_nl);
        }
        return buf.toString();
    }

    protected String getClassName() {
        int i;
        if (this.m_options.hasClassnameOption()) {
            return this.m_options.getClassnameOption();
        }
        String uri = this.m_options.getInputOption().getURI();
        uri = uri.endsWith("#") ? uri.substring(0, uri.length() - 1) : uri;
        uri = uri.endsWith(".daml") ? uri.substring(0, uri.length() - 5) : uri;
        uri = uri.endsWith(".owl") ? uri.substring(0, uri.length() - 4) : uri;
        uri = uri.endsWith(".rdf") ? uri.substring(0, uri.length() - 4) : uri;
        uri = uri.endsWith(".rdfs") ? uri.substring(0, uri.length() - 5) : uri;
        uri = uri.endsWith(".n3") ? uri.substring(0, uri.length() - 3) : uri;
        uri = uri.endsWith(".xml") ? uri.substring(0, uri.length() - 4) : uri;
        uri = uri.endsWith(".ttl") ? uri.substring(0, uri.length() - 4) : uri;
        for (i = uri.length() - 1; i > 0; --i) {
            if (Character.isUnicodeIdentifierPart(uri.charAt(i)) || uri.charAt(i) == '-') continue;
            ++i;
            break;
        }
        String name = uri.substring(i);
        if (this.m_options.hasClassnameSuffixOption()) {
            name = name + this.m_options.getClassnameSuffixOption();
        }
        return this.asLegalJavaID(name, true);
    }

    protected boolean useOntology() {
        return this.m_options.hasOntologyOption();
    }

    protected boolean noComments() {
        return this.m_options.hasNoCommentsOption();
    }

    protected boolean includeSource() {
        return this.m_options.hasIncludeSourceOption();
    }

    protected String asLegalJavaID(String s, boolean cap) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        try {
            while (!Character.isJavaIdentifierStart(s.charAt(i))) {
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println("Could not identify legal Java identifier start character in '" + s + "', replacing with __");
            return "__";
        }
        buf.append(cap ? Character.toUpperCase(s.charAt(i)) : s.charAt(i));
        ++i;
        while (i < s.length()) {
            char c = s.charAt(i);
            buf.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
            ++i;
        }
        if (KEYWORD_LIST.contains(buf.toString())) {
            buf.append('_');
        }
        return buf.toString();
    }

    protected void writeClassDeclaration() {
        this.write(0, "public class ");
        this.write(0, this.getClassName());
        this.write(0, " ");
        if (this.m_options.hasClassdecOption()) {
            this.write(0, this.m_options.getClassdecOption());
        }
        this.writeln(0, "{");
    }

    protected void writeClassClose() {
        this.writeln(0, "}");
    }

    protected void writeInitialDeclarations() {
        this.writeModelDeclaration();
        this.writeSource();
        this.writeNamespace();
        this.writeOntologyVersionInfo();
        if (this.m_options.hasDeclarationsOption()) {
            this.writeln(0, this.m_options.getDeclarationsOption());
        }
    }

    protected void writeModelDeclaration() {
        if (this.useOntology()) {
            String lang = "OWL";
            if (this.m_options.hasLangRdfsOption()) {
                lang = "RDFS";
            }
            this.writeln(1, "/** <p>The ontology model that holds the vocabulary terms</p> */");
            this.writeln(1, "private static final OntModel M_MODEL = ModelFactory.createOntologyModel( OntModelSpec." + lang + "_MEM, null );");
        } else {
            this.writeln(1, "/** <p>The RDF model that holds the vocabulary terms</p> */");
            this.writeln(1, "private static final Model M_MODEL = ModelFactory.createDefaultModel();");
        }
        this.writeln(1);
    }

    protected void writeSource() {
        if (this.includeSource()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            RDFWriter rw = this.m_source.getWriter("Turtle");
            rw.setProperty("objectLists", (Object)Boolean.FALSE.toString());
            rw.write((Model)this.m_source, (OutputStream)bos, null);
            String output = bos.toString();
            this.writeln(1, "private static final String SOURCE = ");
            boolean first = true;
            StringTokenizer st = new StringTokenizer(output, "\n");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.endsWith("\r")) {
                    tok = tok.substring(0, tok.length() - 1);
                }
                this.write(2, first ? "   " : " + ");
                this.write(0, "\"");
                this.write(0, this.protectQuotes(tok));
                this.writeln(2, "\\n\"");
                first = false;
            }
            this.writeln(1, ";");
            this.writeln(0, "");
            this.writeln(1, "/** Read the ontology definition into the source model */ ");
            this.writeln(1, "static { ");
            this.writeln(2, "M_MODEL.read( new ByteArrayInputStream( SOURCE.getBytes() ), null, \"N3\" );");
            this.writeln(1, "}");
            this.writeln(0, "");
        }
    }

    private String protectQuotes(String s) {
        return s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }

    protected void writeOntologyVersionInfo() {
        String versionInfo = this.getOntologyElementVersionInfo();
        if (null != versionInfo) {
            this.writeln(1, "/** <p>The ontology's owl:versionInfo as a string</p> */");
            this.writeln(1, "public static final String VERSION_INFO = \"" + this.protectQuotes(versionInfo) + "\";");
            this.writeln(1);
        }
    }

    protected void writeNamespace() {
        String nsURI = this.determineNamespaceURI();
        this.writeln(1, "/** <p>The namespace of the vocabulary as a string</p> */");
        this.writeln(1, "public static final String NS = \"" + nsURI + "\";");
        this.writeln(1);
        this.writeln(1, "/** <p>The namespace of the vocabulary as a string</p>");
        this.writeln(1, " * @return namespace as String");
        this.writeln(1, " * @see #NS */");
        this.writeln(1, "public static String getURI() {return NS;}");
        this.writeln(1);
        this.writeln(1, "/** <p>The namespace of the vocabulary as a resource</p> */");
        this.writeln(1, "public static final Resource NAMESPACE = M_MODEL.createResource( NS );");
        this.writeln(1);
    }

    protected String determineNamespaceURI() {
        String ns = this.getOptionNamespace();
        if (ns == null) {
            ns = this.getDefaultPrefixNamespace();
        }
        if (ns == null) {
            ns = this.getOntologyElementNamespace();
        }
        if (ns == null) {
            ns = this.guessNamespace();
        }
        if (ns == null) {
            this.abort("Could not determine the base URI for the input vocabulary", null);
        }
        this.m_includeURI.add(ns);
        return ns;
    }

    protected String getOptionNamespace() {
        return this.m_options.hasNamespaceOption() ? this.m_options.getNamespaceOption().getURI() : null;
    }

    protected String getDefaultPrefixNamespace() {
        String defaultNS = this.m_source.getNsPrefixURI("");
        if (defaultNS == null) {
            defaultNS = this.m_source.getBaseModel().getNsPrefixURI("");
        }
        return defaultNS;
    }

    protected String getOntologyElementVersionInfo() {
        StmtIterator i;
        String versionInfo = null;
        Resource ontologyClass = this.m_source.getProfile().ONTOLOGY();
        if (null != ontologyClass && (i = this.m_source.getBaseModel().listStatements(null, RDF.type, (RDFNode)ontologyClass)).hasNext()) {
            Resource ont = i.nextStatement().getSubject();
            StmtIterator j = this.m_source.getBaseModel().listStatements(ont, OWL.versionInfo, (RDFNode)null);
            if (j.hasNext()) {
                versionInfo = j.nextStatement().getObject().asLiteral().getLexicalForm();
                if (j.hasNext()) {
                    System.err.println("Warning: ambiguous owl:versionInfo - there are more than one owl:versionInfo statements.");
                    System.err.println("Picking first choice: " + versionInfo + ". Other choices are:");
                    while (j.hasNext()) {
                        System.err.print(" ");
                        System.err.print(j.nextStatement().getObject().toString());
                    }
                    System.err.println();
                }
            }
            if (i.hasNext()) {
                System.err.println("Warning: ambiguous owl:versionInfo - there is more than one owl:Ontology element.");
                System.err.println("Picking first choice: " + ont.getURI() + ". Other choices are:");
                while (i.hasNext()) {
                    System.err.print(" ");
                    System.err.print(i.nextStatement().getObject().toString());
                }
                System.err.println();
            }
        }
        return versionInfo;
    }

    protected String getOntologyElementNamespace() {
        String uri = null;
        StmtIterator i = this.m_source.getBaseModel().listStatements(null, RDF.type, (RDFNode)this.m_source.getProfile().ONTOLOGY());
        if (i.hasNext()) {
            Resource ont = i.nextStatement().getSubject();
            uri = ont.getURI();
            char ch = uri.charAt(uri.length() - 1);
            boolean endsWithNCNameCh = XMLChar.isNCName((int)ch);
            String string = uri = endsWithNCNameCh ? uri + "#" : uri;
            if (i.hasNext()) {
                System.err.println("Warning: ambiguous default namespace - there is more than one owl:Ontology element.");
                System.err.println("Picking first choice: " + uri + ". Other choices are:");
                while (i.hasNext()) {
                    System.err.print(" ");
                    System.err.print(i.nextStatement().getString());
                }
                System.err.println();
                System.err.println("Use the -a option to specify a particular namespace if required.");
            }
        }
        return uri;
    }

    protected String guessNamespace() {
        HashMap<String, Integer> nsCount = new HashMap<String, Integer>();
        StmtIterator i = this.m_source.listStatements();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            this.countNamespace(s.getSubject(), nsCount);
            this.countNamespace((Resource)s.getPredicate(), nsCount);
            if (!s.getObject().isResource()) continue;
            this.countNamespace(s.getResource(), nsCount);
        }
        String ns = null;
        int max = 0;
        for (String nsKey : nsCount.keySet()) {
            int count;
            if (OWL.getURI().equals(nsKey) || RDF.getURI().equals(nsKey) || RDFS.getURI().equals(nsKey) || XSD.getURI().equals(nsKey) || (count = ((Integer)nsCount.get(nsKey)).intValue()) <= max) continue;
            max = count;
            ns = nsKey;
        }
        return ns;
    }

    private void countNamespace(Resource r, Map<String, Integer> nsCount) {
        if (!r.isAnon()) {
            String ns = r.getNameSpace();
            Integer count = nsCount.containsKey(ns) ? nsCount.get(ns) : new Integer(0);
            Integer count1 = new Integer(count + 1);
            nsCount.put(ns, count1);
        }
    }

    protected void writeProperties() {
        if (this.m_options.hasNopropertiesOption()) {
            return;
        }
        if (this.m_options.hasPropertySectionOption()) {
            this.writeln(0, this.m_options.getPropertySectionOption());
        }
        if (this.useOntology()) {
            this.writeObjectProperties();
            this.writeDatatypeProperties();
            this.writeAnnotationProperties();
            this.writeRDFProperties(true);
        } else {
            this.writeRDFProperties(false);
        }
    }

    protected void writeObjectProperties() {
        String template;
        String string = template = this.m_options.hasPropTemplateOption() ? this.m_options.getPropTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        if (!this.m_options.hasLangRdfsOption()) {
            ExtendedIterator<? extends RDFNode> i = this.sorted((ExtendedIterator<? extends RDFNode>)this.m_source.listObjectProperties());
            while (i.hasNext()) {
                this.writeValue((Resource)i.next(), template, "ObjectProperty", "createObjectProperty", "_PROP");
            }
        }
    }

    protected void writeDatatypeProperties() {
        String template;
        String string = template = this.m_options.hasPropTemplateOption() ? this.m_options.getPropTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        if (!this.m_options.hasLangRdfsOption()) {
            ExtendedIterator<? extends RDFNode> i = this.sorted((ExtendedIterator<? extends RDFNode>)this.m_source.listDatatypeProperties());
            while (i.hasNext()) {
                this.writeValue((Resource)i.next(), template, "DatatypeProperty", "createDatatypeProperty", "_PROP");
            }
        }
    }

    protected void writeAnnotationProperties() {
        String template;
        String string = template = this.m_options.hasPropTemplateOption() ? this.m_options.getPropTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        if (!this.m_options.hasLangRdfsOption()) {
            ExtendedIterator<? extends RDFNode> i = this.sorted((ExtendedIterator<? extends RDFNode>)this.m_source.listAnnotationProperties());
            while (i.hasNext()) {
                this.writeValue((Resource)i.next(), template, "AnnotationProperty", "createAnnotationProperty", "_PROP");
            }
        }
    }

    protected void writeRDFProperties(boolean useOntProperty) {
        String template = this.m_options.hasPropTemplateOption() ? this.m_options.getPropTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        String propType = useOntProperty ? "OntProperty" : "Property";
        Resource[] props = this.m_options.hasLangOwlOption() ? new Resource[]{OWL.ObjectProperty, OWL.DatatypeProperty, RDF.Property} : new Resource[]{RDF.Property};
        ArrayList<Resource> propertyResources = new ArrayList<Resource>();
        for (Resource prop : props) {
            StmtIterator i = this.m_source.listStatements(null, RDF.type, (RDFNode)prop);
            while (i.hasNext()) {
                propertyResources.add(i.nextStatement().getSubject());
            }
        }
        ExtendedIterator<? extends RDFNode> i = this.sorted(propertyResources);
        while (i.hasNext()) {
            this.writeValue((Resource)i.next(), template, propType, "create" + propType, "_PROP");
        }
    }

    protected void writeClasses() {
        if (this.m_options.hasNoclassesOption()) {
            return;
        }
        if (this.m_options.hasClassSectionOption()) {
            this.writeln(0, this.m_options.getClassSectionOption());
        }
        if (this.useOntology()) {
            this.writeOntClasses();
        } else {
            this.writeRDFClasses();
        }
    }

    protected void writeOntClasses() {
        String template = this.m_options.hasClassTemplateOption() ? this.m_options.getClassTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        ExtendedIterator<? extends RDFNode> i = this.sorted((ExtendedIterator<? extends RDFNode>)this.m_source.listClasses());
        while (i.hasNext()) {
            this.writeValue((Resource)i.next(), template, "OntClass", "createClass", "_CLASS");
        }
    }

    protected void writeRDFClasses() {
        String template = this.m_options.hasClassTemplateOption() ? this.m_options.getClassTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        Resource cls = OWL.Class;
        if (this.m_options.hasLangRdfsOption()) {
            cls = RDFS.Class;
        }
        List classes = this.m_source.listStatements(null, RDF.type, (RDFNode)cls).mapWith(s -> s.getSubject()).toList();
        ExtendedIterator<? extends RDFNode> i = this.sorted(classes);
        while (i.hasNext()) {
            this.writeValue((Resource)i.next(), template, "Resource", "createResource", "_CLASS");
        }
    }

    protected void writeIndividuals() {
        if (this.m_options.hasNoindividualsOption()) {
            return;
        }
        if (this.m_options.hasIndividualsSectionOption()) {
            this.writeln(0, this.m_options.getIndividualsSectionOption());
        }
        if (this.useOntology()) {
            this.writeOntIndividuals();
        } else {
            this.writeRDFIndividuals();
        }
    }

    protected void writeOntIndividuals() {
        String template = this.m_options.hasIndividualTemplateOption() ? this.m_options.getIndividualTemplateOption() : DEFAULT_INDIVIDUAL_TEMPLATE;
        ExtendedIterator<? extends RDFNode> i = this.selectIndividuals();
        while (i.hasNext()) {
            String varName;
            Individual ind = (Individual)((Resource)i.next()).as(Individual.class);
            OntClass cls = ind.getOntClass();
            if (cls == null) {
                cls = OWL.Thing;
            }
            String valType = (varName = this.m_resourcesToNames.get(cls)) != null ? varName : "M_MODEL.createClass( \"" + cls.getURI() + "\" )";
            this.addReplacementPattern("valtype", valType);
            this.writeValue((Resource)ind, template, "Individual", "createIndividual", "_INSTANCE");
            this.pop(1);
        }
    }

    protected void writeRDFIndividuals() {
        String template = this.m_options.hasIndividualTemplateOption() ? this.m_options.getIndividualTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        ExtendedIterator<? extends RDFNode> i = this.selectIndividuals();
        while (i.hasNext()) {
            this.writeValue((Resource)i.next(), template, "Resource", "createResource", "_INSTANCE");
        }
    }

    protected ExtendedIterator<? extends RDFNode> selectIndividuals() {
        ArrayList<Resource> candidates = new ArrayList<Resource>();
        StmtIterator i = this.m_source.listStatements(null, RDF.type, (RDFNode)null);
        while (i.hasNext()) {
            String candTypeURI;
            Statement candidate = i.nextStatement();
            if (!candidate.getObject().isResource()) continue;
            Resource candObj = candidate.getResource();
            Resource candSubj = candidate.getSubject();
            if (!candObj.isAnon() && ((candTypeURI = candObj.getURI()).startsWith(RDF.getURI()) || candTypeURI.startsWith(OWL.getURI()) || candTypeURI.startsWith(RDFS.getURI())) || candSubj.isAnon() || !this.isIncluded(candObj) && !this.isIncluded(candSubj) || candidates.contains(candSubj)) continue;
            candidates.add(candSubj);
        }
        return this.sorted(candidates);
    }

    protected boolean isIncluded(Resource r) {
        boolean accepted = false;
        if (!r.isAnon()) {
            String uri = r.getURI();
            Iterator<String> j = this.m_includeURI.iterator();
            while (!accepted && j.hasNext()) {
                accepted = uri.startsWith(j.next());
            }
        }
        return accepted;
    }

    protected void writeDatatypes() {
        if (this.m_options.hasNodatatypesOption()) {
            return;
        }
        if (this.m_options.hasDatatypesSectionOption()) {
            this.writeln(0, this.m_options.getDatatypesSectionOption());
        }
        String template = this.m_options.hasDatatypeTemplateOption() ? this.m_options.getDatatypeTemplateOption() : "public static final %valclass% %valname% = M_MODEL.%valcreator%( \"%valuri%\" );";
        ExtendedIterator<? extends RDFNode> i = this.selectDatatypes();
        while (i.hasNext()) {
            this.writeValue((Resource)i.next(), template, "Resource", "createResource", "_DATATYPE");
        }
    }

    protected ExtendedIterator<? extends RDFNode> selectDatatypes() {
        ArrayList<Resource> candidates = new ArrayList<Resource>();
        StmtIterator i = this.m_source.listStatements(null, RDF.type, (RDFNode)RDFS.Datatype);
        while (i.hasNext()) {
            String candTypeURI;
            Resource candSubj;
            Statement candidate = i.nextStatement();
            if (!candidate.getObject().isResource() || !(candSubj = candidate.getSubject()).isAnon() && (candTypeURI = candSubj.getURI()).startsWith(XSD.getURI()) || candSubj.isAnon() || candidates.contains(candSubj)) continue;
            candidates.add(candSubj);
        }
        return this.sorted(candidates);
    }

    protected void writeValue(Resource r, String template, String valueClass, String creator, String disambiguator) {
        if (!this.filter(r)) {
            if (!this.noComments() && this.hasComment(r)) {
                this.writeln(1, this.formatComment(this.getComment(r)));
            }
            this.addReplacementPattern("valuri", r.getURI());
            this.addReplacementPattern("valname", this.getValueName(r, disambiguator));
            this.addReplacementPattern("valclass", valueClass);
            this.addReplacementPattern("valcreator", creator);
            this.writeln(1, this.substitute(template));
            this.writeln(1);
            this.pop(4);
        }
    }

    protected boolean hasComment(Resource r) {
        return r.hasProperty(RDFS.comment);
    }

    protected String getComment(Resource r) {
        StringBuilder comment = new StringBuilder();
        NodeIterator ni = this.m_source.listObjectsOfProperty(r, RDFS.comment);
        while (ni.hasNext()) {
            RDFNode n = ni.nextNode();
            if (n instanceof Literal) {
                if (this.m_lang == null || this.m_lang.trim().equals("")) {
                    comment.append(((Literal)n).getLexicalForm().trim());
                    continue;
                }
                if (!((Literal)n).getLanguage().equals(this.m_lang)) continue;
                comment.append(((Literal)n).getLexicalForm().trim());
                continue;
            }
            System.err.println("Warning: Comment on resource <" + r.getURI() + "> is not a literal: " + n);
        }
        return comment.toString();
    }

    protected String formatComment(String comment) {
        StringBuilder buf = new StringBuilder();
        buf.append("/** <p>");
        boolean inSpace = false;
        int pos = buf.length();
        boolean singleLine = true;
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            if (Character.isWhitespace(c)) {
                if (inSpace) continue;
                c = ' ';
                inSpace = true;
            } else {
                inSpace = false;
            }
            if (c == '\\') {
                c = comment.charAt(++i);
                switch (c) {
                    case 'n': {
                        buf.append(this.m_nl);
                        pos = this.indentTo(1, buf);
                        buf.append(" *  ");
                        pos += 3;
                        singleLine = false;
                        break;
                    }
                }
            } else if (c == '<') {
                buf.append("&lt;");
                pos += 4;
            } else if (c == '>') {
                buf.append("&gt;");
                pos += 4;
            } else if (c == '&') {
                buf.append("&amp;");
                pos += 5;
            } else {
                buf.append(c);
                ++pos;
            }
            if (pos <= 80 || !inSpace) continue;
            buf.append(this.m_nl);
            pos = this.indentTo(1, buf);
            buf.append(" *  ");
            pos += 3;
            singleLine = false;
        }
        buf.append("</p>");
        buf.append(singleLine ? "" : this.m_nl);
        this.indentTo(singleLine ? 0 : 1, buf);
        buf.append(" */");
        return buf.toString();
    }

    protected boolean filter(Resource r) {
        if (r.isAnon()) {
            return true;
        }
        if (this.m_resourcesToNames.containsKey(r)) {
            return true;
        }
        for (String uri : this.m_includeURI) {
            if (!r.getURI().startsWith(uri)) continue;
            return false;
        }
        if (!this.m_options.hasStrictIndividualsOption()) {
            StmtIterator j = r.listProperties(RDF.type);
            while (j.hasNext()) {
                Resource typeRes = j.nextStatement().getResource();
                if (typeRes.isAnon()) continue;
                String typeURI = typeRes.getURI();
                for (String uri : this.m_includeURI) {
                    if (!typeURI.startsWith(uri)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected String getValueName(Resource r, String disambiguator) {
        String name = this.m_options.hasUcNamesOption() ? this.getUCValueName(r) : r.getLocalName();
        name = this.asLegalJavaID(name, false);
        int attempt = 0;
        String baseName = name;
        while (this.m_usedNames.contains(name)) {
            name = attempt == 0 ? name + disambiguator : baseName + disambiguator + attempt;
            ++attempt;
        }
        this.m_usedNames.add(name);
        this.m_resourcesToNames.put(r, name);
        return name;
    }

    protected String getUCValueName(Resource r) {
        StringBuilder buf = new StringBuilder();
        String localName = r.getLocalName();
        char lastChar = '\u0000';
        for (int i = 0; i < localName.length(); ++i) {
            char c = localName.charAt(i);
            if (Character.isLowerCase(lastChar) && Character.isUpperCase(c)) {
                buf.append('_');
            }
            buf.append(Character.toUpperCase(c));
            lastChar = c;
        }
        return buf.toString();
    }

    protected ExtendedIterator<? extends RDFNode> sorted(ExtendedIterator<? extends RDFNode> i) {
        return this.sorted(i.toList());
    }

    protected ExtendedIterator<? extends RDFNode> sorted(List<? extends RDFNode> members) {
        Collections.sort(members, new Comparator<RDFNode>(){

            @Override
            public int compare(RDFNode n0, RDFNode n1) {
                if (n0.isLiteral() || n1.isLiteral()) {
                    if (n0.isLiteral() && n1.isLiteral()) {
                        Literal l0 = (Literal)n0;
                        Literal l1 = (Literal)n1;
                        return l0.getLexicalForm().compareTo(l1.getLexicalForm());
                    }
                    return n0.isLiteral() ? -1 : 1;
                }
                Resource r0 = (Resource)n0;
                Resource r1 = (Resource)n1;
                if (r0.isAnon() && r1.isAnon()) {
                    return r0.getId().toString().compareTo(r1.getId().toString());
                }
                if (r0.isAnon()) {
                    return -1;
                }
                if (r1.isAnon()) {
                    return 1;
                }
                return r0.getURI().compareTo(r1.getURI());
            }
        });
        return WrappedIterator.create(members.iterator());
    }

    static {
        LogCtl.setLogging();
        JAVA_KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
        KEYWORD_LIST = Arrays.asList(JAVA_KEYWORDS);
    }

    public static class SchemagenUtils {
        public static String urlCheck(String uriOrFile) {
            boolean legal = true;
            String url = uriOrFile;
            try {
                new URL(url);
            }
            catch (MalformedURLException ignore) {
                legal = false;
            }
            if (!legal) {
                legal = true;
                String slash = System.getProperty("file.separator");
                url = "file:" + (uriOrFile.startsWith(slash) ? slash + slash : "") + uriOrFile;
                try {
                    new URL(url);
                }
                catch (MalformedURLException ignore) {
                    legal = false;
                }
            }
            if (!legal) {
                throw new SchemagenException("Could not parse " + uriOrFile + " as a legal URL or a file reference. Aborting.", null);
            }
            return url;
        }
    }

    public static class SchemagenException
    extends RuntimeException {
        public SchemagenException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    protected class Replacement {
        protected String sub;
        protected Pattern pattern;

        protected Replacement(Pattern pattern, String sub) {
            this.sub = sub;
            this.pattern = pattern;
        }
    }

    public static class OptionDefinition {
        protected String m_cmdLineForm;
        protected Property m_prop;

        protected OptionDefinition(String cmdLineForm, String name) {
            this.m_cmdLineForm = cmdLineForm;
            if (name != null) {
                this.m_prop = ResourceFactory.createProperty((String)schemagen.NS, (String)name);
            }
        }

        public Property getDeclarationProperty() {
            return this.m_prop;
        }

        public String getCommandLineForm() {
            return this.m_cmdLineForm;
        }

        protected boolean isTrue(List<String> cmdLineArgs, Resource confRoot) {
            if (cmdLineArgs.contains(this.m_cmdLineForm)) {
                return true;
            }
            if (confRoot.hasProperty(this.m_prop)) {
                return confRoot.getRequiredProperty(this.m_prop).getBoolean();
            }
            return false;
        }

        protected String getStringValue(List<String> cmdLineArgs, Resource confRoot) {
            RDFNode n = this.getValue(cmdLineArgs, confRoot);
            return n == null ? null : (n.isLiteral() ? n.asLiteral().getLexicalForm() : n.toString());
        }

        protected RDFNode getValue(List<String> cmdLineArgs, Resource confRoot) {
            int index = cmdLineArgs.indexOf(this.m_cmdLineForm);
            if (index >= 0) {
                try {
                    return ResourceFactory.createPlainLiteral((String)cmdLineArgs.get(index + 1));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SchemagenException("Value for parameter " + this.m_cmdLineForm + " not set! Aborting.", e);
                }
            }
            if (this.m_prop != null && confRoot != null && confRoot.hasProperty(this.m_prop)) {
                return confRoot.getRequiredProperty(this.m_prop).getObject();
            }
            return null;
        }

        protected boolean hasValue(List<String> cmdLineArgs, Resource confRoot) {
            return this.getValue(cmdLineArgs, confRoot) != null;
        }

        protected Resource getResource(List<String> cmdLineArgs, Resource confRoot) {
            int index = cmdLineArgs.indexOf(this.m_cmdLineForm);
            if (index >= 0) {
                try {
                    return confRoot.getModel().getResource(cmdLineArgs.get(index + 1));
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("Value for parameter " + this.m_cmdLineForm + " not set! Aborting.");
                }
            }
            if (this.m_prop != null && confRoot.hasProperty(this.m_prop)) {
                return confRoot.getRequiredProperty(this.m_prop).getResource();
            }
            return null;
        }

        protected boolean hasResourceValue(List<String> cmdLineArgs, Resource confRoot) {
            return this.getResource(cmdLineArgs, confRoot) != null;
        }
    }

    public static class SchemagenOptionsImpl
    implements SchemagenOptions {
        private List<String> m_cmdLineArgs;
        private Resource m_root;
        private Model m_config;

        public SchemagenOptionsImpl(String[] args) {
            block3: {
                this.m_cmdLineArgs = new ArrayList<String>();
                this.m_config = ModelFactory.createDefaultModel();
                this.m_cmdLineArgs = Arrays.asList(args);
                String configURL = schemagen.DEFAULT_CONFIG_URI;
                if (this.hasConfigFileOption()) {
                    configURL = SchemagenUtils.urlCheck(this.getConfigFileOption());
                }
                try {
                    RDFDataMgr.read((Model)this.m_config, (String)configURL);
                }
                catch (Exception e) {
                    if (configURL.equals(schemagen.DEFAULT_CONFIG_URI)) break block3;
                    throw new SchemagenException("Failed to read configuration from URL: " + configURL, e);
                }
            }
            this.determineConfigRoot();
        }

        protected Model getConfigModel() {
            return this.m_config;
        }

        protected Resource getConfigRoot() {
            if (this.m_root == null) {
                this.determineConfigRoot();
            }
            return this.m_root;
        }

        protected void determineConfigRoot() {
            StmtIterator i;
            this.m_root = this.hasValue(SchemagenOptions.OPT.ROOT) ? this.m_config.getResource(this.getStringValue(SchemagenOptions.OPT.ROOT)) : ((i = this.m_config.listStatements(null, RDF.type, (RDFNode)this.m_config.getResource("http://jena.hpl.hp.com/2003/04/schemagen#Config"))).hasNext() ? i.nextStatement().getSubject() : this.m_config.createResource());
        }

        protected boolean isTrue(SchemagenOptions.OPT option) {
            return this.getOpt(option).isTrue(this.m_cmdLineArgs, this.m_root);
        }

        protected boolean hasValue(SchemagenOptions.OPT option) {
            return this.getOpt(option).hasValue(this.m_cmdLineArgs, this.m_root);
        }

        protected RDFNode getValue(SchemagenOptions.OPT option) {
            return this.getOpt(option).getValue(this.m_cmdLineArgs, this.m_root);
        }

        protected String getStringValue(SchemagenOptions.OPT option) {
            return this.getOpt(option).getStringValue(this.m_cmdLineArgs, this.m_root);
        }

        protected boolean hasResourceValue(SchemagenOptions.OPT option) {
            return this.getOpt(option).hasResourceValue(this.m_cmdLineArgs, this.m_root);
        }

        protected Resource getResource(SchemagenOptions.OPT option) {
            return this.getOpt(option).getResource(this.m_cmdLineArgs, this.m_root);
        }

        protected List<String> getAllValues(SchemagenOptions.OPT option) {
            String s;
            ArrayList<String> values = new ArrayList<String>();
            OptionDefinition opt = this.getOpt(option);
            StmtIterator i = this.m_cmdLineArgs.iterator();
            while (i.hasNext()) {
                s = i.next();
                if (!s.equals(opt.m_cmdLineForm)) continue;
                values.add((String)i.next());
            }
            i = this.m_root.listProperties(opt.m_prop);
            while (i.hasNext()) {
                s = i.nextStatement();
                if (s.getObject() instanceof Literal) {
                    values.add(s.getString());
                    continue;
                }
                values.add(s.getResource().getURI());
            }
            return values;
        }

        protected OptionDefinition getOpt(SchemagenOptions.OPT option) {
            for (Object[] m_optionDefinition : m_optionDefinitions) {
                if (m_optionDefinition[0] != option) continue;
                return (OptionDefinition)m_optionDefinition[1];
            }
            return null;
        }

        @Override
        public boolean hasConfigFileOption() {
            return this.hasValue(SchemagenOptions.OPT.CONFIG_FILE);
        }

        @Override
        public String getConfigFileOption() {
            return this.getStringValue(SchemagenOptions.OPT.CONFIG_FILE);
        }

        @Override
        public boolean hasRootOption() {
            return this.hasValue(SchemagenOptions.OPT.ROOT);
        }

        @Override
        public String getRootOption() {
            return this.getStringValue(SchemagenOptions.OPT.ROOT);
        }

        @Override
        public boolean hasNoCommentsOption() {
            return this.isTrue(SchemagenOptions.OPT.NO_COMMENTS);
        }

        @Override
        public String getNoCommentsOption() {
            return this.getStringValue(SchemagenOptions.OPT.NO_COMMENTS);
        }

        @Override
        public boolean hasInputOption() {
            return this.hasValue(SchemagenOptions.OPT.INPUT);
        }

        @Override
        public Resource getInputOption() {
            return this.getResource(SchemagenOptions.OPT.INPUT);
        }

        @Override
        public boolean hasLangOption() {
            return this.hasValue(SchemagenOptions.OPT.LANG);
        }

        @Override
        public String getLangOption() {
            return this.getStringValue(SchemagenOptions.OPT.LANG);
        }

        @Override
        public boolean hasLangOwlOption() {
            return this.isTrue(SchemagenOptions.OPT.LANG_OWL);
        }

        @Override
        public String getLangOwlOption() {
            return this.getStringValue(SchemagenOptions.OPT.LANG_OWL);
        }

        @Override
        public boolean hasLangRdfsOption() {
            return this.isTrue(SchemagenOptions.OPT.LANG_RDFS);
        }

        @Override
        public String getLangRdfsOption() {
            return this.getStringValue(SchemagenOptions.OPT.LANG_RDFS);
        }

        @Override
        public boolean hasOutputOption() {
            return this.hasValue(SchemagenOptions.OPT.OUTPUT);
        }

        @Override
        public String getOutputOption() {
            return this.getStringValue(SchemagenOptions.OPT.OUTPUT);
        }

        @Override
        public boolean hasHeaderOption() {
            return this.hasValue(SchemagenOptions.OPT.HEADER);
        }

        @Override
        public String getHeaderOption() {
            return this.getStringValue(SchemagenOptions.OPT.HEADER);
        }

        @Override
        public boolean hasFooterOption() {
            return this.isTrue(SchemagenOptions.OPT.FOOTER);
        }

        @Override
        public String getFooterOption() {
            return this.getStringValue(SchemagenOptions.OPT.FOOTER);
        }

        @Override
        public boolean hasMarkerOption() {
            return this.hasValue(SchemagenOptions.OPT.MARKER);
        }

        @Override
        public String getMarkerOption() {
            return this.getStringValue(SchemagenOptions.OPT.MARKER);
        }

        @Override
        public boolean hasPackagenameOption() {
            return this.hasValue(SchemagenOptions.OPT.PACKAGENAME);
        }

        @Override
        public String getPackagenameOption() {
            return this.getStringValue(SchemagenOptions.OPT.PACKAGENAME);
        }

        @Override
        public boolean hasOntologyOption() {
            return this.isTrue(SchemagenOptions.OPT.ONTOLOGY);
        }

        @Override
        public String getOntologyOption() {
            return this.getStringValue(SchemagenOptions.OPT.ONTOLOGY);
        }

        @Override
        public boolean hasClassnameOption() {
            return this.hasValue(SchemagenOptions.OPT.CLASSNAME);
        }

        @Override
        public String getClassnameOption() {
            return this.getStringValue(SchemagenOptions.OPT.CLASSNAME);
        }

        @Override
        public boolean hasClassdecOption() {
            return this.hasValue(SchemagenOptions.OPT.CLASSDEC);
        }

        @Override
        public String getClassdecOption() {
            return this.getStringValue(SchemagenOptions.OPT.CLASSDEC);
        }

        @Override
        public boolean hasNamespaceOption() {
            return this.hasValue(SchemagenOptions.OPT.NAMESPACE);
        }

        @Override
        public Resource getNamespaceOption() {
            return this.getResource(SchemagenOptions.OPT.NAMESPACE);
        }

        @Override
        public boolean hasDeclarationsOption() {
            return this.hasValue(SchemagenOptions.OPT.DECLARATIONS);
        }

        @Override
        public String getDeclarationsOption() {
            return this.getStringValue(SchemagenOptions.OPT.DECLARATIONS);
        }

        @Override
        public boolean hasPropertySectionOption() {
            return this.hasValue(SchemagenOptions.OPT.PROPERTY_SECTION);
        }

        @Override
        public String getPropertySectionOption() {
            return this.getStringValue(SchemagenOptions.OPT.PROPERTY_SECTION);
        }

        @Override
        public boolean hasClassSectionOption() {
            return this.hasValue(SchemagenOptions.OPT.CLASS_SECTION);
        }

        @Override
        public String getClassSectionOption() {
            return this.getStringValue(SchemagenOptions.OPT.CLASS_SECTION);
        }

        @Override
        public boolean hasIndividualsSectionOption() {
            return this.hasValue(SchemagenOptions.OPT.INDIVIDUALS_SECTION);
        }

        @Override
        public String getIndividualsSectionOption() {
            return this.getStringValue(SchemagenOptions.OPT.INDIVIDUALS_SECTION);
        }

        @Override
        public boolean hasDatatypesSectionOption() {
            return this.hasValue(SchemagenOptions.OPT.DATATYPES_SECTION);
        }

        @Override
        public String getDatatypesSectionOption() {
            return this.getStringValue(SchemagenOptions.OPT.DATATYPES_SECTION);
        }

        @Override
        public boolean hasNopropertiesOption() {
            return this.isTrue(SchemagenOptions.OPT.NOPROPERTIES);
        }

        @Override
        public boolean hasNoclassesOption() {
            return this.isTrue(SchemagenOptions.OPT.NOCLASSES);
        }

        @Override
        public boolean hasNoindividualsOption() {
            return this.isTrue(SchemagenOptions.OPT.NOINDIVIDUALS);
        }

        @Override
        public boolean hasNodatatypesOption() {
            return this.isTrue(SchemagenOptions.OPT.NODATATYPES);
        }

        @Override
        public boolean hasPropTemplateOption() {
            return this.hasValue(SchemagenOptions.OPT.PROP_TEMPLATE);
        }

        @Override
        public String getPropTemplateOption() {
            return this.getStringValue(SchemagenOptions.OPT.PROP_TEMPLATE);
        }

        @Override
        public boolean hasClassTemplateOption() {
            return this.hasValue(SchemagenOptions.OPT.CLASS_TEMPLATE);
        }

        @Override
        public String getClassTemplateOption() {
            return this.getStringValue(SchemagenOptions.OPT.CLASS_TEMPLATE);
        }

        @Override
        public boolean hasIndividualTemplateOption() {
            return this.hasValue(SchemagenOptions.OPT.INDIVIDUAL_TEMPLATE);
        }

        @Override
        public String getIndividualTemplateOption() {
            return this.getStringValue(SchemagenOptions.OPT.INDIVIDUAL_TEMPLATE);
        }

        @Override
        public boolean hasDatatypeTemplateOption() {
            return this.hasValue(SchemagenOptions.OPT.DATATYPE_TEMPLATE);
        }

        @Override
        public String getDatatypeTemplateOption() {
            return this.getStringValue(SchemagenOptions.OPT.DATATYPE_TEMPLATE);
        }

        @Override
        public boolean hasUcNamesOption() {
            return this.isTrue(SchemagenOptions.OPT.UC_NAMES);
        }

        @Override
        public boolean hasIncludeOption() {
            return this.hasValue(SchemagenOptions.OPT.INCLUDE);
        }

        @Override
        public List<String> getIncludeOption() {
            return this.getAllValues(SchemagenOptions.OPT.INCLUDE);
        }

        @Override
        public boolean hasClassnameSuffixOption() {
            return this.hasValue(SchemagenOptions.OPT.CLASSNAME_SUFFIX);
        }

        @Override
        public String getClassnameSuffixOption() {
            return this.getStringValue(SchemagenOptions.OPT.CLASSNAME_SUFFIX);
        }

        @Override
        public boolean hasNoheaderOption() {
            return this.isTrue(SchemagenOptions.OPT.NOHEADER);
        }

        @Override
        public boolean hasEncodingOption() {
            return this.hasValue(SchemagenOptions.OPT.ENCODING);
        }

        @Override
        public String getEncodingOption() {
            return this.getStringValue(SchemagenOptions.OPT.ENCODING);
        }

        @Override
        public boolean hasHelpOption() {
            return this.hasValue(SchemagenOptions.OPT.HELP);
        }

        @Override
        public String getHelpOption() {
            return this.getStringValue(SchemagenOptions.OPT.HELP);
        }

        @Override
        public boolean hasDosOption() {
            return this.isTrue(SchemagenOptions.OPT.DOS);
        }

        @Override
        public boolean hasUseInfOption() {
            return this.isTrue(SchemagenOptions.OPT.USE_INF);
        }

        @Override
        public boolean hasStrictIndividualsOption() {
            return this.isTrue(SchemagenOptions.OPT.STRICT_INDIVIDUALS);
        }

        @Override
        public boolean hasIncludeSourceOption() {
            return this.isTrue(SchemagenOptions.OPT.INCLUDE_SOURCE);
        }

        @Override
        public boolean hasNoStrictOption() {
            return this.isTrue(SchemagenOptions.OPT.NO_STRICT);
        }
    }

    public static interface SchemagenOptions {
        public static final Object[][] m_optionDefinitions = new Object[][]{{OPT.CONFIG_FILE, new OptionDefinition("-c", "configFile")}, {OPT.ROOT, new OptionDefinition("-r", "root")}, {OPT.NO_COMMENTS, new OptionDefinition("--nocomments", "noComments")}, {OPT.INPUT, new OptionDefinition("-i", "input")}, {OPT.LANG, new OptionDefinition("-l", "lang")}, {OPT.LANG_DAML, new OptionDefinition("--daml", "daml")}, {OPT.LANG_OWL, new OptionDefinition("--owl", "owl")}, {OPT.LANG_RDFS, new OptionDefinition("--rdfs", "rdfs")}, {OPT.OUTPUT, new OptionDefinition("-o", "output")}, {OPT.HEADER, new OptionDefinition("--header", "header")}, {OPT.FOOTER, new OptionDefinition("--footer", "footer")}, {OPT.MARKER, new OptionDefinition("--marker", "marker")}, {OPT.PACKAGENAME, new OptionDefinition("--package", "package")}, {OPT.ONTOLOGY, new OptionDefinition("--ontology", "ontology")}, {OPT.CLASSNAME, new OptionDefinition("-n", "classname")}, {OPT.CLASSDEC, new OptionDefinition("--classdec", "classdec")}, {OPT.NAMESPACE, new OptionDefinition("-a", "namespace")}, {OPT.DECLARATIONS, new OptionDefinition("--declarations", "declarations")}, {OPT.PROPERTY_SECTION, new OptionDefinition("--propSection", "propSection")}, {OPT.CLASS_SECTION, new OptionDefinition("--classSection", "classSection")}, {OPT.INDIVIDUALS_SECTION, new OptionDefinition("--individualsSection", "individualsSection")}, {OPT.DATATYPES_SECTION, new OptionDefinition("--datatypesSection", "datatypesSection")}, {OPT.NOPROPERTIES, new OptionDefinition("--noproperties", "noproperties")}, {OPT.NOCLASSES, new OptionDefinition("--noclasses", "noclasses")}, {OPT.NOINDIVIDUALS, new OptionDefinition("--noindividuals", "noindividuals")}, {OPT.NODATATYPES, new OptionDefinition("--nodatatypes", "nodatatypes")}, {OPT.PROP_TEMPLATE, new OptionDefinition("--propTemplate", "propTemplate")}, {OPT.CLASS_TEMPLATE, new OptionDefinition("--classTemplate", "classTemplate")}, {OPT.INDIVIDUAL_TEMPLATE, new OptionDefinition("--individualTemplate", "individualTemplate")}, {OPT.DATATYPE_TEMPLATE, new OptionDefinition("--datatypeTemplate", "datatypeTemplate")}, {OPT.UC_NAMES, new OptionDefinition("--uppercase", "uppercase")}, {OPT.INCLUDE, new OptionDefinition("--include", "include")}, {OPT.CLASSNAME_SUFFIX, new OptionDefinition("--classnamesuffix", "classnamesuffix")}, {OPT.NOHEADER, new OptionDefinition("--noheader", "noheader")}, {OPT.ENCODING, new OptionDefinition("-e", "encoding")}, {OPT.HELP, new OptionDefinition("--help", "help")}, {OPT.DOS, new OptionDefinition("--dos", "dos")}, {OPT.USE_INF, new OptionDefinition("--inference", "inference")}, {OPT.STRICT_INDIVIDUALS, new OptionDefinition("--strictIndividuals", "strictIndividuals")}, {OPT.INCLUDE_SOURCE, new OptionDefinition("--includeSource", "includeSource")}, {OPT.NO_STRICT, new OptionDefinition("--nostrict", "noStrict")}};

        public boolean hasConfigFileOption();

        public String getConfigFileOption();

        public boolean hasRootOption();

        public String getRootOption();

        public boolean hasNoCommentsOption();

        public String getNoCommentsOption();

        public boolean hasInputOption();

        public Resource getInputOption();

        public boolean hasLangOption();

        public String getLangOption();

        public boolean hasLangOwlOption();

        public String getLangOwlOption();

        public boolean hasLangRdfsOption();

        public String getLangRdfsOption();

        public boolean hasOutputOption();

        public String getOutputOption();

        public boolean hasHeaderOption();

        public String getHeaderOption();

        public boolean hasFooterOption();

        public String getFooterOption();

        public boolean hasMarkerOption();

        public String getMarkerOption();

        public boolean hasPackagenameOption();

        public String getPackagenameOption();

        public boolean hasOntologyOption();

        public String getOntologyOption();

        public boolean hasClassnameOption();

        public String getClassnameOption();

        public boolean hasClassdecOption();

        public String getClassdecOption();

        public boolean hasNamespaceOption();

        public Resource getNamespaceOption();

        public boolean hasDeclarationsOption();

        public String getDeclarationsOption();

        public boolean hasPropertySectionOption();

        public String getPropertySectionOption();

        public boolean hasClassSectionOption();

        public String getClassSectionOption();

        public boolean hasIndividualsSectionOption();

        public String getIndividualsSectionOption();

        public boolean hasDatatypesSectionOption();

        public String getDatatypesSectionOption();

        public boolean hasNopropertiesOption();

        public boolean hasNoclassesOption();

        public boolean hasNoindividualsOption();

        public boolean hasNodatatypesOption();

        public boolean hasPropTemplateOption();

        public String getPropTemplateOption();

        public boolean hasClassTemplateOption();

        public String getClassTemplateOption();

        public boolean hasIndividualTemplateOption();

        public String getIndividualTemplateOption();

        public boolean hasDatatypeTemplateOption();

        public String getDatatypeTemplateOption();

        public boolean hasUcNamesOption();

        public boolean hasIncludeOption();

        public List<String> getIncludeOption();

        public boolean hasClassnameSuffixOption();

        public String getClassnameSuffixOption();

        public boolean hasNoheaderOption();

        public boolean hasEncodingOption();

        public String getEncodingOption();

        public boolean hasHelpOption();

        public String getHelpOption();

        public boolean hasDosOption();

        public boolean hasUseInfOption();

        public boolean hasStrictIndividualsOption();

        public boolean hasIncludeSourceOption();

        public boolean hasNoStrictOption();

        public static enum OPT {
            CONFIG_FILE,
            NO_COMMENTS,
            INPUT,
            LANG,
            LANG_DAML,
            LANG_OWL,
            LANG_RDFS,
            OUTPUT,
            HEADER,
            FOOTER,
            ROOT,
            MARKER,
            PACKAGENAME,
            ONTOLOGY,
            CLASSNAME,
            CLASSDEC,
            NAMESPACE,
            DECLARATIONS,
            PROPERTY_SECTION,
            CLASS_SECTION,
            INDIVIDUALS_SECTION,
            DATATYPES_SECTION,
            NOPROPERTIES,
            NOCLASSES,
            NOINDIVIDUALS,
            NODATATYPES,
            NOHEADER,
            PROP_TEMPLATE,
            CLASS_TEMPLATE,
            INDIVIDUAL_TEMPLATE,
            DATATYPE_TEMPLATE,
            UC_NAMES,
            INCLUDE,
            CLASSNAME_SUFFIX,
            ENCODING,
            HELP,
            DOS,
            USE_INF,
            STRICT_INDIVIDUALS,
            INCLUDE_SOURCE,
            NO_STRICT;

        }
    }
}

