/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.CmdGeneral;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.process.inf.InfFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class infer
extends CmdGeneral {
    static final ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private Model vocab;

    public static void main(String ... argv) {
        new infer(argv).mainRun();
    }

    protected infer(String[] argv) {
        super(argv);
        super.add(argRDFS);
    }

    @Override
    protected String getSummary() {
        return "infer --rdfs=vocab FILE ...";
    }

    @Override
    protected void processModulesAndArgs() {
        if (!this.contains(argRDFS)) {
            throw new CmdException("Required argument missing: --" + argRDFS.getKeyName());
        }
        String fn = this.getValue(argRDFS);
        this.vocab = RDFDataMgr.loadModel((String)fn);
    }

    @Override
    protected void exec() {
        StreamRDF sink = StreamRDFLib.writer((OutputStream)System.out);
        sink = InfFactory.inf((StreamRDF)sink, (Model)this.vocab);
        List<String> files = this.getPositionalOrStdin();
        if (files.isEmpty()) {
            files.add("-");
        }
        for (String fn : files) {
            this.processFile(fn, sink);
        }
        IO.flush((OutputStream)System.out);
    }

    private void processFile(String filename, StreamRDF sink) {
        Lang lang;
        Lang lang2 = lang = filename.equals("-") ? RDFLanguages.NQUADS : RDFLanguages.filenameToLang((String)filename, (Lang)RDFLanguages.NQUADS);
        if (filename.equals("-")) {
            RDFDataMgr.parse((StreamRDF)sink, (InputStream)System.in, null, (Lang)RDFLanguages.NQUADS);
        } else {
            RDFDataMgr.parse((StreamRDF)sink, (String)filename);
        }
    }

    @Override
    protected String getCommandName() {
        return "infer";
    }
}

