/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf;

import java.util.Optional;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFSyntax;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.jena.commonsrdf.ConversionException;
import org.apache.jena.commonsrdf.impl.JCR_Factory;
import org.apache.jena.commonsrdf.impl.JenaDataset;
import org.apache.jena.commonsrdf.impl.JenaGraph;
import org.apache.jena.commonsrdf.impl.JenaNode;
import org.apache.jena.commonsrdf.impl.JenaQuad;
import org.apache.jena.commonsrdf.impl.JenaTriple;
import org.apache.jena.commonsrdf.impl.ToDataset;
import org.apache.jena.commonsrdf.impl.ToGraph;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.web.LangTag;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sys.JenaSystem;

public class JenaCommonsRDF {
    public static Node toJena(RDFTerm term) {
        if (term == null) {
            return null;
        }
        if (term instanceof JenaNode) {
            return ((JenaNode)term).getNode();
        }
        if (term instanceof IRI) {
            return NodeFactory.createURI((String)((IRI)term).getIRIString());
        }
        if (term instanceof Literal) {
            Literal lit = (Literal)term;
            RDFDatatype dt = NodeFactory.getType((String)lit.getDatatype().getIRIString());
            String lang = lit.getLanguageTag().orElse("");
            lang = LangTag.canonical((String)lang);
            return NodeFactory.createLiteral((String)lit.getLexicalForm(), (String)lang, (RDFDatatype)dt);
        }
        if (term instanceof BlankNode) {
            String id = ((BlankNode)term).uniqueReference();
            return NodeFactory.createBlankNode((String)id);
        }
        JenaCommonsRDF.conversionError("Not a concrete RDF Term: " + term);
        return null;
    }

    public static Triple toJena(org.apache.commons.rdf.api.Triple triple) {
        if (triple instanceof JenaTriple) {
            return ((JenaTriple)triple).getTriple();
        }
        return new Triple(JenaCommonsRDF.toJena((RDFTerm)triple.getSubject()), JenaCommonsRDF.toJena((RDFTerm)triple.getPredicate()), JenaCommonsRDF.toJena(triple.getObject()));
    }

    public static org.apache.jena.sparql.core.Quad toJena(Quad quad) {
        if (quad instanceof JenaTriple) {
            return ((JenaQuad)quad).getQuad();
        }
        return new org.apache.jena.sparql.core.Quad(JenaCommonsRDF.toJena(quad.getGraphName()), JenaCommonsRDF.toJena((RDFTerm)quad.getSubject()), JenaCommonsRDF.toJena((RDFTerm)quad.getPredicate()), JenaCommonsRDF.toJena(quad.getObject()));
    }

    public static Node toJena(Optional<BlankNodeOrIRI> graphName) {
        if (!graphName.isPresent()) {
            return org.apache.jena.sparql.core.Quad.defaultGraphNodeGenerated;
        }
        return JenaCommonsRDF.toJena((RDFTerm)graphName.get());
    }

    public static Node toJenaAny(RDFTerm term) {
        if (term == null) {
            return Node.ANY;
        }
        return JenaCommonsRDF.toJena(term);
    }

    public static Node toJenaAny(Optional<BlankNodeOrIRI> term) {
        if (term == null) {
            return Node.ANY;
        }
        return JenaCommonsRDF.toJena(term);
    }

    public static Graph toJena(org.apache.commons.rdf.api.Graph graph) {
        if (graph instanceof JenaGraph) {
            return ((JenaGraph)graph).getGraph();
        }
        Graph g = GraphFactory.createGraphMem();
        graph.stream().forEach(t -> g.add(JenaCommonsRDF.toJena(t)));
        return g;
    }

    public static DatasetGraph toJena(Dataset dataset) {
        if (dataset instanceof JenaDataset) {
            return ((JenaDataset)dataset).getDataset();
        }
        DatasetGraph d = DatasetGraphFactory.createTxnMem();
        dataset.stream().forEach(q -> d.add(JenaCommonsRDF.toJena(q)));
        return d;
    }

    public static Optional<Lang> toJena(RDFSyntax syntax) {
        return Optional.ofNullable(RDFLanguages.contentTypeToLang((String)syntax.mediaType()));
    }

    public static Optional<RDFSyntax> fromJena(Lang lang) {
        return RDFSyntax.byMediaType((String)lang.getContentType().getContentTypeStr());
    }

    public static RDFTerm fromJena(Node node) {
        return JCR_Factory.fromJena(node);
    }

    public static org.apache.commons.rdf.api.Triple fromJena(Triple triple) {
        return JCR_Factory.fromJena(triple);
    }

    public static Quad fromJena(org.apache.jena.sparql.core.Quad quad) {
        return JCR_Factory.fromJena(quad);
    }

    public static org.apache.commons.rdf.api.Graph fromJena(Graph graph) {
        return JCR_Factory.fromJena(graph);
    }

    public static Dataset fromJena(DatasetGraph datasetGraph) {
        return JCR_Factory.fromJena(datasetGraph);
    }

    public static RDFTerm fromJena(RDF factory, Node node) {
        if (node.isURI()) {
            return factory.createIRI(node.getURI());
        }
        if (node.isLiteral()) {
            String lang = node.getLiteralLanguage();
            if (lang != null && !lang.isEmpty()) {
                return factory.createLiteral(node.getLiteralLexicalForm(), lang);
            }
            if (node.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
                return factory.createLiteral(node.getLiteralLexicalForm());
            }
            IRI dt = factory.createIRI(node.getLiteralDatatype().getURI());
            return factory.createLiteral(node.getLiteralLexicalForm(), dt);
        }
        if (node.isBlank()) {
            return factory.createBlankNode(node.getBlankNodeLabel());
        }
        throw new ConversionException("Node is not a concrete RDF Term: " + node);
    }

    public static org.apache.commons.rdf.api.Triple fromJena(RDF factory, Triple triple) {
        BlankNodeOrIRI subject = (BlankNodeOrIRI)JenaCommonsRDF.fromJena(factory, triple.getSubject());
        IRI predicate = (IRI)JenaCommonsRDF.fromJena(factory, triple.getPredicate());
        RDFTerm object = JenaCommonsRDF.fromJena(factory, triple.getObject());
        return factory.createTriple(subject, predicate, object);
    }

    public static Quad fromJena(RDF factory, org.apache.jena.sparql.core.Quad quad) {
        BlankNodeOrIRI graph = (BlankNodeOrIRI)JenaCommonsRDF.fromJena(factory, quad.getGraph());
        BlankNodeOrIRI subject = (BlankNodeOrIRI)JenaCommonsRDF.fromJena(factory, quad.getSubject());
        IRI predicate = (IRI)JenaCommonsRDF.fromJena(factory, quad.getPredicate());
        RDFTerm object = JenaCommonsRDF.fromJena(factory, quad.getObject());
        return factory.createQuad(graph, subject, predicate, object);
    }

    public static org.apache.commons.rdf.api.Graph fromJena(RDF factory, Graph graph) {
        org.apache.commons.rdf.api.Graph g = factory.createGraph();
        graph.find(Node.ANY, Node.ANY, Node.ANY).forEachRemaining(t -> g.add(JenaCommonsRDF.fromJena(factory, t)));
        return g;
    }

    public static StreamRDF streamJenaToCommonsRDF(RDF rft, org.apache.commons.rdf.api.Graph graph) {
        return new ToGraph(rft, graph);
    }

    public static StreamRDF streamJenaToCommonsRDF(RDF rft, Dataset dataset) {
        return new ToDataset(rft, dataset);
    }

    public static void conversionError(String msg) {
        throw new ConversionException(msg);
    }

    static {
        JenaSystem.init();
    }
}

