/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf.impl;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.commonsrdf.impl.JenaGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.iterator.ExtendedIterator;

public class JCR_Graph
implements org.apache.commons.rdf.api.Graph,
JenaGraph {
    private Graph graph;

    JCR_Graph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public void add(Triple triple) {
        this.graph.add(JenaCommonsRDF.toJena(triple));
    }

    public void add(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.graph.add(org.apache.jena.graph.Triple.create((Node)JenaCommonsRDF.toJena((RDFTerm)subject), (Node)JenaCommonsRDF.toJena((RDFTerm)predicate), (Node)JenaCommonsRDF.toJena(object)));
    }

    public boolean contains(Triple triple) {
        return this.graph.contains(JenaCommonsRDF.toJena(triple));
    }

    public boolean contains(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.graph.contains(JenaCommonsRDF.toJena((RDFTerm)subject), JenaCommonsRDF.toJena((RDFTerm)predicate), JenaCommonsRDF.toJena(object));
    }

    public void remove(Triple triple) {
        this.graph.delete(JenaCommonsRDF.toJena(triple));
    }

    public void remove(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.graph.remove(JenaCommonsRDF.toJena((RDFTerm)subject), JenaCommonsRDF.toJena((RDFTerm)predicate), JenaCommonsRDF.toJena(object));
    }

    public void clear() {
        this.graph.clear();
    }

    public long size() {
        return this.graph.size();
    }

    public Stream<? extends Triple> getTriples() {
        return this.getTriples(null, null, null);
    }

    public Stream<? extends Triple> getTriples(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        ExtendedIterator iter = this.graph.find(JenaCommonsRDF.toJenaAny((RDFTerm)subject), JenaCommonsRDF.toJenaAny((RDFTerm)predicate), JenaCommonsRDF.toJenaAny(object));
        Iterator iter2 = Iter.map((Iterator)iter, t -> JenaCommonsRDF.fromJena(t));
        return Iter.asStream((Iterator)iter2);
    }

    public Stream<? extends Triple> stream() {
        return this.getTriples();
    }

    public Stream<? extends Triple> stream(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.getTriples(subject, predicate, object);
    }

    public void close() {
        this.graph.close();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Graph)this.graph, (Lang)Lang.NT);
        return sw.toString();
    }
}

