/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf.impl;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.jena.commonsrdf.impl.JCR_Factory;
import org.apache.jena.commonsrdf.impl.JCR_Term;
import org.apache.jena.graph.Node;

public class JCR_Literal
extends JCR_Term
implements Literal {
    JCR_Literal(Node node) {
        super(node);
    }

    public String getLexicalForm() {
        return this.getNode().getLiteralLexicalForm();
    }

    public IRI getDatatype() {
        return JCR_Factory.createIRI(this.getNode().getLiteralDatatype().getURI());
    }

    public Optional<String> getLanguageTag() {
        String x = this.getNode().getLiteralLanguage();
        if (x == null || x.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(x);
    }

    public int hashCode() {
        return Objects.hash(this.getLexicalForm(), this.getDatatype(), this.getLanguageTag());
    }

    private static boolean equalsIgnoreCase(Optional<String> s1, Optional<String> s2) {
        if (Objects.equals(s1, s2)) {
            return true;
        }
        if (!s1.isPresent() || !s2.isPresent()) {
            return false;
        }
        return s1.get().equalsIgnoreCase(s2.get());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Literal)) {
            return false;
        }
        Literal literal = (Literal)other;
        return this.getLexicalForm().equals(literal.getLexicalForm()) && JCR_Literal.equalsIgnoreCase(this.getLanguageTag(), literal.getLanguageTag()) && this.getDatatype().equals((Object)literal.getDatatype());
    }
}

