/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf.impl;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.commonsrdf.impl.JCR_Factory;
import org.apache.jena.commonsrdf.impl.JenaQuad;
import org.apache.jena.graph.Node;

public class JCR_Quad
implements Quad,
JenaQuad {
    private final Optional<BlankNodeOrIRI> graphName;
    private final BlankNodeOrIRI subject;
    private final IRI predicate;
    private final RDFTerm object;
    private org.apache.jena.sparql.core.Quad quad = null;

    JCR_Quad(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.graphName = graphName;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    JCR_Quad(org.apache.jena.sparql.core.Quad quad) {
        Node gn = quad.getGraph();
        this.graphName = JCR_Quad.graphName(gn);
        this.subject = (BlankNodeOrIRI)JCR_Factory.fromJena(quad.getSubject());
        this.predicate = (IRI)JCR_Factory.fromJena(quad.getPredicate());
        this.object = JCR_Factory.fromJena(quad.getObject());
        this.quad = quad;
    }

    private static Optional<BlankNodeOrIRI> graphName(Node gn) {
        return gn == null || org.apache.jena.sparql.core.Quad.isDefaultGraph((Node)gn) ? Optional.empty() : Optional.of((BlankNodeOrIRI)JCR_Factory.fromJena(gn));
    }

    private static Node graphName(Optional<BlankNodeOrIRI> graphName) {
        if (!graphName.isPresent()) {
            return org.apache.jena.sparql.core.Quad.defaultGraphIRI;
        }
        return JenaCommonsRDF.toJena((RDFTerm)graphName.get());
    }

    @Override
    public org.apache.jena.sparql.core.Quad getQuad() {
        if (this.quad == null) {
            this.quad = org.apache.jena.sparql.core.Quad.create((Node)JCR_Quad.graphName(this.graphName), (Node)JenaCommonsRDF.toJena((RDFTerm)this.subject), (Node)JenaCommonsRDF.toJena((RDFTerm)this.predicate), (Node)JenaCommonsRDF.toJena(this.object));
        }
        return this.quad;
    }

    public Optional<BlankNodeOrIRI> getGraphName() {
        return this.graphName;
    }

    public BlankNodeOrIRI getSubject() {
        return this.subject;
    }

    public IRI getPredicate() {
        return this.predicate;
    }

    public RDFTerm getObject() {
        return this.object;
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Quad)) {
            return false;
        }
        Quad quad = (Quad)other;
        return this.getGraphName().equals(quad.getGraphName()) && this.getSubject().equals(quad.getSubject()) && this.getPredicate().equals((Object)quad.getPredicate()) && this.getObject().equals((Object)quad.getObject());
    }

    public String toString() {
        return this.getGraphName() + " " + this.getSubject() + " " + this.getPredicate() + " " + this.getObject() + " .";
    }
}

