/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf.impl;

import java.util.Objects;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.commonsrdf.impl.JCR_Factory;
import org.apache.jena.commonsrdf.impl.JenaTriple;
import org.apache.jena.graph.Node;

public class JCR_Triple
implements Triple,
JenaTriple {
    private final BlankNodeOrIRI subject;
    private final IRI predicate;
    private final RDFTerm object;
    private org.apache.jena.graph.Triple triple = null;

    JCR_Triple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    JCR_Triple(org.apache.jena.graph.Triple triple) {
        this.subject = (BlankNodeOrIRI)JCR_Factory.fromJena(triple.getSubject());
        this.predicate = (IRI)JCR_Factory.fromJena(triple.getPredicate());
        this.object = JCR_Factory.fromJena(triple.getObject());
        this.triple = triple;
    }

    @Override
    public org.apache.jena.graph.Triple getTriple() {
        if (this.triple == null) {
            this.triple = org.apache.jena.graph.Triple.create((Node)JenaCommonsRDF.toJena((RDFTerm)this.subject), (Node)JenaCommonsRDF.toJena((RDFTerm)this.predicate), (Node)JenaCommonsRDF.toJena(this.object));
        }
        return this.triple;
    }

    public BlankNodeOrIRI getSubject() {
        return this.subject;
    }

    public IRI getPredicate() {
        return this.predicate;
    }

    public RDFTerm getObject() {
        return this.object;
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Triple)) {
            return false;
        }
        Triple triple = (Triple)other;
        return this.getSubject().equals(triple.getSubject()) && this.getPredicate().equals((Object)triple.getPredicate()) && this.getObject().equals((Object)triple.getObject());
    }

    public String toString() {
        return this.getSubject() + " " + this.getPredicate() + " " + this.getObject() + " .";
    }
}

