/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf.impl;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.commonsrdf.impl.JCR_BlankNode;
import org.apache.jena.commonsrdf.impl.JCR_IRI;
import org.apache.jena.commonsrdf.impl.JenaDataset;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;

public class JCR_Dataset
implements Dataset,
JenaDataset {
    private DatasetGraph dataset;

    JCR_Dataset(DatasetGraph datasetGraph) {
        this.dataset = datasetGraph;
    }

    @Override
    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public void add(Quad quad) {
        this.dataset.add(JenaCommonsRDF.toJena(quad));
    }

    public void add(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        if (graphName == null) {
            this.dataset.add(org.apache.jena.sparql.core.Quad.defaultGraphNodeGenerated, JenaCommonsRDF.toJena((RDFTerm)subject), JenaCommonsRDF.toJena((RDFTerm)predicate), JenaCommonsRDF.toJena(object));
        } else {
            this.dataset.add(JenaCommonsRDF.toJena((RDFTerm)graphName), JenaCommonsRDF.toJena((RDFTerm)subject), JenaCommonsRDF.toJena((RDFTerm)predicate), JenaCommonsRDF.toJena(object));
        }
    }

    public boolean contains(Quad quad) {
        return this.dataset.contains(JenaCommonsRDF.toJena(quad));
    }

    public boolean contains(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.dataset.contains(JenaCommonsRDF.toJenaAny(graphName), JenaCommonsRDF.toJenaAny((RDFTerm)subject), JenaCommonsRDF.toJenaAny((RDFTerm)predicate), JenaCommonsRDF.toJenaAny(object));
    }

    public org.apache.commons.rdf.api.Graph getGraph() {
        Graph graph = this.dataset.getDefaultGraph();
        return JenaCommonsRDF.fromJena(graph);
    }

    public Optional<org.apache.commons.rdf.api.Graph> getGraph(BlankNodeOrIRI graphName) {
        if (graphName == null) {
            return Optional.of(JenaCommonsRDF.fromJena(this.dataset.getDefaultGraph()));
        }
        Node node = JenaCommonsRDF.toJena((RDFTerm)graphName);
        Graph graph = this.dataset.getGraph(node);
        if (graph == null) {
            return Optional.empty();
        }
        return Optional.of(JenaCommonsRDF.fromJena(graph));
    }

    public Stream<BlankNodeOrIRI> getGraphNames() {
        Iterator iter = this.dataset.listGraphNodes();
        Function<Node, BlankNodeOrIRI> mapper = n -> n.isBlank() ? new JCR_BlankNode((Node)n) : new JCR_IRI((Node)n);
        return Iter.asStream((Iterator)iter).map(mapper);
    }

    public void remove(Quad quad) {
        this.dataset.delete(JenaCommonsRDF.toJena(quad));
    }

    public void remove(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.dataset.deleteAny(JenaCommonsRDF.toJenaAny(graphName), JenaCommonsRDF.toJenaAny((RDFTerm)subject), JenaCommonsRDF.toJenaAny((RDFTerm)predicate), JenaCommonsRDF.toJenaAny(object));
    }

    public void clear() {
        this.dataset.clear();
    }

    public long size() {
        return Iter.count((Iterator)this.dataset.find());
    }

    public Stream<? extends Quad> stream() {
        return Iter.asStream((Iterator)this.dataset.find()).map(q -> JenaCommonsRDF.fromJena(q));
    }

    public Stream<? extends Quad> stream(Optional<BlankNodeOrIRI> graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return Iter.asStream((Iterator)this.dataset.find(JenaCommonsRDF.toJenaAny(graphName), JenaCommonsRDF.toJena((RDFTerm)subject), JenaCommonsRDF.toJena((RDFTerm)predicate), JenaCommonsRDF.toJena(object))).map(q -> JenaCommonsRDF.fromJena(q));
    }

    private Node ny(RDFTerm term) {
        if (term == null) {
            return Node.ANY;
        }
        return JenaCommonsRDF.toJena(term);
    }
}

