/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf.impl;

import java.util.Optional;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.jena.commonsrdf.JenaCommonsRDF;
import org.apache.jena.commonsrdf.impl.JCR_BlankNode;
import org.apache.jena.commonsrdf.impl.JCR_Dataset;
import org.apache.jena.commonsrdf.impl.JCR_Graph;
import org.apache.jena.commonsrdf.impl.JCR_IRI;
import org.apache.jena.commonsrdf.impl.JCR_Literal;
import org.apache.jena.commonsrdf.impl.JCR_Quad;
import org.apache.jena.commonsrdf.impl.JCR_Triple;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.web.LangTag;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;

public class JCR_Factory {
    public static IRI createIRI(String iriStr) {
        return (IRI)JenaCommonsRDF.fromJena(NodeFactory.createURI((String)iriStr));
    }

    public static Literal createLiteral(String lexStr) {
        return new JCR_Literal(NodeFactory.createLiteralString((String)lexStr));
    }

    public static Literal createLiteralDT(String lexStr, String datatypeIRI) {
        return new JCR_Literal(NodeFactory.createLiteralDT((String)lexStr, (RDFDatatype)NodeFactory.getType((String)datatypeIRI)));
    }

    public static Literal createLiteralLang(String lexStr, String langTag) {
        langTag = LangTag.canonical((String)langTag);
        return new JCR_Literal(NodeFactory.createLiteralLang((String)lexStr, (String)langTag));
    }

    public static BlankNode createBlankNode() {
        return new JCR_BlankNode(NodeFactory.createBlankNode());
    }

    public static BlankNode createBlankNode(String id) {
        return new JCR_BlankNode(NodeFactory.createBlankNode((String)id));
    }

    public static org.apache.commons.rdf.api.Graph createGraph() {
        return new JCR_Graph(GraphFactory.createDefaultGraph());
    }

    public static Dataset createDataset() {
        return new JCR_Dataset(DatasetGraphFactory.create());
    }

    public static org.apache.commons.rdf.api.Triple createTriple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return new JCR_Triple(subject, predicate, object);
    }

    public static Quad createQuad(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        Optional<BlankNodeOrIRI> gn = graphName == null ? Optional.empty() : Optional.of(graphName);
        return new JCR_Quad(gn, subject, predicate, object);
    }

    public static org.apache.commons.rdf.api.Triple fromJena(Triple triple) {
        return new JCR_Triple(triple);
    }

    public static Quad fromJena(org.apache.jena.sparql.core.Quad quad) {
        return new JCR_Quad(quad);
    }

    public static org.apache.commons.rdf.api.Graph fromJena(Graph graph) {
        return new JCR_Graph(graph);
    }

    public static Dataset fromJena(DatasetGraph datasetGraph) {
        return new JCR_Dataset(datasetGraph);
    }

    public static RDFTerm fromJena(Node node) {
        if (node.isURI()) {
            return new JCR_IRI(node);
        }
        if (node.isLiteral()) {
            return new JCR_Literal(node);
        }
        if (node.isBlank()) {
            return new JCR_BlankNode(node);
        }
        JenaCommonsRDF.conversionError("Node is not a concrete RDF Term: " + node);
        return null;
    }
}

