/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.commonsrdf;

import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.jena.commonsrdf.impl.JCR_Factory;
import org.apache.jena.sys.JenaSystem;

public class JenaRDF
implements RDF {
    public BlankNode createBlankNode() {
        return JCR_Factory.createBlankNode();
    }

    public BlankNode createBlankNode(String name) {
        return JCR_Factory.createBlankNode(name);
    }

    public Graph createGraph() {
        return JCR_Factory.createGraph();
    }

    public Dataset createDataset() {
        return JCR_Factory.createDataset();
    }

    public IRI createIRI(String iri) {
        JenaRDF.validateIRI(iri);
        return JCR_Factory.createIRI(iri);
    }

    private static void validateIRI(String iri) {
        if (iri.contains(" ")) {
            throw new IllegalArgumentException();
        }
        if (iri.contains("<")) {
            throw new IllegalArgumentException();
        }
        if (iri.contains(">")) {
            throw new IllegalArgumentException();
        }
    }

    public Literal createLiteral(String lexicalForm) {
        return JCR_Factory.createLiteral(lexicalForm);
    }

    public Literal createLiteral(String lexicalForm, IRI dataType) {
        return JCR_Factory.createLiteralDT(lexicalForm, dataType.getIRIString());
    }

    public Literal createLiteral(String lexicalForm, String languageTag) {
        JenaRDF.validateLang(languageTag);
        return JCR_Factory.createLiteralLang(lexicalForm, languageTag);
    }

    private static void validateLang(String languageTag) {
        if (languageTag.contains(" ")) {
            throw new IllegalArgumentException();
        }
    }

    public Triple createTriple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return JCR_Factory.createTriple(subject, predicate, object);
    }

    public Quad createQuad(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) throws IllegalArgumentException {
        return JCR_Factory.createQuad(graphName, subject, predicate, object);
    }

    static {
        JenaSystem.init();
    }
}

