/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.page;

import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.block.BlockType;
import org.apache.jena.dboe.base.page.BlockConverter;
import org.apache.jena.dboe.base.page.Page;

public class PageBlockMgr<T extends Page>
implements Closeable {
    protected final BlockMgr blockMgr;
    protected BlockConverter<T> pageFactory;

    protected PageBlockMgr(BlockConverter<T> pageFactory, BlockMgr blockMgr) {
        this.pageFactory = pageFactory;
        this.blockMgr = blockMgr;
    }

    protected void setConverter(BlockConverter<T> pageFactory) {
        this.pageFactory = pageFactory;
    }

    public BlockMgr getBlockMgr() {
        return this.blockMgr;
    }

    public long allocLimit() {
        return this.blockMgr.allocLimit();
    }

    public void resetAlloc(long boundary) {
        this.blockMgr.resetAlloc(boundary);
    }

    public T create(BlockType bType) {
        Block block = this.blockMgr.allocate(-1);
        block.setModified(true);
        T page = this.pageFactory.createFromBlock(block, bType);
        return page;
    }

    public T getRead(int id) {
        return this.getRead$(id);
    }

    public T getRead(int id, int referencingId) {
        return this.getRead$(id);
    }

    public T getWrite(int id) {
        return this.getWrite$(id);
    }

    public T getWrite(int id, int referencingId) {
        return this.getWrite$(id);
    }

    protected final T getRead$(int id) {
        Block block = this.blockMgr.getRead(id);
        T page = this.pageFactory.fromBlock(block);
        return page;
    }

    protected final T getWrite$(int id) {
        Block block = this.blockMgr.getWrite(id);
        block.setReadOnly(false);
        T page = this.pageFactory.fromBlock(block);
        return page;
    }

    public void put(T page) {
        this.write(page);
        this.release((Page)page);
    }

    public void write(T page) {
        Block blk = this.pageFactory.toBlock(page);
        this.blockMgr.write(blk);
    }

    public void release(Page page) {
        Block block = page.getBackingBlock();
        this.blockMgr.release(block);
    }

    private void warn(String string) {
        Log.warn((Object)this, (String)string);
    }

    public void free(Page page) {
        Block block = page.getBackingBlock();
        this.blockMgr.free(block);
    }

    public void promoteInPlace(Page page) {
        Block block = page.getBackingBlock();
        block.getByteBuffer().rewind();
        Block block2 = this.blockMgr.promote(block);
        block2.setReadOnly(false);
        if (block2.getId() != block.getId()) {
            throw new InternalErrorException("Block id changed");
        }
        if (block2 == block) {
            return;
        }
    }

    public boolean promoteDuplicate(Page page) {
        Block block = page.getBackingBlock();
        block.getByteBuffer().rewind();
        Block block2 = this.blockMgr.allocate(-1);
        block2.getByteBuffer().put(block.getByteBuffer());
        block2.getByteBuffer().rewind();
        block2.setReadOnly(false);
        if (block2 == block) {
            return false;
        }
        page.reset(block2);
        return true;
    }

    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    public void dump() {
        int idx = 0;
        while (this.valid(idx)) {
            T page = this.getRead(idx, -1);
            System.out.println(page);
            this.release((Page)page);
            ++idx;
        }
    }

    public void startUpdate() {
        this.blockMgr.beginUpdate();
    }

    public void finishUpdate() {
        this.blockMgr.endUpdate();
    }

    public void startRead() {
        this.blockMgr.beginRead();
    }

    public void finishRead() {
        this.blockMgr.endRead();
    }

    public void close() {
        this.blockMgr.close();
    }
}

