/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.dboe.storage.prefixes.PrefixEntry;
import org.apache.jena.dboe.storage.prefixes.PrefixLib;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;

public class PrefixMapIOverStorage
implements PrefixMapI {
    private final StoragePrefixMap prefixes;

    protected StoragePrefixMap spm() {
        return this.prefixes;
    }

    public PrefixMapIOverStorage(StoragePrefixMap storage) {
        this.prefixes = storage;
    }

    @Override
    public Map<String, String> getMapping() {
        return this.getMappingCopy();
    }

    @Override
    public Map<String, String> getMappingCopy() {
        return this.spm().stream().collect(Collectors.toMap(e -> e.getPrefix(), e -> e.getUri()));
    }

    @Override
    public StoragePrefixMap getPrefixMapStorage() {
        return this.prefixes;
    }

    @Override
    public void add(String prefix, String iriString) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.spm().put(prefix, iriString);
    }

    @Override
    public void delete(String prefix) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.spm().remove(prefix);
    }

    @Override
    public Stream<PrefixEntry> stream() {
        return this.spm().stream();
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        this.spm().forEach((? super T entry) -> action.accept(entry.getPrefix(), entry.getUri()));
    }

    @Override
    public void clear() {
        this.spm().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.spm().isEmpty();
    }

    @Override
    public int size() {
        return this.spm().size();
    }

    @Override
    public String get(String prefix) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        return this.spm().get(prefix);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        prefix = PrefixLib.canonicalPrefix(prefix);
        return this.spm().containsPrefix(prefix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (PrefixEntry e : this.prefixes) {
            if (first) {
                first = false;
            } else {
                sb.append(" ,");
            }
            sb.append(e.getPrefix());
            sb.append(":=");
            sb.append(e.getUri());
        }
        sb.append(" }");
        return sb.toString();
    }
}

