/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateMgrBase
implements Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(StateMgrBase.class);
    private final BufferChannel storage;
    private ByteBuffer bb;
    private boolean dirty = false;

    protected StateMgrBase(BufferChannel storage, int sizeBytes) {
        this.bb = ByteBuffer.allocate(sizeBytes);
        this.storage = storage;
    }

    protected void init() {
        if (!this.storage.isEmpty()) {
            this.readState();
        } else {
            this.writeState();
        }
    }

    protected abstract ByteBuffer serialize(ByteBuffer var1);

    protected abstract void deserialize(ByteBuffer var1);

    protected void setDirtyFlag() {
        this.dirty = true;
    }

    protected abstract void writeStateEvent();

    protected abstract void readStateEvent();

    protected void clearDirtyFlag() {
        this.dirty = false;
    }

    public BufferChannel getBufferChannel() {
        return this.storage;
    }

    public ByteBuffer getState() {
        this.bb.rewind();
        this.serialize(this.bb);
        return this.bb;
    }

    public void setState(ByteBuffer buff) {
        buff.rewind();
        this.deserialize(buff);
        this.dirty = true;
    }

    public void writeState() {
        this.bb.rewind();
        ByteBuffer bb1 = this.serialize(this.bb);
        if (bb1 != null) {
            this.bb = bb1;
        }
        this.bb.rewind();
        int len = this.storage.write(this.bb, 0L);
        this.storage.sync();
        this.dirty = false;
        this.writeStateEvent();
    }

    public void readState() {
        this.bb.rewind();
        int len = this.storage.read(this.bb, 0L);
        this.bb.rewind();
        this.deserialize(this.bb);
        this.readStateEvent();
    }

    public void sync() {
        if (this.dirty) {
            this.writeState();
        }
    }

    public void close() {
        this.storage.close();
    }
}

