/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.io.InputStream;
import java.util.function.Function;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.sparql.core.DatasetGraph;

public final class AccessCtl_SPARQL_Update
extends SPARQL_Update {
    private final Function<HttpAction, String> requestUser;

    public AccessCtl_SPARQL_Update(Function<HttpAction, String> requestUser) {
        this.requestUser = requestUser;
    }

    protected void validate(HttpAction action) {
        super.validate(action);
        DatasetGraph dsg = action.getDataset();
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            return;
        }
        ServletOps.errorBadRequest((String)"SPARQL Update not supported");
    }

    protected void perform(HttpAction action) {
        DatasetGraph dsg = action.getDataset();
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            super.perform(action);
            return;
        }
        ServletOps.errorBadRequest((String)"SPARQL Update not supported");
    }

    protected void execute(HttpAction action, InputStream input) {
        DatasetGraph dsg = action.getDataset();
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            super.execute(action, input);
            return;
        }
        ServletOps.errorBadRequest((String)"SPARQL Update not supported");
    }
}

