/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.fuseki.access.AuthorizationService;
import org.apache.jena.fuseki.access.DatasetGraphAccessControl;
import org.apache.jena.fuseki.access.VocabSecurity;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class AssemblerAccessDataset
extends AssemblerBase {
    public Dataset open(Assembler a, Resource root, Mode mode) {
        if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabSecurity.pSecurityRegistry)) {
            throw new AssemblerException(root, "Expected exactly one access:registry property");
        }
        if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabSecurity.pDataset)) {
            throw new AssemblerException(root, "Expected exactly one access:dataset property");
        }
        RDFNode rnRegistry = root.getProperty(VocabSecurity.pSecurityRegistry).getObject();
        RDFNode rnDataset = root.getProperty(VocabSecurity.pDataset).getObject();
        AuthorizationService sr = (AuthorizationService)a.open(rnRegistry.asResource());
        DatasetGraph dsgBase = ((Dataset)a.open(rnDataset.asResource())).asDatasetGraph();
        DatasetGraphAccessControl dsg = new DatasetGraphAccessControl(dsgBase, sr);
        return DatasetFactory.wrap((DatasetGraph)dsg);
    }
}

