/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.function.Function;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.sparql.core.DatasetGraph;

public class AccessCtl_DenyUpdate
extends ActionService {
    private final ActionService other;
    private final Function<HttpAction, String> requestUser;
    private final String label;

    public AccessCtl_DenyUpdate(ActionService other, String label, Function<HttpAction, String> determineUser) {
        this.other = other;
        this.label = label;
        this.requestUser = determineUser;
    }

    public void validate(HttpAction action) {
        DatasetGraph dsg = action.getDataset();
        if (DataAccessCtl.isAccessControlled(dsg)) {
            if (this.label == null) {
                ServletOps.errorBadRequest((String)"Not supported");
            }
            ServletOps.errorBadRequest((String)(this.label + " : not supported"));
            throw new InternalErrorException("AccessCtl_DenyUpdate: didn't reject request");
        }
        this.other.validate(action);
    }

    public void execute(HttpAction action) {
        this.other.execute(action);
    }
}

