/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.access.DataAccessLib;
import org.apache.jena.fuseki.access.SecurityContext;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Quad;

public final class AccessCtl_SPARQL_QueryDataset
extends SPARQL_QueryDataset {
    private final Function<HttpAction, String> requestUser;
    private static boolean ALLOW_FROM = true;

    public AccessCtl_SPARQL_QueryDataset(Function<HttpAction, String> requestUser) {
        this.requestUser = requestUser;
    }

    protected Collection<String> customParams() {
        return Collections.singletonList("user");
    }

    protected Pair<DatasetGraph, Query> decideDataset(HttpAction action, Query query, String queryStringLog) {
        DatasetGraph dsg = action.getActiveDSG();
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            return super.decideDataset(action, query, queryStringLog);
        }
        DatasetDescription dsDesc0 = SPARQLProtocol.getDatasetDescription((HttpAction)action, (Query)query);
        SecurityContext sCxt = DataAccessLib.getSecurityContext(action, dsg, this.requestUser);
        DatasetGraph dsg2 = this.dynamicDataset(action, query, dsg, dsDesc0, sCxt);
        return Pair.create((Object)dsg2, (Object)query);
    }

    private DatasetGraph dynamicDataset(HttpAction action, Query query, DatasetGraph dsg0, DatasetDescription dsDesc0, SecurityContext sCxt) {
        DatasetDescription dsDesc1;
        if (dsDesc0 == null) {
            return dsg0;
        }
        if (!ALLOW_FROM) {
            ServletOps.errorBadRequest((String)"Use GRAPH. (FROM/FROM NAMED is not compatible with data access control.)");
        }
        if ((dsDesc1 = DatasetDescription.create(this.mask(dsDesc0.getDefaultGraphURIs(), sCxt), this.mask(dsDesc0.getNamedGraphURIs(), sCxt))).isEmpty()) {
            return DatasetGraphZero.create();
        }
        if (dsDesc1.getDefaultGraphURIs().contains(Quad.unionGraph.getURI())) {
            dsDesc1.getDefaultGraphURIs().remove(Quad.unionGraph.getURI());
            dsDesc1.getDefaultGraphURIs().addAll(sCxt.visibleGraphNames());
        }
        DatasetGraph dsg1 = DynamicDatasets.dynamicDataset((DatasetDescription)dsDesc1, (DatasetGraph)dsg0, (boolean)false);
        if (query.hasDatasetDescription()) {
            query.getGraphURIs().clear();
            query.getNamedGraphURIs().clear();
        }
        return dsg1;
    }

    private List<String> mask(List<String> graphURIs, SecurityContext sCxt) {
        Collection<String> names = sCxt.visibleGraphNames();
        if (names == null) {
            return graphURIs;
        }
        return graphURIs.stream().filter(gn -> names.contains(gn) || sCxt.visableDefaultGraph() && Quad.defaultGraphIRI.getURI().equals(gn) || Quad.unionGraph.getURI().equals(gn)).collect(Collectors.toList());
    }

    protected QueryExecution createQueryExecution(HttpAction action, Query query, DatasetGraph target) {
        DatasetGraph dsg;
        if (!ALLOW_FROM && target instanceof DynamicDatasets.DynamicDatasetGraph) {
            ServletOps.errorBadRequest((String)"FROM/FROM NAMED is not compatible with data access control.");
        }
        if ((dsg = action.getActiveDSG()) == null) {
            return super.createQueryExecution(action, query, target);
        }
        if (!DataAccessCtl.isAccessControlled(dsg)) {
            return super.createQueryExecution(action, query, target);
        }
        SecurityContext sCxt = DataAccessLib.getSecurityContext(action, dsg, this.requestUser);
        QueryExecution qExec = sCxt.createQueryExecution(query, target);
        return qExec;
    }
}

