/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.fuseki.access.AuthorizationService;
import org.apache.jena.fuseki.access.SecurityContext;
import org.apache.jena.fuseki.access.SecurityContextView;
import org.apache.jena.fuseki.access.SecurityRegistry;
import org.apache.jena.fuseki.access.VocabSecurity;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class AssemblerSecurityRegistry
extends AssemblerBase {
    private static final boolean SKIP_ALLGRAPH = true;

    public AuthorizationService open(Assembler a, Resource root, Mode mode) {
        SecurityRegistry registry = new SecurityRegistry();
        StmtIterator sIter = root.listProperties(VocabSecurity.pEntry);
        if (!sIter.hasNext()) {
            throw new AssemblerException(root, "No access entries");
        }
        ArrayListMultimap map = ArrayListMultimap.create();
        sIter.forEachRemaining(arg_0 -> this.lambda$open$0(root, (Multimap)map, arg_0));
        map.keySet().forEach(arg_0 -> AssemblerSecurityRegistry.lambda$open$1((Multimap)map, registry, arg_0));
        return registry;
    }

    private void parseList(Multimap<String, Node> map, Resource root, GNode entry) {
        List members = GraphList.members((GNode)entry);
        if (members.isEmpty()) {
            throw new AssemblerException(root, "Found access:entry with an empty list");
        }
        Node userNode = (Node)members.get(0);
        if (!Util.isSimpleString((Node)userNode)) {
            throw new AssemblerException(root, "User name is not a string: " + NodeFmtLib.str((Node)userNode));
        }
        String user = userNode.getLiteralLexicalForm();
        List<Node> graphs = members.subList(1, members.size());
        this.accessEntries(root, map, user, graphs);
    }

    private void parseStruct(Multimap<String, Node> map, Resource root, Resource r) {
        if (!GraphUtils.exactlyOneProperty((Resource)r, (Property)VocabSecurity.pUser)) {
            throw new AssemblerException(root, "Expected exactly one access:user property for " + r);
        }
        if (!GraphUtils.exactlyOneProperty((Resource)r, (Property)VocabSecurity.pGraphs)) {
            throw new AssemblerException(root, "Expected exactly one access:graphs property for " + r);
        }
        String user = GraphUtils.getStringValue((Resource)r, (Property)VocabSecurity.pUser);
        r.listProperties(VocabSecurity.pGraphs).mapWith(s -> s.getObject()).forEachRemaining(x -> {
            ArrayList<Node> graphs = new ArrayList<Node>();
            if (x.isURIResource()) {
                graphs.add(x.asNode());
            } else {
                RDFList list = (RDFList)x.as(RDFList.class);
                list.iterator().forEachRemaining(rn -> graphs.add(rn.asNode()));
            }
            this.accessEntries(root, map, user, graphs);
        });
    }

    private Node graphLabel(Node x, Resource root) {
        if (SecurityContext.allGraphsStr.equals((Object)x)) {
            x = SecurityContext.allGraphs;
        }
        if (SecurityContext.allNamedGraphsStr.equals((Object)x)) {
            x = SecurityContext.allNamedGraphs;
        }
        if (!x.isURI()) {
            throw new AssemblerException(root, "Not a graph name: " + x);
        }
        return x;
    }

    private void accessEntries(Resource root, Multimap<String, Node> map, String user, List<Node> _graphs) {
        Set<Node> graphs = _graphs.stream().map(n -> this.graphLabel((Node)n, root)).collect(Collectors.toSet());
        if (graphs.contains(SecurityContext.allGraphs)) {
            map.removeAll((Object)user);
            map.put((Object)user, (Object)SecurityContext.allGraphs);
            return;
        }
        if (graphs.contains(SecurityContext.allNamedGraphs)) {
            boolean dft = this.dftPresent(graphs);
            Node x = SecurityContext.allNamedGraphs;
            if (dft) {
                x = SecurityContext.allGraphs;
            }
            map.removeAll((Object)user);
            map.put((Object)user, (Object)x);
            return;
        }
        if (graphs.contains(SecurityContext.allGraphs)) {
            Log.warn((Object)((Object)this), (String)("Graph name '" + SecurityContext.allGraphsStr + "' not supported yet"));
            graphs.remove(SecurityContext.allGraphs);
        }
        if (graphs.contains(SecurityContext.allNamedGraphs)) {
            Log.warn((Object)((Object)this), (String)("Graph name '" + SecurityContext.allNamedGraphsStr + "' not supported yet"));
            graphs.remove(SecurityContext.allNamedGraphs);
        }
        map.putAll((Object)user, graphs);
    }

    private boolean dftPresent(Collection<Node> nodes) {
        return nodes.stream().anyMatch(n -> Quad.isDefaultGraph((Node)n));
    }

    private static /* synthetic */ void lambda$open$1(Multimap map, SecurityRegistry registry, String u) {
        SecurityContextView sCxt = new SecurityContextView(map.get((Object)u));
        registry.put(u, sCxt);
    }

    private /* synthetic */ void lambda$open$0(Resource root, Multimap map, Statement s) {
        RDFNode n = s.getObject();
        if (!n.isResource()) {
            throw new AssemblerException(root, "Found access:entry with non-resource");
        }
        Resource r = (Resource)n;
        GNode entry = new GNode(root.getModel().getGraph(), n.asNode());
        if (GraphList.isListNode((GNode)entry)) {
            this.parseList((Multimap<String, Node>)map, root, entry);
        } else if (r.hasProperty(VocabSecurity.pUser) || r.hasProperty(VocabSecurity.pGraphs)) {
            this.parseStruct((Multimap<String, Node>)map, root, r);
        } else {
            throw new AssemblerException(root, "Found access:entry but failed to parse the object: " + s.getSubject());
        }
    }
}

