/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.fuseki.access.AuthorizationService;
import org.apache.jena.fuseki.access.DatasetGraphAccessControl;
import org.apache.jena.fuseki.access.SecurityContext;
import org.apache.jena.fuseki.access.SecurityContextAllowAll;
import org.apache.jena.fuseki.access.SecurityContextAllowNone;
import org.apache.jena.fuseki.access.VocabSecurity;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFilteredView;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;

public class DataAccessCtl {
    public static final Symbol symAuthorizationService;
    public static final Function<HttpAction, String> requestUserServlet;
    public static final Function<HttpAction, String> paramUserServlet;

    private static void addAuthorizatonService(DatasetGraph dsg, AuthorizationService authService) {
        dsg.getContext().set(symAuthorizationService, (Object)authService);
    }

    public static Dataset controlledDataset(Dataset dsBase, AuthorizationService reg) {
        DatasetGraph dsg = DataAccessCtl.controlledDataset(dsBase.asDatasetGraph(), reg);
        return DatasetFactory.wrap((DatasetGraph)dsg);
    }

    public static DatasetGraph controlledDataset(DatasetGraph dsgBase, AuthorizationService reg) {
        if (dsgBase instanceof DatasetGraphAccessControl) {
            DatasetGraphAccessControl dsgx = (DatasetGraphAccessControl)dsgBase;
            if (reg == dsgx.getAuthService()) {
                return dsgx;
            }
            throw new IllegalArgumentException("DatasetGraph is already wrapped on a DatasetGraphAccessControl with a different AuthorizationService");
        }
        DatasetGraphAccessControl dsg1 = new DatasetGraphAccessControl(dsgBase, reg);
        return dsg1;
    }

    public static boolean isAccessControlled(DatasetGraph dsg) {
        if (dsg instanceof DatasetGraphAccessControl) {
            return true;
        }
        return dsg.getContext().isDefined(symAuthorizationService);
    }

    public static DatasetGraph filteredDataset(DatasetGraph dsg, SecurityContext sCxt) {
        if (sCxt instanceof SecurityContextAllowAll) {
            return dsg;
        }
        if (sCxt instanceof SecurityContextAllowNone) {
            return new DatasetGraphZero();
        }
        List names = sCxt.visibleGraphs();
        if (names == null) {
            names = Iter.toList((Iterator)dsg.listGraphNodes());
        }
        return new DatasetGraphFilteredView(dsg, sCxt.predicateQuad(), sCxt.visibleGraphs());
    }

    static {
        JenaSystem.init();
        symAuthorizationService = Symbol.create((String)(VocabSecurity.getURI() + "authService"));
        requestUserServlet = action -> action.getUser();
        paramUserServlet = action -> action.request.getParameter("user");
    }
}

