/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.fuseki.access.DatasetGraphAccessControl;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.tdb1.sys.SystemTDB;
import org.apache.jena.tdb2.sys.TDBInternal;

public abstract class GraphFilter<X>
implements Predicate<Tuple<X>> {
    private final Set<X> graphs;
    private final boolean matchDefaultGraph;

    protected GraphFilter(Collection<X> matches, boolean matchDefaultGraph) {
        this.graphs = new HashSet<X>(matches);
        this.matchDefaultGraph = matchDefaultGraph;
    }

    public static Symbol getContextKey(DatasetGraph dsg) {
        if (org.apache.jena.tdb1.sys.TDBInternal.isTDB1((DatasetGraph)(dsg = DatasetGraphAccessControl.removeWrapper(dsg)))) {
            return SystemTDB.symTupleFilter;
        }
        if (TDBInternal.isTDB2((DatasetGraph)dsg)) {
            return org.apache.jena.tdb2.sys.SystemTDB.symTupleFilter;
        }
        throw new IllegalArgumentException("Not a TDB database");
    }

    public abstract Symbol getContextKey();

    @Override
    public boolean test(Tuple<X> t) {
        if (t.len() == 3) {
            return this.matchDefaultGraph;
        }
        Object g = t.get(0);
        boolean b = this.perGraphTest(g);
        return b;
    }

    private boolean perGraphTest(X g) {
        return this.graphs.contains(g);
    }
}

