/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.fuseki.access.SecurityContextAllowAll;
import org.apache.jena.fuseki.access.SecurityContextAllowNone;
import org.apache.jena.fuseki.access.SecurityContextView;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.sys.TDBInternal;

public interface SecurityContext {
    public static final SecurityContext NONE = new SecurityContextAllowNone();
    public static final SecurityContext ALL = new SecurityContextAllowAll();
    public static final Node allGraphs = NodeFactory.createURI((String)"urn:jena:accessAllGraphs");
    public static final Node allNamedGraphs = NodeFactory.createURI((String)"urn:jena:accessAllNamedGraphs");
    public static final Node allNamedGraphsStr = NodeFactory.createLiteralString((String)"*");
    public static final Node allGraphsStr = NodeFactory.createLiteralString((String)"**");

    public static SecurityContext ALL_NG(DatasetGraph dsg) {
        List names = Iter.toList((Iterator)dsg.listGraphNodes());
        return new SecurityContextView(names);
    }

    public Collection<Node> visibleGraphs();

    default public Collection<String> visibleGraphNames() {
        if (this.visibleGraphs() == null) {
            return null;
        }
        return this.visibleGraphs().stream().filter(Node::isURI).map(Node::getURI).collect(Collectors.toList());
    }

    public boolean visableDefaultGraph();

    default public QueryExecution createQueryExecution(String queryString, DatasetGraph dsg) {
        return this.createQueryExecution(QueryFactory.create((String)queryString), dsg);
    }

    public QueryExecution createQueryExecution(Query var1, DatasetGraph var2);

    public Predicate<Quad> predicateQuad();

    default public void filterTDB(DatasetGraph dsg, QueryExecution qExec) {
        if (!org.apache.jena.tdb1.sys.TDBInternal.isTDB1((DatasetGraph)dsg) || !TDBInternal.isTDB2((DatasetGraph)dsg)) {
            throw new IllegalArgumentException("Not a TDB database");
        }
        throw new UnsupportedOperationException();
    }
}

