/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import java.util.Objects;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.FusekiConfigException;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;

public class JettySecurityLib {
    public static final AuthScheme dftAuthMode;
    public static AuthScheme authMode;

    public static SecurityHandler makeSecurityHandlerForPathspec(String pathSpec, String realm, UserStore userStore) {
        ConstraintSecurityHandler sh = JettySecurityLib.makeSecurityHandler(realm, userStore);
        JettySecurityLib.addPathConstraint(sh, pathSpec);
        return sh;
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore) {
        return JettySecurityLib.makeSecurityHandler(realm, userStore, "**", authMode);
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore, AuthScheme authMode) {
        return JettySecurityLib.makeSecurityHandler(realm, userStore, "**", authMode);
    }

    public static ConstraintSecurityHandler makeSecurityHandler(String realm, UserStore userStore, String role, AuthScheme authMode) {
        Objects.requireNonNull(userStore);
        Objects.requireNonNull(role);
        if (authMode == null) {
            authMode = dftAuthMode;
        }
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        DefaultIdentityService identService = new DefaultIdentityService();
        securityHandler.setIdentityService((IdentityService)identService);
        HashLoginService loginService = new HashLoginService(realm);
        loginService.setUserStore(userStore);
        loginService.setIdentityService((IdentityService)identService);
        securityHandler.setLoginService((LoginService)loginService);
        securityHandler.setAuthenticator((Authenticator)(authMode == AuthScheme.BASIC ? new BasicAuthenticator() : new DigestAuthenticator()));
        if (realm != null) {
            securityHandler.setRealmName(realm);
        }
        return securityHandler;
    }

    public static void addPathConstraint(ConstraintSecurityHandler securityHandler, String pathSpec) {
        JettySecurityLib.addPathConstraint(securityHandler, pathSpec, "**");
    }

    public static void addPathConstraint(ConstraintSecurityHandler securityHandler, String pathSpec, String role) {
        Objects.requireNonNull(securityHandler);
        Objects.requireNonNull(pathSpec);
        ConstraintMapping mapping = new ConstraintMapping();
        Constraint constraint = new Constraint();
        String[] roles = new String[]{role};
        constraint.setRoles(roles);
        constraint.setName(securityHandler.getAuthenticator().getAuthMethod());
        constraint.setAuthenticate(true);
        mapping.setConstraint(constraint);
        mapping.setPathSpec(pathSpec);
        securityHandler.addConstraintMapping(mapping);
    }

    public static UserStore makeUserStore(String passwordFile) {
        if (!FileOps.exists((String)passwordFile)) {
            throw new FusekiConfigException("No such file: " + passwordFile);
        }
        PropertyUserStore propertyUserStore = new PropertyUserStore();
        propertyUserStore.setConfig(passwordFile);
        propertyUserStore.setHotReload(true);
        try {
            propertyUserStore.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("UserStore", ex);
        }
        return propertyUserStore;
    }

    public static UserStore makeUserStore(String user, String password) {
        return JettySecurityLib.makeUserStore(user, password, "**");
    }

    public static UserStore makeUserStore(String user, String password, String role) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        Objects.requireNonNull(role);
        UserStore userStore = new UserStore();
        JettySecurityLib.addUser(userStore, user, password, role);
        try {
            userStore.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("UserStore", ex);
        }
        return userStore;
    }

    public static UserStore addUser(UserStore userStore, String user, String password) {
        return JettySecurityLib.addUser(userStore, user, password, "**");
    }

    public static UserStore addUser(UserStore userStore, String user, String password, String role) {
        String[] stringArray;
        if (role == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = role;
        }
        String[] roles = stringArray;
        Password cred = new Password(password);
        userStore.addUser(user, (Credential)cred, roles);
        return userStore;
    }

    static {
        authMode = dftAuthMode = AuthScheme.BASIC;
    }
}

