/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.http.auth.AuthHeader;
import org.slf4j.Logger;

public class AuthBearerFilter
implements Filter {
    private static Logger log = Fuseki.serverLog;
    private final Function<String, String> verifiedUser;
    private final boolean requireBearer;

    public AuthBearerFilter(Function<String, String> verifiedUser) {
        this(verifiedUser, BearerMode.REQUIRED);
    }

    public AuthBearerFilter(Function<String, String> verifiedUser, BearerMode bearerMode) {
        Objects.requireNonNull(bearerMode);
        Objects.requireNonNull(verifiedUser);
        this.verifiedUser = verifiedUser;
        this.requireBearer = bearerMode == BearerMode.REQUIRED;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String auth = this.getHttpAuthField(request);
            if (auth == null && this.requireBearer) {
                this.sendResponseNoAuthPresent(response);
                return;
            }
            if (auth == null && !this.requireBearer) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            AuthHeader authHeader = this.getAuthToken(request, auth);
            if (this.requireBearer && !AuthScheme.BEARER.equals((Object)authHeader.getAuthScheme())) {
                this.sendResponseBearerRequired(response);
                return;
            }
            switch (authHeader.getAuthScheme()) {
                case BEARER: {
                    break;
                }
                default: {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            String bearerToken = authHeader.getBearerToken();
            if (bearerToken == null) {
                log.warn("Not a legal bearer token: " + authHeader.getAuthArgs());
                response.sendError(400);
                return;
            }
            if (this.verifiedUser == null) {
                response.sendError(400);
                return;
            }
            String user = this.verifiedUser.apply(bearerToken);
            if (user == null) {
                response.sendError(403);
                return;
            }
            HttpServletRequestWithPrincipal chainRequest = new HttpServletRequestWithPrincipal(request, user);
            chain.doFilter((ServletRequest)chainRequest, servletResponse);
        }
        catch (Throwable ex) {
            log.info("Filter: unexpected exception: " + ex.getMessage(), ex);
            ServletOps.error((int)500);
            return;
        }
    }

    public void destroy() {
    }

    protected String getHttpAuthField(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    protected void sendResponseNoAuthPresent(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "Bearer");
        response.sendError(401);
    }

    protected void sendResponseBearerRequired(HttpServletResponse response) throws IOException {
        response.sendError(403);
    }

    protected AuthHeader getAuthToken(HttpServletRequest request, String authHeaderValue) {
        return AuthHeader.parseAuth((String)authHeaderValue);
    }

    public static enum BearerMode {
        REQUIRED,
        OPTIONAL;

    }

    private static class HttpServletRequestWithPrincipal
    extends HttpServletRequestWrapper {
        private final String username;

        HttpServletRequestWithPrincipal(HttpServletRequest req, String username) {
            super(req);
            this.username = username;
        }

        public String getRemoteUser() {
            return this.username;
        }

        public Principal getUserPrincipal() {
            return () -> this.username;
        }
    }
}

