/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.cmds;

import java.io.File;
import java.nio.file.Path;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.fuseki.main.cmds.ServerConfig;
import org.apache.jena.fuseki.system.spot.TDBOps;
import org.apache.jena.tdb.TDBFactory;
import org.apache.jena.tdb2.DatabaseMgr;

class DSGSetup {
    DSGSetup() {
    }

    static void setupTDB(String directory, boolean useTDB2, ServerConfig serverConfig) {
        File dir = Path.of(directory, new String[0]).toFile();
        if (!dir.exists()) {
            throw new CmdException("Directory does not exist: " + directory);
        }
        if (!dir.isDirectory()) {
            throw new CmdException("Not a directory: " + directory);
        }
        if (!dir.canRead()) {
            throw new CmdException("Directory not readable: " + directory);
        }
        if (!dir.canWrite()) {
            throw new CmdException("Directory not writeable: " + directory);
        }
        if (IO.isEmptyDirectory((String)directory)) {
            if (useTDB2) {
                DSGSetup.setupTDB2(directory, serverConfig);
            } else {
                DSGSetup.setupTDB1(directory, serverConfig);
            }
            return;
        }
        if (TDBOps.isTDB1((String)directory)) {
            DSGSetup.setupTDB1(directory, serverConfig);
            return;
        }
        if (TDBOps.isTDB2((String)directory)) {
            DSGSetup.setupTDB2(directory, serverConfig);
            return;
        }
        throw new CmdException("Directory not a database: " + directory);
    }

    private static void setupTDB1(String directory, ServerConfig serverConfig) {
        serverConfig.datasetDescription = "TDB1 dataset: location=" + directory;
        serverConfig.dsg = TDBFactory.createDatasetGraph((String)directory);
    }

    private static void setupTDB2(String directory, ServerConfig serverConfig) {
        serverConfig.datasetDescription = "TDB2 dataset: location=" + directory;
        serverConfig.dsg = DatabaseMgr.connectDatasetGraph((String)directory);
    }

    public static void setupMemTDB(boolean useTDB2, ServerConfig serverConfig) {
        String tag = useTDB2 ? "TDB2" : "TDB1";
        serverConfig.datasetDescription = tag + " dataset in-memory";
        serverConfig.dsg = useTDB2 ? DatabaseMgr.createDatasetGraph() : TDBFactory.createDatasetGraph();
        serverConfig.allowUpdate = true;
    }
}

