/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class JettyLib {
    public static void addHandler(Server server, Handler handler) {
        Handler currentHandler = server.getHandler();
        if (currentHandler == null) {
            server.setHandler(handler);
        } else if (currentHandler instanceof HandlerList) {
            ((HandlerList)currentHandler).addHandler(handler);
        } else {
            HandlerList handlerList = new HandlerList();
            handlerList.addHandler(currentHandler);
            handlerList.addHandler(handler);
            server.setHandler((Handler)handlerList);
        }
    }

    public static void setMimeTypes(ServletContextHandler context) {
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("nt", "application/n-triples");
        mimeTypes.addMimeMapping("nq", "application/n-quads");
        mimeTypes.addMimeMapping("ttl", "text/turtle;charset=utf-8");
        mimeTypes.addMimeMapping("trig", "application/trig;charset=utf-8");
        mimeTypes.addMimeMapping("rdf", "application/rdf+xml");
        mimeTypes.addMimeMapping("jsonld", "application/ld+json");
        mimeTypes.addMimeMapping("rj", "application/rdf+json");
        mimeTypes.addMimeMapping("rt", "application/rdf+thrift");
        mimeTypes.addMimeMapping("trdf", "application/rdf+thrift");
        mimeTypes.addMimeMapping("rq", "application/sparql-query");
        mimeTypes.addMimeMapping("ru", "application/sparql-update");
        mimeTypes.addMimeMapping("rsj", "application/sparql-results+json");
        mimeTypes.addMimeMapping("rsx", "application/sparql-results+xml");
        mimeTypes.addMimeMapping("srt", "application/sparql-results+thrift");
        mimeTypes.addMimeMapping("srt", "application/sparql-results+protobuf");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mimeTypes.addMimeMapping("csv", "text/csv");
        mimeTypes.addMimeMapping("tsv", "text/tab-separated-values");
        context.setMimeTypes(mimeTypes);
    }

    public static HttpConfiguration httpConfiguration() {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setRequestHeaderSize(524288);
        http_config.setOutputBufferSize(0x100000);
        http_config.setSendServerVersion(false);
        return http_config;
    }
}

