/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiCoreInfo;
import org.slf4j.Logger;

public class FusekiMainInfo {
    public static void logCode(Logger log) {
        FusekiCoreInfo.logCode((Logger)log);
    }

    public static void logServer(Logger log, FusekiServer server, boolean verbose) {
        FusekiMainInfo.logServerConnections(log, server);
        FusekiMainInfo.logServerDatasets(log, server, verbose);
        if (server.getStaticContentDir() != null) {
            FmtLog.info((Logger)log, (String)"Static files: %s", (Object[])new Object[]{server.getStaticContentDir()});
        }
    }

    public static void logServerCode(Logger log) {
        FusekiCoreInfo.logCode((Logger)log);
    }

    public static void logServerConnections(Logger log, FusekiServer server) {
        int httpsPort = server.getHttpsPort();
        int httpPort = server.getHttpPort();
        if (httpsPort > 0 && httpPort > 0) {
            log.info("Ports: http=" + httpPort + " https=" + httpsPort);
        } else if (httpsPort <= 0) {
            log.info("Port: http=" + httpPort);
        } else if (httpPort <= 0) {
            log.info("Port: https=" + httpsPort);
        }
    }

    public static void logServerDatasets(Logger log, FusekiServer server, boolean longForm) {
        FusekiCoreInfo.logDataAccessPointRegistry((Logger)log, (DataAccessPointRegistry)server.getDataAccessPointRegistry(), (boolean)longForm);
    }
}

