/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.file.Path;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.PropertyUtils;
import org.apache.jena.atlas.lib.Registry;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.ctl.ActionCompact;
import org.apache.jena.fuseki.ctl.ActionMetrics;
import org.apache.jena.fuseki.ctl.ActionPing;
import org.apache.jena.fuseki.ctl.ActionStats;
import org.apache.jena.fuseki.ctl.ActionTasks;
import org.apache.jena.fuseki.main.FusekiLib;
import org.apache.jena.fuseki.main.JettyHttps;
import org.apache.jena.fuseki.main.JettySecurityLib;
import org.apache.jena.fuseki.main.JettyServer;
import org.apache.jena.fuseki.main.cmds.FusekiMain;
import org.apache.jena.fuseki.main.sys.FusekiAutoModules;
import org.apache.jena.fuseki.main.sys.FusekiErrorHandler;
import org.apache.jena.fuseki.main.sys.FusekiModuleStep;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.main.sys.JettyLib;
import org.apache.jena.fuseki.metrics.MetricsProviderRegistry;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.AuthFilter;
import org.apache.jena.fuseki.servlets.CrossOriginFilter;
import org.apache.jena.fuseki.servlets.FusekiFilter;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletAction;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NotUniqueException;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.system.G;
import org.apache.jena.web.HttpSC;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.slf4j.Logger;

public class FusekiServer {
    public static final int DefaultServerPort = 3330;
    private final Server server;
    private int httpPort;
    private int httpsPort;
    private final String staticContentDir;
    private final ServletContext servletContext;
    private final FusekiModules modules;

    public static FusekiServer construct(String ... args) {
        return FusekiMain.build(args);
    }

    public static FusekiServer make(int port, String name, DatasetGraph dsg) {
        return FusekiServer.create().port(port).loopback(true).add(name, dsg).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(OperationRegistry serviceDispatchRegistry) {
        return new Builder(serviceDispatchRegistry);
    }

    private FusekiServer(int httpPort, int httpsPort, Server server, String staticContentDir, FusekiModules modules, ServletContext fusekiServletContext) {
        this.server = Objects.requireNonNull(server);
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.staticContentDir = staticContentDir;
        this.servletContext = Objects.requireNonNull(fusekiServletContext);
        this.modules = Objects.requireNonNull(modules);
    }

    public int getPort() {
        return this.httpsPort > 0 ? this.httpsPort : this.httpPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String serverURL() {
        return this.schemeHostPort() + "/";
    }

    public String datasetURL(String dsName) {
        if (!((String)dsName).startsWith("/")) {
            dsName = "/" + (String)dsName;
        }
        return this.schemeHostPort() + (String)dsName;
    }

    private String schemeHostPort() {
        int port = this.getHttpPort();
        String scheme = "http";
        if (this.getHttpsPort() > 0) {
            scheme = "https";
            port = this.getHttpsPort();
        }
        return scheme + "://localhost:" + port;
    }

    public Server getJettyServer() {
        return this.server;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return DataAccessPointRegistry.get((ServletContext)this.getServletContext());
    }

    public OperationRegistry getOperationRegistry() {
        return OperationRegistry.get((ServletContext)this.getServletContext());
    }

    public String getStaticContentDir() {
        return this.staticContentDir;
    }

    public FusekiModules getModules() {
        return this.modules;
    }

    public FusekiServer start() {
        try {
            FusekiModuleStep.serverBeforeStarting(this);
            this.server.start();
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof UnrecoverableKeyException) {
                throw new FusekiException(ex.getMessage());
            }
            throw new FusekiException((Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new FusekiException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new FusekiException((Throwable)ex);
        }
        Connector[] connectors = this.server.getServer().getConnectors();
        if (connectors.length == 0) {
            Fuseki.serverLog.warn("Start Fuseki: No connectors");
        }
        Arrays.stream(connectors).forEach(c -> {
            if (c instanceof ServerConnector) {
                ServerConnector connector = (ServerConnector)c;
                String protocol = connector.getDefaultConnectionFactory().getProtocol();
                String scheme = protocol.startsWith("SSL-") || protocol.equals("SSL") ? "https" : "http";
                int port = connector.getLocalPort();
                this.connector(scheme, port);
            }
        });
        FusekiModuleStep.serverAfterStarting(this);
        if (this.httpsPort > 0 && this.httpPort > 0) {
            Fuseki.serverLog.info("Start Fuseki (http=" + this.httpPort + " https=" + this.httpsPort + ")");
        } else if (this.httpsPort > 0) {
            Fuseki.serverLog.info("Start Fuseki (https=" + this.httpsPort + ")");
        } else if (this.httpPort > 0) {
            Fuseki.serverLog.info("Start Fuseki (http=" + this.httpPort + ")");
        } else {
            Fuseki.serverLog.info("Start Fuseki");
        }
        return this;
    }

    private void connector(String scheme, int port) {
        switch (scheme) {
            case "http": {
                if (this.httpPort > 0) break;
                this.httpPort = port;
                break;
            }
            case "https": {
                if (this.httpsPort > 0) break;
                this.httpsPort = port;
            }
        }
    }

    public void stop() {
        Fuseki.serverLog.info("Stop Fuseki");
        try {
            this.server.stop();
            FusekiModuleStep.serverStopped(this);
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new FusekiException((Throwable)e);
        }
    }

    static {
        JenaSystem.init();
    }

    public static class Builder {
        private static final int PortUnset = -2;
        private static final int PortInactive = -3;
        private Registry<String, DataService.Builder> dataServices = new Registry();
        private Registry<String, DataService> providedDataServices = new Registry();
        private final OperationRegistry operationRegistry;
        private int serverHttpPort = -2;
        private int serverHttpsPort = -2;
        private boolean networkLoopback = false;
        private int minThreads = -1;
        private int maxThreads = -1;
        private ErrorHandler errorHandler = new FusekiErrorHandler();
        private boolean verbose = false;
        private boolean withCompact = false;
        private boolean withPing = false;
        private boolean withMetrics = false;
        private boolean withStats = false;
        private boolean withTasks = false;
        private String jettyServerConfig = null;
        private Model configModel = null;
        private Map<String, String> corsInitParams = null;
        private AuthPolicy serverAuth = null;
        private String passwordFile = null;
        private String realm = null;
        private AuthScheme authScheme = null;
        private String httpsKeystore = null;
        private String httpsKeystorePasswd = null;
        private Function<String, String> bearerVerifiedUser = null;
        private Map<String, HttpServlet> servlets = new HashMap<String, HttpServlet>();
        private List<Pair<String, Filter>> beforeFilters = new ArrayList<Pair<String, Filter>>();
        private List<Pair<String, Filter>> afterFilters = new ArrayList<Pair<String, Filter>>();
        private FusekiModules fusekiModules = null;
        private String contextPath = "/";
        private String staticContentDir = null;
        private SecurityHandler securityHandler = null;
        private Map<String, Object> servletAttr = new HashMap<String, Object>();
        private static final Map<String, String> corsInitParamsDft = new LinkedHashMap<String, String>();
        private boolean hasAuthenticationHandler = false;
        private boolean hasDataAccessControl = false;
        private boolean authenticateUser = false;

        private Builder() {
            this.operationRegistry = OperationRegistry.createStd();
        }

        private Builder(OperationRegistry operationRegistry) {
            this.operationRegistry = OperationRegistry.createEmpty();
            OperationRegistry.copyConfig((OperationRegistry)operationRegistry, (OperationRegistry)this.operationRegistry);
        }

        private boolean isRegistered(String datasetPath) {
            return this.dataServices.isRegistered((Object)(datasetPath = DataAccessPoint.canonical((String)datasetPath))) || this.providedDataServices.isRegistered((Object)datasetPath);
        }

        public Builder port(int port) {
            if (port == -1) {
                this.serverHttpPort = -3;
                return this;
            }
            if (port < 0) {
                throw new IllegalArgumentException("Illegal port=" + port + " : Port must be greater than or equal to zero, or -1 to unset");
            }
            this.serverHttpPort = port;
            return this;
        }

        public Builder contextPath(String path) {
            this.contextPath = path;
            return this;
        }

        public Builder loopback(boolean loopback) {
            this.networkLoopback = loopback;
            return this;
        }

        public Builder staticFileBase(String directory) {
            String dir;
            Objects.requireNonNull(directory, "directory");
            if (!FileOps.exists((String)directory)) {
                Fuseki.configLog.warn("File area not found: " + directory);
            }
            this.staticContentDir = dir = Path.of(directory, new String[0]).toAbsolutePath().toString();
            return this;
        }

        public String staticFileBase() {
            return this.staticContentDir;
        }

        public Builder securityHandler(SecurityHandler securityHandler) {
            Objects.requireNonNull(securityHandler, "securityHandler");
            this.securityHandler = securityHandler;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder enableCors(boolean withCORS) {
            return this.enableCors(withCORS, null);
        }

        public Builder enableCors(boolean withCORS, String corsConfigFile) {
            this.corsInitParams = withCORS ? (corsConfigFile == null ? corsInitParamsDft : Builder.parseCORSConfigFile(corsConfigFile)) : null;
            return this;
        }

        public Builder enablePing(boolean withPing) {
            this.withPing = withPing;
            return this;
        }

        public Builder enableStats(boolean withStats) {
            this.withStats = withStats;
            return this;
        }

        public Builder enableMetrics(boolean withMetrics) {
            this.withMetrics = withMetrics;
            return this;
        }

        public Builder enableCompact(boolean withCompact) {
            this.withCompact = withCompact;
            if (withCompact) {
                this.enableTasks(true);
            }
            return this;
        }

        public Builder enableTasks(boolean withTasks) {
            this.withTasks = withTasks;
            return this;
        }

        public DataService.Builder getDataServiceBuilder(String name) {
            Objects.requireNonNull(name, "name");
            name = DataAccessPoint.canonical((String)name);
            return (DataService.Builder)this.dataServices.get((Object)name);
        }

        public DatasetGraph getDataset(String name) {
            Objects.requireNonNull(name, "name");
            DataService.Builder b = this.getDataServiceBuilder(name);
            if (b == null) {
                return null;
            }
            return b.dataset();
        }

        public DatasetGraph remove(String name) {
            Objects.requireNonNull(name, "name");
            name = DataAccessPoint.canonical((String)name);
            DataService.Builder dSrvBuilder = (DataService.Builder)this.dataServices.get((Object)name);
            if (dSrvBuilder != null) {
                this.dataServices.remove((Object)name);
                return dSrvBuilder.dataset();
            }
            DataService provided = (DataService)this.providedDataServices.get((Object)name);
            if (provided != null) {
                this.providedDataServices.remove((Object)name);
                return provided.getDataset();
            }
            return null;
        }

        public Builder add(String name, Dataset dataset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset.asDatasetGraph());
        }

        public Builder add(String name, DatasetGraph dataset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset, true);
        }

        public Builder add(String name, Dataset dataset, boolean allowUpdate) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            return this.add(name, dataset.asDatasetGraph(), allowUpdate);
        }

        public Builder add(String name, DatasetGraph dataset, boolean allowUpdate) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            name = DataAccessPoint.canonical((String)name);
            if (this.isRegistered(name)) {
                throw new FusekiConfigException("Data service name already registered: " + name);
            }
            DataService.Builder dataServiceBuilder = DataService.newBuilder((DatasetGraph)dataset).withStdServices(allowUpdate);
            this.addNamedDataService$(name, dataServiceBuilder);
            return this;
        }

        public Builder addDataset(String name, DatasetGraph dataset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataset, "dataset");
            DataService.Builder dataServiceBuilder = DataService.newBuilder((DatasetGraph)dataset);
            return this.addNamedDataService$(name, dataServiceBuilder);
        }

        public Builder add(String name, DataService.Builder dataServiceBuilder) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataServiceBuilder, "dataServiceBuilderr");
            this.addNamedDataService$(name, dataServiceBuilder);
            return this;
        }

        private Builder addNamedDataService$(String name, DataService.Builder builder) {
            name = DataAccessPoint.canonical((String)name);
            this.dataServices.put((Object)name, (Object)builder);
            return this;
        }

        public Builder add(String name, DataService dataService) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(dataService, "dataService");
            return this.addDefinedDataService$(name, dataService);
        }

        private Builder addDefinedDataService$(String name, DataService dataService) {
            if (this.isRegistered(name = DataAccessPoint.canonical((String)name))) {
                throw new FusekiConfigException("Data service name already registered: " + name);
            }
            this.providedDataServices.put((Object)name, (Object)dataService);
            return this;
        }

        public Builder parseConfigFile(String filename) {
            Objects.requireNonNull(filename, "filename");
            Model model = AssemblerUtils.readAssemblerFile((String)filename);
            this.parseConfig(model);
            return this;
        }

        public Builder parseConfig(Model model) {
            Objects.requireNonNull(model, "model");
            Resource server = FusekiConfig.findServer((Model)model);
            this.processConfigServerLevel(server);
            Context settings = new Context();
            List x = FusekiConfig.processServerConfiguration((Model)model, (Context)settings);
            Fuseki.getContext().putAll(settings);
            x.forEach(dap -> this.addDataAccessPoint((DataAccessPoint)dap));
            this.configModel = model;
            return this;
        }

        public Builder parseConfig(Graph graph) {
            return this.parseConfig(ModelFactory.createModelForGraph((Graph)graph));
        }

        private Builder addDataAccessPoint(DataAccessPoint dap) {
            if (this.isRegistered(dap.getName())) {
                throw new FusekiConfigException("Data service name already registered: " + dap.getName());
            }
            this.addNamedDataService$(dap.getName(), DataService.newBuilder((DataService)dap.getDataService()));
            return this;
        }

        public Builder jettyServerConfig(String filename) {
            Objects.requireNonNull(filename, "filename");
            if (!FileOps.exists((String)filename)) {
                throw new FusekiConfigException("File no found: " + filename);
            }
            this.jettyServerConfig = filename;
            return this;
        }

        private void processConfigServerLevel(Resource server) {
            if (server == null) {
                return;
            }
            if (server.hasProperty(FusekiVocab.pServerContextPath)) {
                this.contextPath(Builder.argString(server, FusekiVocab.pServerContextPath, "/"));
            }
            this.enablePing(Builder.argBoolean(server, FusekiVocab.pServerPing, false));
            this.enableStats(Builder.argBoolean(server, FusekiVocab.pServerStats, false));
            this.enableMetrics(Builder.argBoolean(server, FusekiVocab.pServerMetrics, false));
            this.enableCompact(Builder.argBoolean(server, FusekiVocab.pServerCompact, false));
            this.processConfAuthentication(server);
            this.serverAuth = FusekiConfig.allowedUsers((Resource)server);
        }

        private void processConfAuthentication(Resource server) {
            String authStr;
            String realmStr;
            String passwdFile = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pPasswordFile);
            if (passwdFile != null) {
                this.passwordFile(passwdFile);
            }
            if ((realmStr = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pRealm)) != null) {
                this.realm(realmStr);
            }
            if ((authStr = GraphUtils.getAsStringValue((Resource)server, (Property)FusekiVocab.pAuth)) != null) {
                AuthScheme authScheme = AuthScheme.scheme((String)authStr);
                switch (authScheme) {
                    case BASIC: 
                    case DIGEST: {
                        break;
                    }
                    case BEARER: {
                        throw new FusekiConfigException("Authentication scheme not supported in config file: \"" + authStr + "\"");
                    }
                    default: {
                        throw new FusekiConfigException("Authentication scheme not recognized: \"" + authStr + "\"");
                    }
                }
                this.auth(authScheme);
            }
        }

        private static boolean argBoolean(Resource r, Property p, boolean dftValue) {
            try {
                GraphUtils.atmostOneProperty((Resource)r, (Property)p);
            }
            catch (NotUniqueException ex) {
                throw new FusekiConfigException(ex.getMessage());
            }
            Statement stmt = r.getProperty(p);
            if (stmt == null) {
                return dftValue;
            }
            try {
                return stmt.getBoolean();
            }
            catch (JenaException ex) {
                throw new FusekiConfigException("Not a boolean for '" + p + "' : " + stmt.getObject());
            }
        }

        private static String argString(Resource r, Property p, String dftValue) {
            try {
                GraphUtils.atmostOneProperty((Resource)r, (Property)p);
            }
            catch (NotUniqueException ex) {
                throw new FusekiConfigException(ex.getMessage());
            }
            Statement stmt = r.getProperty(p);
            if (stmt == null) {
                return dftValue;
            }
            try {
                Node n = stmt.getObject().asLiteral().asNode();
                if (!G.isString((Node)n)) {
                    throw new FusekiConfigException("Not a string for '" + p + "' : " + stmt.getObject());
                }
                return n.getLiteralLexicalForm();
            }
            catch (JenaException ex) {
                throw new FusekiConfigException("Not a string for '" + p + "' : " + stmt.getObject());
            }
        }

        public Builder auth(AuthScheme authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        public Builder serverAuthPolicy(AuthPolicy authPolicy) {
            this.serverAuth = authPolicy;
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder passwordFile(String passwordFile) {
            if (passwordFile.startsWith("file:")) {
                passwordFile = IRILib.IRIToFilename((String)passwordFile);
            }
            this.passwordFile = passwordFile;
            return this;
        }

        public Builder https(int httpsPort, String certStore, String certStorePasswd) {
            Objects.requireNonNull(certStore, "certStore");
            Objects.requireNonNull(certStorePasswd, "certStorePasswd");
            if (httpsPort <= -1) {
                this.serverHttpsPort = -3;
                this.httpsKeystore = null;
                this.httpsKeystorePasswd = null;
                return this;
            }
            this.httpsKeystore = certStore;
            this.httpsKeystorePasswd = certStorePasswd;
            this.serverHttpsPort = httpsPort;
            return this;
        }

        public Builder https(int httpsPort, String certificate) {
            Objects.requireNonNull(certificate, "certificate file");
            if (httpsPort <= -1) {
                this.serverHttpsPort = -3;
                this.httpsKeystore = null;
                this.httpsKeystorePasswd = null;
                return this;
            }
            this.setHttpsCert(certificate);
            this.serverHttpsPort = httpsPort;
            return this;
        }

        private void setHttpsCert(String filename) {
            try {
                JsonObject httpsConf = JSON.read((String)filename);
                Path path = Path.of(filename, new String[0]).toAbsolutePath();
                String keystore = httpsConf.get("keystore").getAsString().value();
                this.httpsKeystore = path.getParent().resolve(keystore).toString();
                this.httpsKeystorePasswd = httpsConf.get("passwd").getAsString().value();
            }
            catch (Exception ex) {
                this.httpsKeystore = null;
                this.httpsKeystorePasswd = null;
                throw new FusekiConfigException("Failed to read the HTTP details file: " + ex.getMessage());
            }
        }

        public Builder addProcessor(String pathSpec, ActionProcessor processor) {
            return this.addProcessor(pathSpec, processor, Fuseki.actionLog);
        }

        public Builder addProcessor(String pathSpec, ActionProcessor processor, Logger log) {
            HttpServlet proc;
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(processor, "processor");
            Object servlet = processor instanceof HttpServlet ? (proc = (HttpServlet)processor) : new ServletAction(processor, log);
            this.addServlet(pathSpec, (HttpServlet)servlet);
            return this;
        }

        public Builder addServlet(String pathSpec, HttpServlet servlet) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(servlet, "servlet");
            this.servlets.put(pathSpec, servlet);
            return this;
        }

        public Builder addServletAttribute(String attrName, Object value) {
            Objects.requireNonNull(attrName, "attrName");
            if (value != null) {
                this.servletAttr.put(attrName, value);
            } else {
                this.servletAttr.remove(attrName);
            }
            return this;
        }

        public Object getServletAttribute(String attrName) {
            Objects.requireNonNull(attrName, "attrName");
            return this.servletAttr.get(attrName);
        }

        public Builder addFilter(String pathSpec, Filter filter) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(filter, "filter");
            this.beforeFilters.add((Pair<String, Filter>)Pair.create((Object)pathSpec, (Object)filter));
            return this;
        }

        public Builder fusekiModules(FusekiModules modules) {
            this.fusekiModules = modules;
            return this;
        }

        public FusekiModules fusekiModules() {
            return this.fusekiModules;
        }

        public Builder registerOperation(Operation operation, ActionService handler) {
            this.registerOperation(operation, null, handler);
            return this;
        }

        public Builder registerOperation(Operation operation, String contentType, ActionService handler) {
            Objects.requireNonNull(operation, "operation");
            if (handler == null) {
                this.operationRegistry.unregister(operation);
            } else {
                this.operationRegistry.register(operation, contentType, handler);
            }
            return this;
        }

        public Builder addEndpoint(String datasetName, String endpointName, Operation operation) {
            return this.addEndpoint(datasetName, endpointName, operation, null);
        }

        public Builder addEndpoint(String datasetName, String endpointName, Operation operation, AuthPolicy authPolicy) {
            Objects.requireNonNull(datasetName, "datasetName");
            Objects.requireNonNull(endpointName, "endpointName");
            Objects.requireNonNull(operation, "operation");
            this.serviceEndpointOperation(datasetName, endpointName, operation, authPolicy);
            return this;
        }

        public Builder addOperation(String datasetName, Operation operation) {
            this.addOperation(datasetName, operation, null);
            return this;
        }

        public Builder addOperation(String datasetName, Operation operation, AuthPolicy authPolicy) {
            Objects.requireNonNull(datasetName, "datasetName");
            Objects.requireNonNull(operation, "operation");
            this.serviceEndpointOperation(datasetName, null, operation, authPolicy);
            return this;
        }

        private void serviceEndpointOperation(String datasetName, String endpointName, Operation operation, AuthPolicy authPolicy) {
            String name = DataAccessPoint.canonical((String)datasetName);
            if (!this.operationRegistry.isRegistered(operation)) {
                throw new FusekiConfigException("Operation not registered: " + operation.getName());
            }
            if (!this.isRegistered(name)) {
                throw new FusekiConfigException("Dataset not registered: " + datasetName);
            }
            DataService.Builder dsBuilder = (DataService.Builder)this.dataServices.get((Object)name);
            Endpoint endpoint = Endpoint.create().operation(operation).endpointName(endpointName).authPolicy(authPolicy).build();
            dsBuilder.addEndpoint(endpoint);
        }

        public Builder numServerThreads(int minThreads, int maxThreads) {
            if (minThreads >= 0 && maxThreads > 0 && minThreads > maxThreads) {
                throw new FusekiConfigException(String.format("Bad thread setting: (min=%d, max=%d)", minThreads, maxThreads));
            }
            this.minThreads = minThreads;
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder maxServerThreads(int maxThreads) {
            if (this.minThreads > maxThreads) {
                throw new FusekiConfigException(String.format("Bad thread setting: (min=%d, max=%d)", this.minThreads, maxThreads));
            }
            this.numServerThreads(this.minThreads, maxThreads);
            return this;
        }

        public FusekiServer start() {
            return this.build().start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FusekiServer build() {
            if (this.serverHttpPort < 0 && this.serverHttpsPort < 0) {
                this.serverHttpPort = 3330;
            }
            FusekiModules modules = this.fusekiModules == null ? FusekiAutoModules.load() : this.fusekiModules;
            Set<String> datasetNames = Set.copyOf(this.dataServices.keys());
            FusekiModuleStep.prepare(modules, this, datasetNames, this.configModel);
            OperationRegistry operationReg = new OperationRegistry(this.operationRegistry);
            DataAccessPointRegistry dapRegistry = this.buildStart();
            FusekiModuleStep.configured(modules, this, dapRegistry, this.configModel);
            this.bindPrometheus(dapRegistry);
            this.buildSecurity(dapRegistry);
            try {
                this.validate();
                ServletContextHandler handler = this.buildFusekiServerContext();
                boolean hasFusekiSecurityHandler = this.applySecurityHandler(handler);
                Builder.applyDatabaseSetup(handler, dapRegistry, operationReg);
                if (hasFusekiSecurityHandler) {
                    this.applyAccessControl(handler, dapRegistry);
                }
                if (this.jettyServerConfig != null) {
                    Server server = this.jettyServer(handler, this.jettyServerConfig);
                    FusekiServer fusekiServer = new FusekiServer(-1, -1, server, this.staticContentDir, modules, handler.getServletContext());
                    return fusekiServer;
                }
                int httpPort = Math.max(-1, this.serverHttpPort);
                int httpsPort = Math.max(-1, this.serverHttpsPort);
                Server server = httpsPort <= -1 ? Builder.jettyServer(handler, httpPort, this.minThreads, this.maxThreads) : Builder.jettyServerHttps(handler, httpPort, httpsPort, this.minThreads, this.maxThreads, this.httpsKeystore, this.httpsKeystorePasswd);
                if (this.errorHandler != null) {
                    server.setErrorHandler((Request.Handler)this.errorHandler);
                }
                if (this.networkLoopback) {
                    Builder.applyLocalhost(server);
                }
                FusekiServer fusekiServer = new FusekiServer(httpPort, httpsPort, server, this.staticContentDir, modules, handler.getServletContext());
                FusekiModuleStep.server(fusekiServer);
                FusekiServer fusekiServer2 = fusekiServer;
                return fusekiServer2;
            }
            finally {
                this.buildFinish();
            }
        }

        private DataAccessPointRegistry buildStart() {
            DataAccessPointRegistry dapRegistry = new DataAccessPointRegistry();
            this.dataServices.forEach((name, builder) -> {
                DataService dSrv = builder.build();
                DataAccessPoint dap = new DataAccessPoint(name, dSrv);
                dapRegistry.register(dap);
            });
            this.providedDataServices.forEach((name, dSrv) -> {
                DataAccessPoint dap = new DataAccessPoint(name, dSrv);
                dapRegistry.register(dap);
            });
            return dapRegistry;
        }

        private void bindPrometheus(DataAccessPointRegistry dapRegistry) {
            if (this.withMetrics) {
                MetricsProviderRegistry.bindPrometheus((DataAccessPointRegistry)dapRegistry);
            }
        }

        private ServletContextHandler buildFusekiServerContext() {
            ServletContextHandler handler = this.buildServletContext(this.contextPath);
            ServletContext cxt = handler.getServletContext();
            Fuseki.setVerbose((ServletContext)cxt, (boolean)this.verbose);
            this.servletAttr.forEach((n, v) -> cxt.setAttribute(n, v));
            JettyLib.setMimeTypes(handler);
            this.servletsAndFilters(handler);
            return handler;
        }

        private static void prepareDataServices(DataAccessPointRegistry dapRegistry, OperationRegistry operationReg) {
            dapRegistry.forEach((name, dap) -> {
                if (DataAccessCtl.isAccessControlled((DatasetGraph)dap.getDataService().getDataset())) {
                    dap.getDataService().forEachEndpoint(ep -> FusekiLib.modifyForAccessCtl(ep, (Function<HttpAction, String>)DataAccessCtl.requestUserServlet));
                }
            });
            dapRegistry.forEach((name, dap) -> {
                dap.getDataService().setEndpointProcessors(operationReg);
                dap.getDataService().goActive();
            });
        }

        private static void applyDatabaseSetup(ServletContextHandler handler, DataAccessPointRegistry dapRegistry, OperationRegistry operationReg) {
            Builder.prepareDataServices(dapRegistry, operationReg);
            ServletContext cxt = handler.getServletContext();
            OperationRegistry.set((ServletContext)cxt, (OperationRegistry)operationReg);
            DataAccessPointRegistry.set((ServletContext)cxt, (DataAccessPointRegistry)dapRegistry);
        }

        private ConstraintSecurityHandler buildSecurityHandler() {
            UserStore userStore = JettySecurityLib.makeUserStore(this.passwordFile);
            return JettySecurityLib.makeSecurityHandler(this.realm, userStore, this.authScheme);
        }

        private void buildSecurity(DataAccessPointRegistry dataAccessPoints) {
            boolean bl = this.hasAuthenticationHandler = this.passwordFile != null || this.securityHandler != null;
            if (this.realm == null) {
                this.realm = "TripleStore";
            }
            this.hasDataAccessControl = dataAccessPoints.keys().stream().map(name -> dataAccessPoints.get(name).getDataService().getDataset()).anyMatch(DataAccessCtl::isAccessControlled);
            boolean bl2 = this.authenticateUser = this.serverAuth != null;
            if (!this.authenticateUser) {
                this.authenticateUser = dataAccessPoints.keys().stream().map(name -> dataAccessPoints.get(name).getDataService()).anyMatch(dSvc -> dSvc.authPolicy() != null);
            }
            if (!this.authenticateUser) {
                this.authenticateUser = dataAccessPoints.keys().stream().map(name -> dataAccessPoints.get(name).getDataService()).flatMap(dSrv -> dSrv.getEndpoints().stream()).anyMatch(ep -> ep.getAuthPolicy() != null);
            }
            if (this.passwordFile != null && !this.authenticateUser && this.serverAuth == null) {
                this.serverAuth = Auth.ANY_USER;
                this.authenticateUser = true;
            }
        }

        private static boolean authAny(AuthPolicy policy) {
            return policy == null || policy == Auth.ANY_ANON || policy.isAllowed(null);
        }

        private boolean hasServerWideAuth() {
            return !Builder.authAny(this.serverAuth);
        }

        private void buildFinish() {
            this.hasAuthenticationHandler = false;
            this.hasDataAccessControl = false;
        }

        private void validate() {
            if (!this.hasAuthenticationHandler && this.authScheme != AuthScheme.BEARER) {
                if (this.authenticateUser) {
                    Fuseki.configLog.warn("Authentication of users required (e.g. 'allowedUsers' is set) but there is no authentication setup (e.g. password file)");
                }
                if (this.hasDataAccessControl) {
                    Fuseki.configLog.warn("Data-level access control in the configuration but there is no authentication setup (e.g. password file)");
                }
            }
            if (this.authScheme != null) {
                switch (this.authScheme) {
                    case BASIC: 
                    case DIGEST: {
                        if (this.passwordFile != null || this.securityHandler != null) break;
                        throw new FusekiConfigException("Authentication scheme set but no password file");
                    }
                    case BEARER: {
                        break;
                    }
                    case UNKNOWN: {
                        throw new FusekiConfigException("Unknown authentication scheme");
                    }
                }
            }
        }

        private boolean applySecurityHandler(ServletContextHandler cxt) {
            if (this.securityHandler == null && this.passwordFile != null) {
                this.securityHandler = this.buildSecurityHandler();
            }
            if (this.securityHandler == null) {
                return false;
            }
            cxt.setSecurityHandler(this.securityHandler);
            if (!(this.securityHandler instanceof ConstraintSecurityHandler)) {
                return false;
            }
            ConstraintSecurityHandler csh = (ConstraintSecurityHandler)this.securityHandler;
            if (this.hasServerWideAuth()) {
                JettySecurityLib.addPathConstraint(csh, "/*");
            }
            return true;
        }

        private void applyAccessControl(ServletContextHandler cxt, DataAccessPointRegistry dapRegistry) {
            ConstraintSecurityHandler csh = (ConstraintSecurityHandler)cxt.getSecurityHandler();
            if (csh == null) {
                return;
            }
            dapRegistry.forEach((name, dap) -> {
                if (!Builder.authAny(dap.getDataService().authPolicy())) {
                    JettySecurityLib.addPathConstraint(csh, DataAccessPoint.canonical((String)name));
                    JettySecurityLib.addPathConstraint(csh, DataAccessPoint.canonical((String)name) + "/*");
                } else {
                    dap.getDataService().forEachEndpoint(ep -> {
                        if (!Builder.authAny(ep.getAuthPolicy())) {
                            if (ep.getName().isEmpty()) {
                                JettySecurityLib.addPathConstraint(csh, DataAccessPoint.canonical((String)name));
                                JettySecurityLib.addPathConstraint(csh, DataAccessPoint.canonical((String)name) + "/*");
                            } else {
                                JettySecurityLib.addPathConstraint(csh, DataAccessPoint.canonical((String)name) + "/" + ep.getName());
                            }
                        }
                    });
                }
            });
        }

        private ServletContextHandler buildServletContext(String contextPath) {
            if (contextPath == null || ((String)contextPath).isEmpty()) {
                contextPath = "/";
            } else if (!((String)contextPath).startsWith("/")) {
                contextPath = "/" + (String)contextPath;
            }
            ServletContextHandler context = new ServletContextHandler();
            context.setDisplayName(Fuseki.servletRequestLogName);
            context.setErrorHandler((Request.Handler)this.errorHandler);
            context.setContextPath((String)contextPath);
            context.setMaxFormContentSize(0x100000);
            return context;
        }

        private void servletsAndFilters(ServletContextHandler context) {
            if (this.corsInitParams != null) {
                CrossOriginFilter corsFilter = new CrossOriginFilter();
                FilterHolder holder = new FilterHolder((Filter)corsFilter);
                holder.setInitParameters(this.corsInitParams);
                Builder.addFilterHolder(context, "/*", holder);
            }
            if (this.hasServerWideAuth()) {
                Predicate<String> auth = arg_0 -> ((AuthPolicy)this.serverAuth).isAllowed(arg_0);
                AuthFilter authFilter = new AuthFilter(auth);
                Builder.addFilter(context, "/*", (Filter)authFilter);
            }
            this.beforeFilters.forEach(pair -> Builder.addFilter(context, (String)pair.getLeft(), (Filter)pair.getRight()));
            FusekiFilter ff = new FusekiFilter();
            Builder.addFilter(context, "/*", (Filter)ff);
            if (this.withPing) {
                Builder.addServlet(context, "/$/ping", (HttpServlet)new ActionPing());
            }
            if (this.withStats) {
                Builder.addServlet(context, "/$/stats/*", (HttpServlet)new ActionStats());
            }
            if (this.withMetrics) {
                Builder.addServlet(context, "/$/metrics", (HttpServlet)new ActionMetrics());
            }
            if (this.withCompact) {
                Builder.addServlet(context, "/$/compact/*", (HttpServlet)new ActionCompact());
            }
            if (this.withTasks) {
                Builder.addServlet(context, "/$/tasks/*", (HttpServlet)new ActionTasks());
            }
            this.servlets.forEach((pathspecp, servlet) -> Builder.addServlet(context, pathspecp, servlet));
            this.afterFilters.forEach(pair -> Builder.addFilter(context, (String)pair.getLeft(), (Filter)pair.getRight()));
            if (this.staticContentDir != null) {
                staticServlet = new DefaultServlet();
                ServletHolder staticContent = new ServletHolder((Servlet)staticServlet);
                staticContent.setInitParameter("baseResource", this.staticContentDir);
                context.addServlet(staticContent, "/");
            } else {
                staticServlet = new Servlet404();
                ServletHolder staticContent = new ServletHolder((Servlet)staticServlet);
                context.addServlet(staticContent, "/");
            }
        }

        private static void addServlet(ServletContextHandler context, String pathspec, HttpServlet httpServlet) {
            ServletHolder sh = new ServletHolder((Servlet)httpServlet);
            context.addServlet(sh, pathspec);
        }

        private static void addFilter(ServletContextHandler context, String pathspec, Filter filter) {
            FilterHolder holder = new FilterHolder(filter);
            Builder.addFilterHolder(context, pathspec, holder);
        }

        private static void addFilterHolder(ServletContextHandler context, String pathspec, FilterHolder holder) {
            context.addFilter(holder, pathspec, null);
        }

        private static Server jettyServer(ServletContextHandler handler, int port, int minThreads, int maxThreads) {
            Server server = JettyServer.jettyServer(minThreads, maxThreads);
            HttpConfiguration httpConfig = JettyLib.httpConfiguration();
            if (Fuseki.outputJettyServerHeader) {
                httpConfig.setSendServerVersion(true);
            }
            HttpConnectionFactory f1 = new HttpConnectionFactory(httpConfig);
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{f1});
            connector.setPort(port);
            server.addConnector((Connector)connector);
            server.setHandler((Handler)handler);
            return server;
        }

        private Server jettyServer(ServletContextHandler handler, String jettyServerConfig) {
            Fuseki.serverLog.info("Jetty server config file = " + jettyServerConfig);
            Server server = JettyServer.jettyServer(jettyServerConfig);
            server.setHandler((Handler)handler);
            return server;
        }

        private static Server jettyServerHttps(ServletContextHandler handler, int httpPort, int httpsPort, int minThreads, int maxThreads, String keystore, String certPassword) {
            return JettyHttps.jettyServerHttps(handler, keystore, certPassword, httpPort, httpsPort, minThreads, maxThreads);
        }

        private static void applyLocalhost(Server server) {
            Connector[] connectors = server.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                Connector connector = connectors[i];
                if (!(connector instanceof ServerConnector)) continue;
                ServerConnector serverConnector = (ServerConnector)connector;
                serverConnector.setHost("localhost");
            }
        }

        private static Map<String, String> parseCORSConfigFile(String filename) {
            try {
                Properties properties = PropertyUtils.loadFromFile((String)filename);
                HashMap<String, String> map = new HashMap<String, String>(properties.size());
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    map.put((String)entry.getKey(), (String)entry.getValue());
                }
                return map;
            }
            catch (Exception ex) {
                throw new FusekiConfigException("Failed to read the CORS config file: " + filename, (Throwable)ex);
            }
        }

        static {
            corsInitParamsDft.put("allowedOrigins", "*");
            corsInitParamsDft.put("allowedMethods", "GET,POST,DELETE,PUT,HEAD,OPTIONS,PATCH");
            corsInitParamsDft.put("allowedHeaders", "X-Requested-With, Content-Type, Accept, Origin, Last-Modified, Authorization");
            corsInitParamsDft.put("exposedHeaders", "Cache-Control, Content-Language, Content-Length, Content-Type, Expires, Last-Modified, Pragma");
            corsInitParamsDft.put("chainPreflight", "false");
        }

        static class Servlet404
        extends HttpServlet {
            protected void doHead(HttpServletRequest req, HttpServletResponse resp) {
                Servlet404.err404(req, resp);
            }

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
                Servlet404.err404(req, resp);
            }

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
                Servlet404.err404(req, resp);
            }

            protected void doPut(HttpServletRequest req, HttpServletResponse resp) {
                Servlet404.err404(req, resp);
            }

            private static void err404(HttpServletRequest req, HttpServletResponse response) {
                try {
                    response.sendError(404, HttpSC.getMessage((int)404));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

