/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Version;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.main.sys.FusekiAutoModule;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.slf4j.Logger;

public class FusekiAutoModules {
    private static final Logger LOG = Fuseki.serverLog;
    private static final Object lock = new Object();
    public static final String logLoadingProperty = "fuseki.logLoading";
    public static final String envLogLoadingProperty = "FUSEKI_LOGLOADING";
    private static boolean allowDiscovery = true;
    private static boolean enabled = true;
    private static FusekiModules altFusekiModules = null;
    private static FusekiServiceLoaderModules autoModules = null;

    static boolean logModuleLoading() {
        return Lib.isPropertyOrEnvVarSetToTrue((String)logLoadingProperty, (String)envLogLoadingProperty);
    }

    static Logger logger() {
        return LOG;
    }

    public static void enable(boolean setting) {
        enabled = setting;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setup() {
        if (!FusekiAutoModules.isEnabled()) {
            return;
        }
        autoModules = FusekiAutoModules.createServiceLoaderModules();
    }

    public static FusekiModules load() {
        if (!enabled) {
            return FusekiModules.empty();
        }
        if (altFusekiModules != null) {
            return altFusekiModules;
        }
        return FusekiAutoModules.getServiceLoaderModules().load();
    }

    static void reset() {
        autoModules = null;
    }

    static void setSystemDefault(FusekiModules fusekiModules) {
        altFusekiModules = fusekiModules;
    }

    private static FusekiServiceLoaderModules getServiceLoaderModules() {
        if (autoModules == null) {
            FusekiAutoModules.setup();
        }
        return autoModules;
    }

    private static FusekiServiceLoaderModules createServiceLoaderModules() {
        FusekiServiceLoaderModules newAutoModules = new FusekiServiceLoaderModules();
        newAutoModules.setDiscovery();
        return newAutoModules;
    }

    private static class FusekiServiceLoaderModules {
        private ServiceLoader<FusekiAutoModule> serviceLoader = null;

        private FusekiServiceLoaderModules() {
        }

        private void setDiscovery() {
            this.serviceLoader = this.discover();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceLoader<FusekiAutoModule> discover() {
            this.discoveryWarnLegacy();
            Class<FusekiAutoModule> moduleClass = FusekiAutoModule.class;
            ServiceLoader<FusekiAutoModule> newServiceLoader = null;
            FusekiServiceLoaderModules fusekiServiceLoaderModules = this;
            synchronized (fusekiServiceLoaderModules) {
                try {
                    newServiceLoader = ServiceLoader.load(moduleClass, this.getClass().getClassLoader());
                }
                catch (ServiceConfigurationError ex) {
                    FmtLog.error((Logger)LOG, (Throwable)ex, (String)"Problem with service loading for %s", (Object[])new Object[]{moduleClass.getName()});
                    throw ex;
                }
                if (LOG.isDebugEnabled()) {
                    newServiceLoader.stream().forEach(provider -> FmtLog.info((Logger)LOG, (String)"Fuseki Module: %s", (Object[])new Object[]{provider.type().getSimpleName()}));
                }
            }
            return newServiceLoader;
        }

        private void discoveryWarnLegacy() {
            Class<FusekiModule> moduleClass = FusekiModule.class;
            try {
                ServiceLoader<FusekiModule> newServiceLoader = ServiceLoader.load(moduleClass, this.getClass().getClassLoader());
                newServiceLoader.stream().forEach(provider -> FmtLog.warn(FusekiAutoModules.class, (String)"Ignored: \"%s\" : legacy use of interface FusekiModule which has changed to FusekiAutoModule", (Object[])new Object[]{provider.type().getSimpleName()}));
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                // empty catch block
            }
        }

        private FusekiModules load() {
            if (this.serviceLoader == null) {
                FmtLog.error((Logger)LOG, (String)"Discovery step has not happened or it failed. Call FusekiSystemModules.discovery before FusekiSystemModules.load()", (Object[])new Object[0]);
                throw new FusekiConfigException("Discovery not performed");
            }
            Function<ServiceLoader.Provider, FusekiAutoModule> mapper = provider -> {
                try {
                    FusekiAutoModule afmod = (FusekiAutoModule)provider.get();
                    return afmod;
                }
                catch (ServiceConfigurationError ex) {
                    FmtLog.error((Logger)LOG, (Throwable)ex, (String)"Error instantiating class %s for %s", (Object[])new Object[]{provider.type().getName(), FusekiModule.class.getName()});
                    return null;
                }
            };
            List autoMods = this.serviceLoader.stream().map(mapper).filter(Objects::nonNull).sorted((x, y) -> Integer.compare(x.level(), y.level())).collect(Collectors.toList());
            List<FusekiModule> fmods = autoMods.stream().map(afmod -> {
                afmod.start();
                return afmod;
            }).collect(Collectors.toList());
            fmods.forEach(m -> {
                String name = m.name();
                if (name == null) {
                    name = m.getClass().getSimpleName();
                }
                FmtLog.info((Logger)LOG, (String)"Module: %s (%s)", (Object[])new Object[]{name, Version.versionForClass(m.getClass()).orElse("unknown")});
            });
            return FusekiModules.create(fmods);
        }
    }
}

