/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.fuseki.access.AccessCtl_AllowGET;
import org.apache.jena.fuseki.access.AccessCtl_Deny;
import org.apache.jena.fuseki.access.AccessCtl_GSP_R;
import org.apache.jena.fuseki.access.AccessCtl_SPARQL_QueryDataset;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.GSP_RW;
import org.apache.jena.fuseki.servlets.HttpAction;

public class FusekiLib {
    public static Collection<String> names(FusekiServer server) {
        DataAccessPointRegistry dataAccessPoints = DataAccessPointRegistry.get((ServletContext)server.getServletContext());
        int N = dataAccessPoints.size();
        Stream stream = DataAccessPointRegistry.get((ServletContext)server.getServletContext()).keys().stream();
        List names = stream.collect(Collectors.toCollection(() -> new ArrayList(N)));
        return names;
    }

    public static FusekiServer.Builder fusekiBuilderAccessCtl(Function<HttpAction, String> determineUser) {
        FusekiServer.Builder builder = FusekiServer.create();
        return FusekiLib.fusekiBuilderAccessCtl(builder, determineUser);
    }

    public static FusekiServer.Builder fusekiBuilderAccessCtl(FusekiServer.Builder builder, Function<HttpAction, String> determineUser) {
        builder.registerOperation(Operation.Query, "application/sparql-query", (ActionService)new AccessCtl_SPARQL_QueryDataset(determineUser));
        builder.registerOperation(Operation.GSP_R, (ActionService)new AccessCtl_GSP_R(determineUser));
        builder.registerOperation(Operation.Update, "application/sparql-update", (ActionService)new AccessCtl_Deny("Update"));
        builder.registerOperation(Operation.GSP_RW, (ActionService)new AccessCtl_AllowGET((ActionService)new GSP_RW(), "GSP Write"));
        builder.registerOperation(Operation.GSP_RW, (ActionService)new AccessCtl_GSP_R(determineUser));
        return builder;
    }

    public static void modifyForAccessCtl(DataAccessPointRegistry dapRegistry, Function<HttpAction, String> determineUser) {
        dapRegistry.forEach((name, dap) -> dap.getDataService().forEachEndpoint(ep -> {
            Operation op = ep.getOperation();
            FusekiLib.modifyForAccessCtl(ep, determineUser);
        }));
    }

    public static void modifyForAccessCtl(Endpoint endpoint, Function<HttpAction, String> determineUser) {
        endpoint.setProcessor((ActionProcessor)FusekiLib.controlledProc(endpoint.getOperation(), determineUser));
    }

    private static ActionService controlledProc(Operation op, Function<HttpAction, String> determineUser) {
        if (Operation.Query.equals((Object)op)) {
            return new AccessCtl_SPARQL_QueryDataset(determineUser);
        }
        if (Operation.GSP_R.equals((Object)op)) {
            return new AccessCtl_GSP_R(determineUser);
        }
        if (Operation.GSP_RW.equals((Object)op)) {
            return new AccessCtl_GSP_R(determineUser);
        }
        return new AccessCtl_Deny("Not supported for graph level access control: " + op.getDescription());
    }
}

