/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.main.sys.JettyLib;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static Logger LOG = LoggerFactory.getLogger((String)"HTTP");
    protected final Server server;
    protected int port;

    public static Builder create() {
        return new Builder();
    }

    protected JettyServer(int port, Server server) {
        this.server = server;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Server getJettyServer() {
        return this.server;
    }

    public ServletContext getServletContext() {
        return ((ServletContextHandler)this.server.getHandler()).getServletContext();
    }

    public JettyServer start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.port == 0) {
            this.port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        }
        this.logStart();
        return this;
    }

    protected void logStart() {
        LOG.info("Start (port=" + this.port + ")");
    }

    public void stop() {
        this.logStop();
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void logStop() {
        LOG.info("Stop (port=" + this.port + ")");
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Server jettyServer(String jettyConfig) {
        try {
            Server server = new Server();
            Resource configXml = JettyLib.newResource(jettyConfig);
            XmlConfiguration configuration = new XmlConfiguration(configXml);
            configuration.configure((Object)server);
            return server;
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("JettyServer: Failed to configure server: " + ex.getMessage(), (Throwable)ex);
            throw new JettyConfigException("Failed to configure a server using configuration file '" + jettyConfig + "'");
        }
    }

    public static Server jettyServer(int minThreads, int maxThreads) {
        QueuedThreadPool threadPool = null;
        if (minThreads < 0) {
            minThreads = 2;
        }
        if (maxThreads < 0) {
            maxThreads = 20;
        }
        maxThreads = Math.max(minThreads, maxThreads);
        threadPool = new QueuedThreadPool(maxThreads, minThreads);
        Server server = new Server((ThreadPool)threadPool);
        return server;
    }

    private static void serverAddConnectors(Server server, int port, boolean loopback) {
        HttpConnectionFactory f1 = new HttpConnectionFactory();
        f1.getHttpConfiguration().setSendServerVersion(false);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{f1});
        connector.setPort(port);
        server.addConnector((Connector)connector);
        if (loopback) {
            connector.setHost("localhost");
        }
    }

    public static class Builder {
        private int port = -1;
        private int minThreads = -1;
        private int maxThreads = -1;
        private boolean loopback = false;
        private String jettyServerConfig = null;
        protected boolean verbose = false;
        private List<Pair<String, HttpServlet>> servlets = new ArrayList<Pair<String, HttpServlet>>();
        private List<Pair<String, Filter>> filters = new ArrayList<Pair<String, Filter>>();
        private String contextPath = "/";
        private String servletContextName = "Jetty";
        private String staticContentDir = null;
        private SecurityHandler securityHandler = null;
        private ErrorHandler errorHandler = new PlainErrorHandler();
        private Map<String, Object> servletAttr = new HashMap<String, Object>();

        public Builder port(int port) {
            if (port < 0) {
                throw new IllegalArgumentException("Illegal port=" + port + " : Port must be greater than or equal to zero.");
            }
            this.port = port;
            return this;
        }

        public Builder jettyServerConfig(String filename) {
            Objects.requireNonNull(filename, "filename");
            if (!FileOps.exists((String)filename)) {
                throw new JettyConfigException("File not found: " + filename);
            }
            this.jettyServerConfig = filename;
            return this;
        }

        public Builder contextPath(String path) {
            Objects.requireNonNull(path, "path");
            this.contextPath = path;
            return this;
        }

        public Builder servletContextName(String name) {
            Objects.requireNonNull(name, "name");
            this.servletContextName = name;
            return this;
        }

        public Builder loopback(boolean loopback) {
            this.loopback = loopback;
            return this;
        }

        public Builder staticFileBase(String directory) {
            Objects.requireNonNull(directory, "directory");
            this.staticContentDir = directory;
            return this;
        }

        public Builder securityHandler(SecurityHandler securityHandler) {
            Objects.requireNonNull(securityHandler, "securityHandler");
            this.securityHandler = securityHandler;
            return this;
        }

        public Builder errorHandler(ErrorHandler errorHandler) {
            Objects.requireNonNull(errorHandler, "securityHandler");
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder numServerThreads(int minThreads, int maxThreads) {
            if (minThreads >= 0 && maxThreads > 0 && minThreads > maxThreads) {
                throw new JettyConfigException(String.format("Bad thread setting: (min=%d, max=%d)", minThreads, maxThreads));
            }
            this.minThreads = minThreads;
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder maxServerThreads(int maxThreads) {
            if (this.minThreads > maxThreads) {
                throw new JettyConfigException(String.format("Bad thread setting: (min=%d, max=%d)", this.minThreads, maxThreads));
            }
            this.numServerThreads(this.minThreads, maxThreads);
            return this;
        }

        public Builder addServlet(String pathSpec, HttpServlet servlet) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(servlet, "servlet");
            this.servlets.add((Pair<String, HttpServlet>)Pair.create((Object)pathSpec, (Object)servlet));
            return this;
        }

        public Builder addServletAttribute(String attrName, Object value) {
            Objects.requireNonNull(attrName, "attrName");
            if (value != null) {
                this.servletAttr.put(attrName, value);
            } else {
                this.servletAttr.remove(attrName);
            }
            return this;
        }

        public Builder addFilter(String pathSpec, Filter filter) {
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(filter, "filter");
            this.filters.add((Pair<String, Filter>)Pair.create((Object)pathSpec, (Object)filter));
            return this;
        }

        public JettyServer build() {
            ServletContextHandler handler = this.buildServletContext();
            Server server = this.jettyServerConfig != null ? JettyServer.jettyServer(this.jettyServerConfig) : JettyServer.jettyServer(this.minThreads, this.maxThreads);
            JettyServer.serverAddConnectors(server, this.port, this.loopback);
            server.setHandler((Handler)handler);
            return new JettyServer(this.port, server);
        }

        private ServletContextHandler buildServletContext() {
            ServletContextHandler handler = this.buildServletContext(this.contextPath);
            ServletContext cxt = handler.getServletContext();
            this.adjustForFuseki(cxt);
            this.servletAttr.forEach((n, v) -> cxt.setAttribute(n, v));
            this.servletsAndFilters(handler);
            return handler;
        }

        private void adjustForFuseki(ServletContext cxt) {
            try {
                Fuseki.setVerbose((ServletContext)cxt, (boolean)this.verbose);
                OperationRegistry.set((ServletContext)cxt, (OperationRegistry)OperationRegistry.createEmpty());
                DataAccessPointRegistry.set((ServletContext)cxt, (DataAccessPointRegistry)new DataAccessPointRegistry());
            }
            catch (NoClassDefFoundError err) {
                LOG.info("Fuseki classes not found");
            }
        }

        private ServletContextHandler buildServletContext(String contextPath) {
            if (contextPath == null || ((String)contextPath).isEmpty()) {
                contextPath = "/";
            } else if (!((String)contextPath).startsWith("/")) {
                contextPath = "/" + (String)contextPath;
            }
            ServletContextHandler context = new ServletContextHandler();
            context.setDisplayName(this.servletContextName);
            context.setErrorHandler((Request.Handler)this.errorHandler);
            context.setContextPath((String)contextPath);
            if (this.securityHandler != null) {
                context.setSecurityHandler(this.securityHandler);
            }
            return context;
        }

        private void servletsAndFilters(ServletContextHandler context) {
            this.servlets.forEach(p -> Builder.addServlet(context, (String)p.getLeft(), (HttpServlet)p.getRight()));
            this.filters.forEach(p -> this.addFilter(context, (String)p.getLeft(), (Filter)p.getRight()));
            if (this.staticContentDir != null) {
                DefaultServlet staticServlet = new DefaultServlet();
                ServletHolder staticContent = new ServletHolder((Servlet)staticServlet);
                staticContent.setInitParameter("baseResource", this.staticContentDir);
                context.addServlet(staticContent, "/");
            }
        }

        protected static void addServlet(ServletContextHandler context, String pathspec, HttpServlet httpServlet) {
            ServletHolder sh = new ServletHolder((Servlet)httpServlet);
            context.addServlet(sh, pathspec);
        }

        protected void addFilter(ServletContextHandler context, String pathspec, Filter filter) {
            FilterHolder h = new FilterHolder(filter);
            context.addFilter(h, pathspec, null);
        }
    }

    public static class JettyConfigException
    extends FusekiConfigException {
        public JettyConfigException(String msg) {
            super(msg);
        }
    }

    public static class PlainErrorHandler
    extends ErrorHandler {
        protected boolean generateAcceptableResponse(Request request, Response response, Callback callback, String contentType, List<Charset> charsets, int code, String message, Throwable cause) throws IOException {
            System.err.println(">> plain:generateAcceptableResponse");
            if (contentType != null && contentType.equals("application/json")) {
                contentType = MimeTypes.Type.TEXT_PLAIN.asString();
            }
            try {
                boolean b = super.generateAcceptableResponse(request, response, callback, contentType, charsets, code, message, cause);
                System.err.println("<< plain:generateAcceptableResponse: " + b);
                return b;
            }
            catch (IllegalStateException ex) {
                System.err.println("<< plain:generateAcceptableResponse: IllegalStateException");
                ex.printStackTrace();
                return true;
            }
        }

        protected void generateResponse(Request request, Response response, int code, String message, Throwable cause, Callback callback) throws IOException {
            this.generateAcceptableResponse(request, response, callback, "text/plain", List.of(StandardCharsets.UTF_8), code, message, cause);
        }
    }
}

